/*
 * Generated by PEG.js 0.10.0.
 *
 * http://pegjs.org/
 */

"use strict";

function peg$subclass(child, parent) {
  function ctor() { this.constructor = child; }
  ctor.prototype = parent.prototype;
  child.prototype = new ctor();
}

function peg$SyntaxError(message, expected, found, location) {
  this.message  = message;
  this.expected = expected;
  this.found    = found;
  this.location = location;
  this.name     = "SyntaxError";

  if (typeof Error.captureStackTrace === "function") {
    Error.captureStackTrace(this, peg$SyntaxError);
  }
}

peg$subclass(peg$SyntaxError, Error);

peg$SyntaxError.buildMessage = function(expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
        literal: function(expectation) {
          return "\"" + literalEscape(expectation.text) + "\"";
        },

        "class": function(expectation) {
          var escapedParts = "",
              i;

          for (i = 0; i < expectation.parts.length; i++) {
            escapedParts += expectation.parts[i] instanceof Array
              ? classEscape(expectation.parts[i][0]) + "-" + classEscape(expectation.parts[i][1])
              : classEscape(expectation.parts[i]);
          }

          return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
        },

        any: function(expectation) {
          return "any character";
        },

        end: function(expectation) {
          return "end of input";
        },

        other: function(expectation) {
          return expectation.description;
        }
      };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s
      .replace(/\\/g, '\\\\')
      .replace(/"/g,  '\\"')
      .replace(/\0/g, '\\0')
      .replace(/\t/g, '\\t')
      .replace(/\n/g, '\\n')
      .replace(/\r/g, '\\r')
      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
  }

  function classEscape(s) {
    return s
      .replace(/\\/g, '\\\\')
      .replace(/\]/g, '\\]')
      .replace(/\^/g, '\\^')
      .replace(/-/g,  '\\-')
      .replace(/\0/g, '\\0')
      .replace(/\t/g, '\\t')
      .replace(/\n/g, '\\n')
      .replace(/\r/g, '\\r')
      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = new Array(expected.length),
        i, j;

    for (i = 0; i < expected.length; i++) {
      descriptions[i] = describeExpectation(expected[i]);
    }

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + " or " + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(", ")
          + ", or "
          + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
  }

  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$parse(input, options) {
  options = options !== void 0 ? options : {};

  var peg$FAILED = {},

      peg$startRuleFunctions = { query: peg$parsequery },
      peg$startRuleFunction  = peg$parsequery,

      peg$c0 = function(clauses) { return { pos: "expression", clauses: clauses !== null ? clauses : [] }; },
      peg$c1 = function(head, c) { return c; },
      peg$c2 = function(head, tail) { return [head].concat(tail); },
      peg$c3 = function(text_options) {
          return { pos: "text-clause", search: text_options.search };
        },
      peg$c4 = function(search) { return { search: search}; },
      peg$c5 = function(value) { return { value: value }; },
      peg$c6 = function(operator, expressions) { return { pos: "expression-tree-clause", operator: operator, expressions: expressions }; },
      peg$c7 = "$or",
      peg$c8 = peg$literalExpectation("$or", false),
      peg$c9 = "$nor",
      peg$c10 = peg$literalExpectation("$nor", false),
      peg$c11 = "$and",
      peg$c12 = peg$literalExpectation("$and", false),
      peg$c13 = function() { return { pos: "expression-clause" }; },
      peg$c14 = "$expr",
      peg$c15 = peg$literalExpectation("$expr", false),
      peg$c16 = function(head, e) { return e; },
      peg$c17 = function(expressions) { return expressions !== null ? expressions : []; },
      peg$c18 = function(value) { return {pos: "where-clause", type: "string", value: value }; },
      peg$c19 = function(key, value) { return { pos: "leaf-clause", key: key, value: value }; },
      peg$c20 = "$gte",
      peg$c21 = peg$literalExpectation("$gte", false),
      peg$c22 = "$gt",
      peg$c23 = peg$literalExpectation("$gt", false),
      peg$c24 = "$lte",
      peg$c25 = peg$literalExpectation("$lte", false),
      peg$c26 = "$lt",
      peg$c27 = peg$literalExpectation("$lt", false),
      peg$c28 = "$eq",
      peg$c29 = peg$literalExpectation("$eq", false),
      peg$c30 = "$ne",
      peg$c31 = peg$literalExpectation("$ne", false),
      peg$c32 = "$type",
      peg$c33 = peg$literalExpectation("$type", false),
      peg$c34 = "$size",
      peg$c35 = peg$literalExpectation("$size", false),
      peg$c36 = "$exists",
      peg$c37 = peg$literalExpectation("$exists", false),
      peg$c38 = "$bitsAllClear",
      peg$c39 = peg$literalExpectation("$bitsAllClear", false),
      peg$c40 = "$bitsAllSet",
      peg$c41 = peg$literalExpectation("$bitsAllSet", false),
      peg$c42 = "$bitsAnyClear",
      peg$c43 = peg$literalExpectation("$bitsAnyClear", false),
      peg$c44 = "$bitsAnySet",
      peg$c45 = peg$literalExpectation("$bitsAnySet", false),
      peg$c46 = "$in",
      peg$c47 = peg$literalExpectation("$in", false),
      peg$c48 = "$nin",
      peg$c49 = peg$literalExpectation("$nin", false),
      peg$c50 = "$all",
      peg$c51 = peg$literalExpectation("$all", false),
      peg$c52 = "$mod",
      peg$c53 = peg$literalExpectation("$mod", false),
      peg$c54 = "$not",
      peg$c55 = peg$literalExpectation("$not", false),
      peg$c56 = "$elemMatch",
      peg$c57 = peg$literalExpectation("$elemMatch", false),
      peg$c58 = function(operators) { return { pos: "operator-expression", operators: operators !== null ? operators : [] }; },
      peg$c59 = function(head, o) { return o; },
      peg$c60 = function(operator, value) { return { pos: "value-operator", operator: operator, value: value }; },
      peg$c61 = function(operator, values) { return { pos: "list-operator", operator: operator, values: values }; },
      peg$c62 = function(expression) { return { pos: "elemmatch-expression-operator", expression: expression } },
      peg$c63 = function(operator, opobject) { return { pos: "operator-expression-operator", operator: operator, operators: opobject.operators } },
      peg$c64 = function(regexobject) { return { pos: "operator-expression-operator", operator: "$not", operators: regexobject } },
      peg$c65 = "$geoWithin",
      peg$c66 = peg$literalExpectation("$geoWithin", false),
      peg$c67 = function(shape) { return { pos: "geo-within-operator", operator: "$geoWithin", shape: shape }; },
      peg$c68 = "$geoIntersects",
      peg$c69 = peg$literalExpectation("$geoIntersects", false),
      peg$c70 = function(geometry) { return { pos: "geo-intersects-operator", operator: "$geoIntersects", geometry: geometry }; },
      peg$c71 = "$nearSphere",
      peg$c72 = peg$literalExpectation("$nearSphere", false),
      peg$c73 = "$near",
      peg$c74 = peg$literalExpectation("$near", false),
      peg$c75 = function(near_operator, value) { return { pos: "near-operator", operator: near_operator, value: value }; },
      peg$c76 = function(operator, value) { return { pos: "distance-operator", operator: operator, value: value }; },
      peg$c77 = "$minDistance",
      peg$c78 = peg$literalExpectation("$minDistance", false),
      peg$c79 = "$maxDistance",
      peg$c80 = peg$literalExpectation("$maxDistance", false),
      peg$c81 = "$geometry",
      peg$c82 = peg$literalExpectation("$geometry", false),
      peg$c83 = "type",
      peg$c84 = peg$literalExpectation("type", false),
      peg$c85 = function(type) { return type; },
      peg$c86 = "coordinates",
      peg$c87 = peg$literalExpectation("coordinates", false),
      peg$c88 = function(type, coordinates) { return coordinates; },
      peg$c89 = function(type, coordinates) { return { "type": type, "coordinates": coordinates }; },
      peg$c90 = function(members) { return { "$geometry": members }; },
      peg$c91 = "Point",
      peg$c92 = peg$literalExpectation("Point", false),
      peg$c93 = function(geometry, operator, value) { 
                var result = {};
                result[operator] = value;
                return result;
              },
      peg$c94 = function(geometry, distance) {
            var result = distance || {};
            distance.$geometry = geometry;
            return result;
          },
      peg$c95 = "Polygon",
      peg$c96 = peg$literalExpectation("Polygon", false),
      peg$c97 = "MultiPolygon",
      peg$c98 = peg$literalExpectation("MultiPolygon", false),
      peg$c99 = function(head, v) { return v; },
      peg$c100 = "$centerSphere",
      peg$c101 = peg$literalExpectation("$centerSphere", false),
      peg$c102 = "$center",
      peg$c103 = peg$literalExpectation("$center", false),
      peg$c104 = function(center_operator, parameters) {
            var res = {};
            res[center_operator] = JSON.parse(parameters);
            return res;
          },
      peg$c105 = "$box",
      peg$c106 = peg$literalExpectation("$box", false),
      peg$c107 = function(parameters) { return {"$box": JSON.parse(parameters)}; },
      peg$c108 = "$polygon",
      peg$c109 = peg$literalExpectation("$polygon", false),
      peg$c110 = function(parameters) { return {"$polygon": JSON.parse(parameters)}; },
      peg$c111 = "$where",
      peg$c112 = peg$literalExpectation("$where", false),
      peg$c113 = "$text",
      peg$c114 = peg$literalExpectation("$text", false),
      peg$c115 = "$search",
      peg$c116 = peg$literalExpectation("$search", false),
      peg$c117 = "$language",
      peg$c118 = peg$literalExpectation("$language", false),
      peg$c119 = "$caseSensitive",
      peg$c120 = peg$literalExpectation("$caseSensitive", false),
      peg$c121 = "$diacriticSensitive",
      peg$c122 = peg$literalExpectation("$diacriticSensitive", false),
      peg$c123 = function(values) { return values !== null ? values : []; },
      peg$c124 = /^[^$]/,
      peg$c125 = peg$classExpectation(["$"], true, false),
      peg$c126 = /^[^\0"]/,
      peg$c127 = peg$classExpectation(["\0", "\""], true, false),
      peg$c128 = function(key) { return key[0] + key[1].join(''); },
      peg$c129 = function(value) { return { pos: 'leaf-value', value: value }; },
      peg$c130 = "[",
      peg$c131 = peg$literalExpectation("[", false),
      peg$c132 = "{",
      peg$c133 = peg$literalExpectation("{", false),
      peg$c134 = "]",
      peg$c135 = peg$literalExpectation("]", false),
      peg$c136 = "}",
      peg$c137 = peg$literalExpectation("}", false),
      peg$c138 = ":",
      peg$c139 = peg$literalExpectation(":", false),
      peg$c140 = ",",
      peg$c141 = peg$literalExpectation(",", false),
      peg$c142 = peg$otherExpectation("whitespace"),
      peg$c143 = /^[ \t\n\r]/,
      peg$c144 = peg$classExpectation([" ", "\t", "\n", "\r"], false, false),
      peg$c145 = "false",
      peg$c146 = peg$literalExpectation("false", false),
      peg$c147 = function() { return false; },
      peg$c148 = "null",
      peg$c149 = peg$literalExpectation("null", false),
      peg$c150 = function() { return null;  },
      peg$c151 = "true",
      peg$c152 = peg$literalExpectation("true", false),
      peg$c153 = function() { return true;  },
      peg$c154 = "$oid",
      peg$c155 = peg$literalExpectation("$oid", false),
      peg$c156 = function(string) { return {"$oid": string }; },
      peg$c157 = function(digits) { return digits.join(''); },
      peg$c158 = "$minKey",
      peg$c159 = peg$literalExpectation("$minKey", false),
      peg$c160 = "1",
      peg$c161 = peg$literalExpectation("1", false),
      peg$c162 = function() { return {"$minKey": 1 }; },
      peg$c163 = "$maxKey",
      peg$c164 = peg$literalExpectation("$maxKey", false),
      peg$c165 = function() { return {"$maxKey": 1 }; },
      peg$c166 = "$numberLong",
      peg$c167 = peg$literalExpectation("$numberLong", false),
      peg$c168 = function(digits) { return {"$numberLong": digits.join('') }; },
      peg$c169 = "$numberDecimal",
      peg$c170 = peg$literalExpectation("$numberDecimal", false),
      peg$c171 = function(number) { return {"$numberDecimal": number }; },
      peg$c172 = "$date",
      peg$c173 = peg$literalExpectation("$date", false),
      peg$c174 = function(date) { return {"$date": date }; },
      peg$c175 = function(date) { return date; },
      peg$c176 = "$undefined",
      peg$c177 = peg$literalExpectation("$undefined", false),
      peg$c178 = function() { return {"$undefined": true }; },
      peg$c179 = "$ref",
      peg$c180 = peg$literalExpectation("$ref", false),
      peg$c181 = function(string) { return string; },
      peg$c182 = "$id",
      peg$c183 = peg$literalExpectation("$id", false),
      peg$c184 = function(ref, value) {return value; },
      peg$c185 = "$db",
      peg$c186 = peg$literalExpectation("$db", false),
      peg$c187 = function(ref, id, string) {return string; },
      peg$c188 = function(ref, id, db) {
              var result = {"$ref": ref, "$id": id};
              if (db !== null) result["$db"] = db;
              return result;
            },
      peg$c189 = function(members) { return members; },
      peg$c190 = "$regex",
      peg$c191 = peg$literalExpectation("$regex", false),
      peg$c192 = "$options",
      peg$c193 = peg$literalExpectation("$options", false),
      peg$c194 = /^[gims]/,
      peg$c195 = peg$classExpectation(["g", "i", "m", "s"], false, false),
      peg$c196 = function(regex, options) {return options.join(''); },
      peg$c197 = function(regex, options) { return {"$regex": regex, "$options": options ? options : ""}; },
      peg$c198 = "$binary",
      peg$c199 = peg$literalExpectation("$binary", false),
      peg$c200 = function(binary, type) {return type; },
      peg$c201 = function(binary, type) { return {"$binary": binary, "$type": type}; },
      peg$c202 = "$timestamp",
      peg$c203 = peg$literalExpectation("$timestamp", false),
      peg$c204 = "t",
      peg$c205 = peg$literalExpectation("t", false),
      peg$c206 = "i",
      peg$c207 = peg$literalExpectation("i", false),
      peg$c208 = function(t, i) { return {"t": t, "i": i}; },
      peg$c209 = function(object) { return {"$timestamp": object }; },
      peg$c210 = function(head, m) { return m; },
      peg$c211 = function(head, tail) {
              var result = {};
              [head].concat(tail).forEach(function(element) {
                result[element.name] = element.value;
              });
              return result;
            },
      peg$c212 = function(members) { return members !== null ? members : {}; },
      peg$c213 = function(name, value) {
            return { name: name, value: value };
          },
      peg$c214 = peg$otherExpectation("number"),
      peg$c215 = function() { return parseFloat(text()); },
      peg$c216 = "180",
      peg$c217 = peg$literalExpectation("180", false),
      peg$c218 = /^[0-7]/,
      peg$c219 = peg$classExpectation([["0", "7"]], false, false),
      peg$c220 = "90",
      peg$c221 = peg$literalExpectation("90", false),
      peg$c222 = ".",
      peg$c223 = peg$literalExpectation(".", false),
      peg$c224 = /^[1-9]/,
      peg$c225 = peg$classExpectation([["1", "9"]], false, false),
      peg$c226 = /^[eE]/,
      peg$c227 = peg$classExpectation(["e", "E"], false, false),
      peg$c228 = "-",
      peg$c229 = peg$literalExpectation("-", false),
      peg$c230 = "+",
      peg$c231 = peg$literalExpectation("+", false),
      peg$c232 = "0",
      peg$c233 = peg$literalExpectation("0", false),
      peg$c234 = peg$otherExpectation("string"),
      peg$c235 = function(chars) { return chars.join(""); },
      peg$c236 = "\"",
      peg$c237 = peg$literalExpectation("\"", false),
      peg$c238 = "\\",
      peg$c239 = peg$literalExpectation("\\", false),
      peg$c240 = "/",
      peg$c241 = peg$literalExpectation("/", false),
      peg$c242 = "b",
      peg$c243 = peg$literalExpectation("b", false),
      peg$c244 = function() { return "\b"; },
      peg$c245 = "f",
      peg$c246 = peg$literalExpectation("f", false),
      peg$c247 = function() { return "\f"; },
      peg$c248 = "n",
      peg$c249 = peg$literalExpectation("n", false),
      peg$c250 = function() { return "\n"; },
      peg$c251 = "r",
      peg$c252 = peg$literalExpectation("r", false),
      peg$c253 = function() { return "\r"; },
      peg$c254 = function() { return "\t"; },
      peg$c255 = "u",
      peg$c256 = peg$literalExpectation("u", false),
      peg$c257 = function(digits) { return String.fromCharCode(parseInt(digits, 16)); },
      peg$c258 = function(sequence) { return sequence; },
      peg$c259 = /^[^\0-\x1F"\\]/,
      peg$c260 = peg$classExpectation([["\0", "\x1F"], "\"", "\\"], true, false),
      peg$c261 = /^[0-9]/,
      peg$c262 = peg$classExpectation([["0", "9"]], false, false),
      peg$c263 = /^[0-9a-f]/i,
      peg$c264 = peg$classExpectation([["0", "9"], ["a", "f"]], false, true),
      peg$c265 = "--",
      peg$c266 = peg$literalExpectation("--", false),
      peg$c267 = "W",
      peg$c268 = peg$literalExpectation("W", false),
      peg$c269 = "---",
      peg$c270 = peg$literalExpectation("---", false),
      peg$c271 = "Z",
      peg$c272 = peg$literalExpectation("Z", false),
      peg$c273 = "T",
      peg$c274 = peg$literalExpectation("T", false),
      peg$c275 = "S",
      peg$c276 = peg$literalExpectation("S", false),
      peg$c277 = "M",
      peg$c278 = peg$literalExpectation("M", false),
      peg$c279 = "H",
      peg$c280 = peg$literalExpectation("H", false),
      peg$c281 = "D",
      peg$c282 = peg$literalExpectation("D", false),
      peg$c283 = "Y",
      peg$c284 = peg$literalExpectation("Y", false),
      peg$c285 = "P",
      peg$c286 = peg$literalExpectation("P", false),

      peg$currPos          = 0,
      peg$savedPos         = 0,
      peg$posDetailsCache  = [{ line: 1, column: 1 }],
      peg$maxFailPos       = 0,
      peg$maxFailExpected  = [],
      peg$silentFails      = 0,

      peg$result;

  if ("startRule" in options) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location
    );
  }

  function error(message, location) {
    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)

    throw peg$buildSimpleError(message, location);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$anyExpectation() {
    return { type: "any" };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos], p;

    if (details) {
      return details;
    } else {
      p = pos - 1;
      while (!peg$posDetailsCache[p]) {
        p--;
      }

      details = peg$posDetailsCache[p];
      details = {
        line:   details.line,
        column: details.column
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;
      return details;
    }
  }

  function peg$computeLocation(startPos, endPos) {
    var startPosDetails = peg$computePosDetails(startPos),
        endPosDetails   = peg$computePosDetails(endPos);

    return {
      start: {
        offset: startPos,
        line:   startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line:   endPosDetails.line,
        column: endPosDetails.column
      }
    };
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) { return; }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(
      peg$SyntaxError.buildMessage(expected, found),
      expected,
      found,
      location
    );
  }

  function peg$parsequery() {
    var s0;

    s0 = peg$parseexpression();

    return s0;
  }

  function peg$parseexpression() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseclause_list();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseend_object();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c0(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseclause_list() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseclause();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parsevalue_separator();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseclause();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s3;
          s4 = peg$c1(s1, s5);
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parsevalue_separator();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseclause();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s3;
            s4 = peg$c1(s1, s5);
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c2(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = null;
    }

    return s0;
  }

  function peg$parseclause() {
    var s0;

    s0 = peg$parseleaf_clause();
    if (s0 === peg$FAILED) {
      s0 = peg$parseexpression_tree_clause();
      if (s0 === peg$FAILED) {
        s0 = peg$parseexpression_clause();
        if (s0 === peg$FAILED) {
          s0 = peg$parsewhere_clause();
          if (s0 === peg$FAILED) {
            s0 = peg$parsetext_clause();
          }
        }
      }
    }

    return s0;
  }

  function peg$parsetext_clause() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsequotation_mark();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsetext_operator();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsequotation_mark();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsename_separator();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsetext_options();
            if (s5 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c3(s5);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetext_options() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsesearch_operator();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsestring();
              if (s6 !== peg$FAILED) {
                s7 = peg$currPos;
                s8 = peg$parsevalue_separator();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parsetext_options_optional();
                  if (s9 !== peg$FAILED) {
                    s8 = [s8, s9];
                    s7 = s8;
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
                if (s7 === peg$FAILED) {
                  s7 = null;
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseend_object();
                  if (s8 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c4(s6);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetext_options_value() {
    var s0;

    s0 = peg$parsestring();
    if (s0 === peg$FAILED) {
      s0 = peg$parsetrue();
      if (s0 === peg$FAILED) {
        s0 = peg$parsefalse();
      }
    }

    return s0;
  }

  function peg$parsetext_options_optional() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = [];
    s1 = peg$currPos;
    s2 = peg$parsequotation_mark();
    if (s2 !== peg$FAILED) {
      s3 = peg$parsetext_optional_operator();
      if (s3 !== peg$FAILED) {
        s4 = peg$parsequotation_mark();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsename_separator();
          if (s5 !== peg$FAILED) {
            s6 = peg$parsetext_options_value();
            if (s6 !== peg$FAILED) {
              peg$savedPos = s1;
              s2 = peg$c5(s6);
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = peg$currPos;
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsetext_optional_operator();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsetext_options_value();
              if (s6 !== peg$FAILED) {
                peg$savedPos = s1;
                s2 = peg$c5(s6);
                s1 = s2;
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseexpression_tree_clause() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsequotation_mark();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseexpression_tree_operator();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsequotation_mark();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsename_separator();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsebegin_array();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseexpression_list();
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_array();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c6(s2, s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexpression_tree_operator() {
    var s0;

    if (input.substr(peg$currPos, 3) === peg$c7) {
      s0 = peg$c7;
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c8); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 4) === peg$c9) {
        s0 = peg$c9;
        peg$currPos += 4;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c10); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c11) {
          s0 = peg$c11;
          peg$currPos += 4;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c12); }
        }
      }
    }

    return s0;
  }

  function peg$parseexpression_clause() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsequotation_mark();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseexpression_operator();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsequotation_mark();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsename_separator();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsebegin_object();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseoperator();
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_object();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c13();
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexpression_operator() {
    var s0;

    if (input.substr(peg$currPos, 5) === peg$c14) {
      s0 = peg$c14;
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c15); }
    }

    return s0;
  }

  function peg$parseexpression_list() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseexpression();
    if (s2 !== peg$FAILED) {
      s3 = [];
      s4 = peg$currPos;
      s5 = peg$parsevalue_separator();
      if (s5 !== peg$FAILED) {
        s6 = peg$parseexpression();
        if (s6 !== peg$FAILED) {
          peg$savedPos = s4;
          s5 = peg$c16(s2, s6);
          s4 = s5;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$currPos;
        s5 = peg$parsevalue_separator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parseexpression();
          if (s6 !== peg$FAILED) {
            peg$savedPos = s4;
            s5 = peg$c16(s2, s6);
            s4 = s5;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s1;
        s2 = peg$c2(s2, s3);
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c17(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsewhere_clause() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsequotation_mark();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsewhere_operator();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsequotation_mark();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsename_separator();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsestring();
            if (s5 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c18(s5);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseleaf_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsekey();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsename_separator();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsevalue();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c19(s1, s3);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsevalue() {
    var s0;

    s0 = peg$parseoperator_expression();
    if (s0 === peg$FAILED) {
      s0 = peg$parseJSON();
    }

    return s0;
  }

  function peg$parsevalue_operator() {
    var s0;

    if (input.substr(peg$currPos, 4) === peg$c20) {
      s0 = peg$c20;
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c21); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 3) === peg$c22) {
        s0 = peg$c22;
        peg$currPos += 3;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c23); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c24) {
          s0 = peg$c24;
          peg$currPos += 4;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c25); }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c26) {
            s0 = peg$c26;
            peg$currPos += 3;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c27); }
          }
          if (s0 === peg$FAILED) {
            if (input.substr(peg$currPos, 3) === peg$c28) {
              s0 = peg$c28;
              peg$currPos += 3;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c29); }
            }
            if (s0 === peg$FAILED) {
              if (input.substr(peg$currPos, 3) === peg$c30) {
                s0 = peg$c30;
                peg$currPos += 3;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c31); }
              }
              if (s0 === peg$FAILED) {
                if (input.substr(peg$currPos, 5) === peg$c32) {
                  s0 = peg$c32;
                  peg$currPos += 5;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c33); }
                }
                if (s0 === peg$FAILED) {
                  if (input.substr(peg$currPos, 5) === peg$c34) {
                    s0 = peg$c34;
                    peg$currPos += 5;
                  } else {
                    s0 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c35); }
                  }
                  if (s0 === peg$FAILED) {
                    if (input.substr(peg$currPos, 7) === peg$c36) {
                      s0 = peg$c36;
                      peg$currPos += 7;
                    } else {
                      s0 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c37); }
                    }
                    if (s0 === peg$FAILED) {
                      if (input.substr(peg$currPos, 13) === peg$c38) {
                        s0 = peg$c38;
                        peg$currPos += 13;
                      } else {
                        s0 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c39); }
                      }
                      if (s0 === peg$FAILED) {
                        if (input.substr(peg$currPos, 11) === peg$c40) {
                          s0 = peg$c40;
                          peg$currPos += 11;
                        } else {
                          s0 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c41); }
                        }
                        if (s0 === peg$FAILED) {
                          if (input.substr(peg$currPos, 13) === peg$c42) {
                            s0 = peg$c42;
                            peg$currPos += 13;
                          } else {
                            s0 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c43); }
                          }
                          if (s0 === peg$FAILED) {
                            if (input.substr(peg$currPos, 11) === peg$c44) {
                              s0 = peg$c44;
                              peg$currPos += 11;
                            } else {
                              s0 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c45); }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parselist_operator() {
    var s0;

    if (input.substr(peg$currPos, 3) === peg$c46) {
      s0 = peg$c46;
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c47); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 4) === peg$c48) {
        s0 = peg$c48;
        peg$currPos += 4;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c49); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c50) {
          s0 = peg$c50;
          peg$currPos += 4;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c51); }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 4) === peg$c52) {
            s0 = peg$c52;
            peg$currPos += 4;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c53); }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseoperator_expression_operator() {
    var s0;

    if (input.substr(peg$currPos, 4) === peg$c54) {
      s0 = peg$c54;
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c55); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 10) === peg$c56) {
        s0 = peg$c56;
        peg$currPos += 10;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c57); }
      }
    }

    return s0;
  }

  function peg$parseoperator_expression() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseoperator_list();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseend_object();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c58(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseoperator_list() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseoperator();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parsevalue_separator();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseoperator();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s3;
          s4 = peg$c59(s1, s5);
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parsevalue_separator();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseoperator();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s3;
            s4 = peg$c59(s1, s5);
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c2(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseoperator() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsequotation_mark();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsevalue_operator();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsequotation_mark();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsename_separator();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseJSON();
            if (s5 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c60(s2, s5);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsequotation_mark();
      if (s1 !== peg$FAILED) {
        s2 = peg$parselist_operator();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsequotation_mark();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsename_separator();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsebegin_array();
              if (s5 !== peg$FAILED) {
                s6 = peg$parseleaf_value_list();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parseend_array();
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c61(s2, s6);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsequotation_mark();
        if (s1 !== peg$FAILED) {
          if (input.substr(peg$currPos, 10) === peg$c56) {
            s2 = peg$c56;
            peg$currPos += 10;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c57); }
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parsequotation_mark();
            if (s3 !== peg$FAILED) {
              s4 = peg$parsename_separator();
              if (s4 !== peg$FAILED) {
                s5 = peg$parseexpression();
                if (s5 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c62(s5);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parsequotation_mark();
          if (s1 !== peg$FAILED) {
            s2 = peg$parseoperator_expression_operator();
            if (s2 !== peg$FAILED) {
              s3 = peg$parsequotation_mark();
              if (s3 !== peg$FAILED) {
                s4 = peg$parsename_separator();
                if (s4 !== peg$FAILED) {
                  s5 = peg$parseoperator_expression();
                  if (s5 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c63(s2, s5);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parsequotation_mark();
            if (s1 !== peg$FAILED) {
              if (input.substr(peg$currPos, 4) === peg$c54) {
                s2 = peg$c54;
                peg$currPos += 4;
              } else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c55); }
              }
              if (s2 !== peg$FAILED) {
                s3 = peg$parsequotation_mark();
                if (s3 !== peg$FAILED) {
                  s4 = peg$parsename_separator();
                  if (s4 !== peg$FAILED) {
                    s5 = peg$parseejson_regex();
                    if (s5 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$c64(s5);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parsequotation_mark();
              if (s1 !== peg$FAILED) {
                if (input.substr(peg$currPos, 10) === peg$c65) {
                  s2 = peg$c65;
                  peg$currPos += 10;
                } else {
                  s2 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c66); }
                }
                if (s2 !== peg$FAILED) {
                  s3 = peg$parsequotation_mark();
                  if (s3 !== peg$FAILED) {
                    s4 = peg$parsename_separator();
                    if (s4 !== peg$FAILED) {
                      s5 = peg$parseshape();
                      if (s5 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c67(s5);
                        s0 = s1;
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = peg$parsequotation_mark();
                if (s1 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 14) === peg$c68) {
                    s2 = peg$c68;
                    peg$currPos += 14;
                  } else {
                    s2 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c69); }
                  }
                  if (s2 !== peg$FAILED) {
                    s3 = peg$parsequotation_mark();
                    if (s3 !== peg$FAILED) {
                      s4 = peg$parsename_separator();
                      if (s4 !== peg$FAILED) {
                        s5 = peg$parsegeometry();
                        if (s5 !== peg$FAILED) {
                          peg$savedPos = s0;
                          s1 = peg$c70(s5);
                          s0 = s1;
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
                if (s0 === peg$FAILED) {
                  s0 = peg$currPos;
                  s1 = peg$parsequotation_mark();
                  if (s1 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 11) === peg$c71) {
                      s2 = peg$c71;
                      peg$currPos += 11;
                    } else {
                      s2 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c72); }
                    }
                    if (s2 === peg$FAILED) {
                      if (input.substr(peg$currPos, 5) === peg$c73) {
                        s2 = peg$c73;
                        peg$currPos += 5;
                      } else {
                        s2 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c74); }
                      }
                    }
                    if (s2 !== peg$FAILED) {
                      s3 = peg$parsequotation_mark();
                      if (s3 !== peg$FAILED) {
                        s4 = peg$parsename_separator();
                        if (s4 !== peg$FAILED) {
                          s5 = peg$parsegeometry_point();
                          if (s5 === peg$FAILED) {
                            s5 = peg$parselegacy_coordinates();
                          }
                          if (s5 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c75(s2, s5);
                            s0 = s1;
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                  if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    s1 = peg$parsequotation_mark();
                    if (s1 !== peg$FAILED) {
                      s2 = peg$parsedistance_operator();
                      if (s2 !== peg$FAILED) {
                        s3 = peg$parsequotation_mark();
                        if (s3 !== peg$FAILED) {
                          s4 = peg$parsename_separator();
                          if (s4 !== peg$FAILED) {
                            s5 = peg$parsenumber_positive();
                            if (s5 !== peg$FAILED) {
                              peg$savedPos = s0;
                              s1 = peg$c76(s2, s5);
                              s0 = s1;
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsedistance_operator() {
    var s0;

    if (input.substr(peg$currPos, 12) === peg$c77) {
      s0 = peg$c77;
      peg$currPos += 12;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c78); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 12) === peg$c79) {
        s0 = peg$c79;
        peg$currPos += 12;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c80); }
      }
    }

    return s0;
  }

  function peg$parseshape() {
    var s0;

    s0 = peg$parsegeometry();
    if (s0 === peg$FAILED) {
      s0 = peg$parselegacy_shape();
    }

    return s0;
  }

  function peg$parsegeometry() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 9) === peg$c81) {
          s3 = peg$c81;
          peg$currPos += 9;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c82); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsebegin_object();
              if (s6 !== peg$FAILED) {
                s7 = peg$currPos;
                s8 = peg$currPos;
                s9 = peg$parsequotation_mark();
                if (s9 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 4) === peg$c83) {
                    s10 = peg$c83;
                    peg$currPos += 4;
                  } else {
                    s10 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c84); }
                  }
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parsequotation_mark();
                    if (s11 !== peg$FAILED) {
                      s12 = peg$parsename_separator();
                      if (s12 !== peg$FAILED) {
                        s13 = peg$parsequotation_mark();
                        if (s13 !== peg$FAILED) {
                          s14 = peg$parsegeometry_type();
                          if (s14 !== peg$FAILED) {
                            s15 = peg$parsequotation_mark();
                            if (s15 !== peg$FAILED) {
                              peg$savedPos = s8;
                              s9 = peg$c85(s14);
                              s8 = s9;
                            } else {
                              peg$currPos = s8;
                              s8 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s8;
                            s8 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s8;
                          s8 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s8;
                        s8 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s8;
                      s8 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s8;
                    s8 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
                if (s8 !== peg$FAILED) {
                  s9 = peg$currPos;
                  s10 = peg$parsevalue_separator();
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parsequotation_mark();
                    if (s11 !== peg$FAILED) {
                      if (input.substr(peg$currPos, 11) === peg$c86) {
                        s12 = peg$c86;
                        peg$currPos += 11;
                      } else {
                        s12 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c87); }
                      }
                      if (s12 !== peg$FAILED) {
                        s13 = peg$parsequotation_mark();
                        if (s13 !== peg$FAILED) {
                          s14 = peg$parsename_separator();
                          if (s14 !== peg$FAILED) {
                            s15 = peg$parsegeometry_coordinates();
                            if (s15 !== peg$FAILED) {
                              peg$savedPos = s9;
                              s10 = peg$c88(s8, s15);
                              s9 = s10;
                            } else {
                              peg$currPos = s9;
                              s9 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s9;
                            s9 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s9;
                          s9 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s9;
                        s9 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                  if (s9 !== peg$FAILED) {
                    peg$savedPos = s7;
                    s8 = peg$c89(s8, s9);
                    s7 = s8;
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseend_object();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseend_object();
                    if (s9 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$c90(s7);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsegeometry_point() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 9) === peg$c81) {
          s3 = peg$c81;
          peg$currPos += 9;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c82); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsebegin_object();
              if (s6 !== peg$FAILED) {
                s7 = peg$currPos;
                s8 = peg$currPos;
                s9 = peg$parsequotation_mark();
                if (s9 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 4) === peg$c83) {
                    s10 = peg$c83;
                    peg$currPos += 4;
                  } else {
                    s10 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c84); }
                  }
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parsequotation_mark();
                    if (s11 !== peg$FAILED) {
                      s12 = peg$parsename_separator();
                      if (s12 !== peg$FAILED) {
                        s13 = peg$parsequotation_mark();
                        if (s13 !== peg$FAILED) {
                          if (input.substr(peg$currPos, 5) === peg$c91) {
                            s14 = peg$c91;
                            peg$currPos += 5;
                          } else {
                            s14 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c92); }
                          }
                          if (s14 !== peg$FAILED) {
                            s15 = peg$parsequotation_mark();
                            if (s15 !== peg$FAILED) {
                              peg$savedPos = s8;
                              s9 = peg$c85(s14);
                              s8 = s9;
                            } else {
                              peg$currPos = s8;
                              s8 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s8;
                            s8 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s8;
                          s8 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s8;
                        s8 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s8;
                      s8 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s8;
                    s8 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
                if (s8 !== peg$FAILED) {
                  s9 = peg$currPos;
                  s10 = peg$parsevalue_separator();
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parsequotation_mark();
                    if (s11 !== peg$FAILED) {
                      if (input.substr(peg$currPos, 11) === peg$c86) {
                        s12 = peg$c86;
                        peg$currPos += 11;
                      } else {
                        s12 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c87); }
                      }
                      if (s12 !== peg$FAILED) {
                        s13 = peg$parsequotation_mark();
                        if (s13 !== peg$FAILED) {
                          s14 = peg$parsename_separator();
                          if (s14 !== peg$FAILED) {
                            s15 = peg$parselegacy_coordinates();
                            if (s15 !== peg$FAILED) {
                              peg$savedPos = s9;
                              s10 = peg$c88(s8, s15);
                              s9 = s10;
                            } else {
                              peg$currPos = s9;
                              s9 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s9;
                            s9 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s9;
                          s9 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s9;
                        s9 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                  if (s9 !== peg$FAILED) {
                    peg$savedPos = s7;
                    s8 = peg$c89(s8, s9);
                    s7 = s8;
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseend_object();
                  if (s8 !== peg$FAILED) {
                    s9 = [];
                    s10 = peg$currPos;
                    s11 = peg$parsevalue_separator();
                    if (s11 !== peg$FAILED) {
                      s12 = peg$parsequotation_mark();
                      if (s12 !== peg$FAILED) {
                        s13 = peg$parsedistance_operator();
                        if (s13 !== peg$FAILED) {
                          s14 = peg$parsequotation_mark();
                          if (s14 !== peg$FAILED) {
                            s15 = peg$parsename_separator();
                            if (s15 !== peg$FAILED) {
                              s16 = peg$parsenumber_positive();
                              if (s16 !== peg$FAILED) {
                                peg$savedPos = s10;
                                s11 = peg$c93(s7, s13, s16);
                                s10 = s11;
                              } else {
                                peg$currPos = s10;
                                s10 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s10;
                              s10 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s10;
                            s10 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s10;
                          s10 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s10;
                        s10 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s10;
                      s10 = peg$FAILED;
                    }
                    while (s10 !== peg$FAILED) {
                      s9.push(s10);
                      s10 = peg$currPos;
                      s11 = peg$parsevalue_separator();
                      if (s11 !== peg$FAILED) {
                        s12 = peg$parsequotation_mark();
                        if (s12 !== peg$FAILED) {
                          s13 = peg$parsedistance_operator();
                          if (s13 !== peg$FAILED) {
                            s14 = peg$parsequotation_mark();
                            if (s14 !== peg$FAILED) {
                              s15 = peg$parsename_separator();
                              if (s15 !== peg$FAILED) {
                                s16 = peg$parsenumber_positive();
                                if (s16 !== peg$FAILED) {
                                  peg$savedPos = s10;
                                  s11 = peg$c93(s7, s13, s16);
                                  s10 = s11;
                                } else {
                                  peg$currPos = s10;
                                  s10 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s10;
                                s10 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s10;
                              s10 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s10;
                            s10 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s10;
                          s10 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s10;
                        s10 = peg$FAILED;
                      }
                    }
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parseend_object();
                      if (s10 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c94(s7, s9);
                        s0 = s1;
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsegeometry_type() {
    var s0;

    if (input.substr(peg$currPos, 7) === peg$c95) {
      s0 = peg$c95;
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c96); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 12) === peg$c97) {
        s0 = peg$c97;
        peg$currPos += 12;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c98); }
      }
    }

    return s0;
  }

  function peg$parsegeometry_coordinates() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsebegin_array();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parsenumber();
      if (s3 === peg$FAILED) {
        s3 = peg$parsegeometry_coordinates();
      }
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$currPos;
        s6 = peg$parsevalue_separator();
        if (s6 !== peg$FAILED) {
          s7 = peg$parsenumber();
          if (s7 === peg$FAILED) {
            s7 = peg$parsegeometry_coordinates();
          }
          if (s7 !== peg$FAILED) {
            peg$savedPos = s5;
            s6 = peg$c99(s3, s7);
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$currPos;
          s6 = peg$parsevalue_separator();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsenumber();
            if (s7 === peg$FAILED) {
              s7 = peg$parsegeometry_coordinates();
            }
            if (s7 !== peg$FAILED) {
              peg$savedPos = s5;
              s6 = peg$c99(s3, s7);
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        }
        if (s4 !== peg$FAILED) {
          peg$savedPos = s2;
          s3 = peg$c2(s3, s4);
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseend_array();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parselegacy_coordinates() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsebegin_array();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsenumber_longitude();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsevalue_separator();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsenumber_latitude();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseend_array();
            if (s5 !== peg$FAILED) {
              s1 = [s1, s2, s3, s4, s5];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parselegacy_shape() {
    var s0;

    s0 = peg$parsecenter_shape();
    if (s0 === peg$FAILED) {
      s0 = peg$parsepolygon_shape();
      if (s0 === peg$FAILED) {
        s0 = peg$parsebox_shape();
      }
    }

    return s0;
  }

  function peg$parsecenter_shape() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 13) === peg$c100) {
          s3 = peg$c100;
          peg$currPos += 13;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c101); }
        }
        if (s3 === peg$FAILED) {
          if (input.substr(peg$currPos, 7) === peg$c102) {
            s3 = peg$c102;
            peg$currPos += 7;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c103); }
          }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = peg$currPos;
              s8 = peg$parsebegin_array();
              if (s8 !== peg$FAILED) {
                s9 = peg$parsebegin_array();
                if (s9 !== peg$FAILED) {
                  s10 = peg$parsenumber();
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parsevalue_separator();
                    if (s11 !== peg$FAILED) {
                      s12 = peg$parsenumber();
                      if (s12 !== peg$FAILED) {
                        s13 = peg$parseend_array();
                        if (s13 !== peg$FAILED) {
                          s14 = peg$parsevalue_separator();
                          if (s14 !== peg$FAILED) {
                            s15 = peg$parsenumber();
                            if (s15 !== peg$FAILED) {
                              s16 = peg$parseend_array();
                              if (s16 !== peg$FAILED) {
                                s8 = [s8, s9, s10, s11, s12, s13, s14, s15, s16];
                                s7 = s8;
                              } else {
                                peg$currPos = s7;
                                s7 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s7;
                              s7 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s7;
                            s7 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s7;
                          s7 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s7;
                        s7 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s7;
                      s7 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
              if (s7 !== peg$FAILED) {
                s6 = input.substring(s6, peg$currPos);
              } else {
                s6 = s7;
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_object();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c104(s3, s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsebox_shape() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c105) {
          s3 = peg$c105;
          peg$currPos += 4;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c106); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = peg$currPos;
              s8 = peg$parsebegin_array();
              if (s8 !== peg$FAILED) {
                s9 = peg$parsebegin_array();
                if (s9 !== peg$FAILED) {
                  s10 = peg$parsenumber();
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parsevalue_separator();
                    if (s11 !== peg$FAILED) {
                      s12 = peg$parsenumber();
                      if (s12 !== peg$FAILED) {
                        s13 = peg$parseend_array();
                        if (s13 !== peg$FAILED) {
                          s14 = peg$parsevalue_separator();
                          if (s14 !== peg$FAILED) {
                            s15 = peg$parsebegin_array();
                            if (s15 !== peg$FAILED) {
                              s16 = peg$parsenumber();
                              if (s16 !== peg$FAILED) {
                                s17 = peg$parsevalue_separator();
                                if (s17 !== peg$FAILED) {
                                  s18 = peg$parsenumber();
                                  if (s18 !== peg$FAILED) {
                                    s19 = peg$parseend_array();
                                    if (s19 !== peg$FAILED) {
                                      s20 = peg$parseend_array();
                                      if (s20 !== peg$FAILED) {
                                        s8 = [s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20];
                                        s7 = s8;
                                      } else {
                                        peg$currPos = s7;
                                        s7 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s7;
                                      s7 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s7;
                                    s7 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s7;
                                  s7 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s7;
                                s7 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s7;
                              s7 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s7;
                            s7 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s7;
                          s7 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s7;
                        s7 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s7;
                      s7 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
              if (s7 !== peg$FAILED) {
                s6 = input.substring(s6, peg$currPos);
              } else {
                s6 = s7;
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_object();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c107(s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsepolygon_shape() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 8) === peg$c108) {
          s3 = peg$c108;
          peg$currPos += 8;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c109); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = peg$currPos;
              s8 = peg$parsebegin_array();
              if (s8 !== peg$FAILED) {
                s9 = peg$currPos;
                s10 = peg$parsebegin_array();
                if (s10 !== peg$FAILED) {
                  s11 = peg$parsenumber();
                  if (s11 !== peg$FAILED) {
                    s12 = peg$parsevalue_separator();
                    if (s12 !== peg$FAILED) {
                      s13 = peg$parsenumber();
                      if (s13 !== peg$FAILED) {
                        s14 = peg$parseend_array();
                        if (s14 !== peg$FAILED) {
                          s10 = [s10, s11, s12, s13, s14];
                          s9 = s10;
                        } else {
                          peg$currPos = s9;
                          s9 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s9;
                        s9 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
                if (s9 !== peg$FAILED) {
                  s10 = [];
                  s11 = peg$currPos;
                  s12 = peg$parsevalue_separator();
                  if (s12 !== peg$FAILED) {
                    s13 = peg$parsebegin_array();
                    if (s13 !== peg$FAILED) {
                      s14 = peg$parsenumber();
                      if (s14 !== peg$FAILED) {
                        s15 = peg$parsevalue_separator();
                        if (s15 !== peg$FAILED) {
                          s16 = peg$parsenumber();
                          if (s16 !== peg$FAILED) {
                            s17 = peg$parseend_array();
                            if (s17 !== peg$FAILED) {
                              s12 = [s12, s13, s14, s15, s16, s17];
                              s11 = s12;
                            } else {
                              peg$currPos = s11;
                              s11 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s11;
                            s11 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s11;
                          s11 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s11;
                        s11 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s11;
                      s11 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s11;
                    s11 = peg$FAILED;
                  }
                  while (s11 !== peg$FAILED) {
                    s10.push(s11);
                    s11 = peg$currPos;
                    s12 = peg$parsevalue_separator();
                    if (s12 !== peg$FAILED) {
                      s13 = peg$parsebegin_array();
                      if (s13 !== peg$FAILED) {
                        s14 = peg$parsenumber();
                        if (s14 !== peg$FAILED) {
                          s15 = peg$parsevalue_separator();
                          if (s15 !== peg$FAILED) {
                            s16 = peg$parsenumber();
                            if (s16 !== peg$FAILED) {
                              s17 = peg$parseend_array();
                              if (s17 !== peg$FAILED) {
                                s12 = [s12, s13, s14, s15, s16, s17];
                                s11 = s12;
                              } else {
                                peg$currPos = s11;
                                s11 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s11;
                              s11 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s11;
                            s11 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s11;
                          s11 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s11;
                        s11 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s11;
                      s11 = peg$FAILED;
                    }
                  }
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parseend_array();
                    if (s11 !== peg$FAILED) {
                      peg$savedPos = s7;
                      s8 = peg$c2(s9, s10);
                      s7 = s8;
                    } else {
                      peg$currPos = s7;
                      s7 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
              if (s7 !== peg$FAILED) {
                s6 = input.substring(s6, peg$currPos);
              } else {
                s6 = s7;
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_object();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c110(s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewhere_operator() {
    var s0;

    if (input.substr(peg$currPos, 6) === peg$c111) {
      s0 = peg$c111;
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c112); }
    }

    return s0;
  }

  function peg$parsetext_operator() {
    var s0;

    if (input.substr(peg$currPos, 5) === peg$c113) {
      s0 = peg$c113;
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c114); }
    }

    return s0;
  }

  function peg$parsesearch_operator() {
    var s0;

    if (input.substr(peg$currPos, 7) === peg$c115) {
      s0 = peg$c115;
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c116); }
    }

    return s0;
  }

  function peg$parsetext_optional_operator() {
    var s0;

    if (input.substr(peg$currPos, 9) === peg$c117) {
      s0 = peg$c117;
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c118); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 14) === peg$c119) {
        s0 = peg$c119;
        peg$currPos += 14;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c120); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 19) === peg$c121) {
          s0 = peg$c121;
          peg$currPos += 19;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c122); }
        }
      }
    }

    return s0;
  }

  function peg$parsecase_sensitive_operator() {
    var s0;

    if (input.substr(peg$currPos, 14) === peg$c119) {
      s0 = peg$c119;
      peg$currPos += 14;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c120); }
    }

    return s0;
  }

  function peg$parsediacritic_sensitive_operator() {
    var s0;

    if (input.substr(peg$currPos, 19) === peg$c121) {
      s0 = peg$c121;
      peg$currPos += 19;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c122); }
    }

    return s0;
  }

  function peg$parseleaf_value_list() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseJSON();
    if (s2 !== peg$FAILED) {
      s3 = [];
      s4 = peg$currPos;
      s5 = peg$parsevalue_separator();
      if (s5 !== peg$FAILED) {
        s6 = peg$parseJSON();
        if (s6 !== peg$FAILED) {
          peg$savedPos = s4;
          s5 = peg$c99(s2, s6);
          s4 = s5;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$currPos;
        s5 = peg$parsevalue_separator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parseJSON();
          if (s6 !== peg$FAILED) {
            peg$savedPos = s4;
            s5 = peg$c99(s2, s6);
            s4 = s5;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s1;
        s2 = peg$c2(s2, s3);
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c123(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsekey() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsequotation_mark();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      if (peg$c124.test(input.charAt(peg$currPos))) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c125); }
      }
      if (s3 !== peg$FAILED) {
        s4 = [];
        if (peg$c126.test(input.charAt(peg$currPos))) {
          s5 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c127); }
        }
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          if (peg$c126.test(input.charAt(peg$currPos))) {
            s5 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c127); }
          }
        }
        if (s4 !== peg$FAILED) {
          s3 = [s3, s4];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsequotation_mark();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c128(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseJSON() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseleaf_value();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c129(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsebegin_array() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 91) {
        s2 = peg$c130;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c131); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsebegin_object() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 123) {
        s2 = peg$c132;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c133); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseend_array() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 93) {
        s2 = peg$c134;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c135); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseend_object() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 125) {
        s2 = peg$c136;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c137); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsename_separator() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 58) {
        s2 = peg$c138;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c139); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsevalue_separator() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 44) {
        s2 = peg$c140;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c141); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parse_() {
    var s0, s1;

    peg$silentFails++;
    s0 = [];
    if (peg$c143.test(input.charAt(peg$currPos))) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c144); }
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      if (peg$c143.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c144); }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c142); }
    }

    return s0;
  }

  function peg$parseleaf_value() {
    var s0;

    s0 = peg$parsefalse();
    if (s0 === peg$FAILED) {
      s0 = peg$parsenull();
      if (s0 === peg$FAILED) {
        s0 = peg$parsetrue();
        if (s0 === peg$FAILED) {
          s0 = peg$parseobject();
          if (s0 === peg$FAILED) {
            s0 = peg$parsearray();
            if (s0 === peg$FAILED) {
              s0 = peg$parsenumber();
              if (s0 === peg$FAILED) {
                s0 = peg$parsestring();
                if (s0 === peg$FAILED) {
                  s0 = peg$parseextended_json_value();
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsefalse() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5) === peg$c145) {
      s1 = peg$c145;
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c146); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c147();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsenull() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4) === peg$c148) {
      s1 = peg$c148;
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c149); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c150();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsetrue() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4) === peg$c151) {
      s1 = peg$c151;
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c152); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c153();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseextended_json_value() {
    var s0;

    s0 = peg$parseejson_regex();
    if (s0 === peg$FAILED) {
      s0 = peg$parseejson_objectid();
      if (s0 === peg$FAILED) {
        s0 = peg$parseejson_minkey();
        if (s0 === peg$FAILED) {
          s0 = peg$parseejson_maxkey();
          if (s0 === peg$FAILED) {
            s0 = peg$parseejson_long();
            if (s0 === peg$FAILED) {
              s0 = peg$parseejson_decimal();
              if (s0 === peg$FAILED) {
                s0 = peg$parseejson_date();
                if (s0 === peg$FAILED) {
                  s0 = peg$parseejson_timestamp();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parseejson_binary();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parseejson_dbref();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parseejson_undefined();
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseejson_objectid() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c154) {
          s3 = peg$c154;
          peg$currPos += 4;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c155); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsequotation_mark();
              if (s6 !== peg$FAILED) {
                s7 = peg$parsehexdig24();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsequotation_mark();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseend_object();
                    if (s9 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$c156(s7);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsehexdig24() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22, s23, s24, s25;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseHEXDIG();
    if (s2 !== peg$FAILED) {
      s3 = peg$parseHEXDIG();
      if (s3 !== peg$FAILED) {
        s4 = peg$parseHEXDIG();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseHEXDIG();
          if (s5 !== peg$FAILED) {
            s6 = peg$parseHEXDIG();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseHEXDIG();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseHEXDIG();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parseHEXDIG();
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parseHEXDIG();
                    if (s10 !== peg$FAILED) {
                      s11 = peg$parseHEXDIG();
                      if (s11 !== peg$FAILED) {
                        s12 = peg$parseHEXDIG();
                        if (s12 !== peg$FAILED) {
                          s13 = peg$parseHEXDIG();
                          if (s13 !== peg$FAILED) {
                            s14 = peg$parseHEXDIG();
                            if (s14 !== peg$FAILED) {
                              s15 = peg$parseHEXDIG();
                              if (s15 !== peg$FAILED) {
                                s16 = peg$parseHEXDIG();
                                if (s16 !== peg$FAILED) {
                                  s17 = peg$parseHEXDIG();
                                  if (s17 !== peg$FAILED) {
                                    s18 = peg$parseHEXDIG();
                                    if (s18 !== peg$FAILED) {
                                      s19 = peg$parseHEXDIG();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parseHEXDIG();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parseHEXDIG();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parseHEXDIG();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parseHEXDIG();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parseHEXDIG();
                                                if (s24 !== peg$FAILED) {
                                                  s25 = peg$parseHEXDIG();
                                                  if (s25 !== peg$FAILED) {
                                                    s2 = [s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22, s23, s24, s25];
                                                    s1 = s2;
                                                  } else {
                                                    peg$currPos = s1;
                                                    s1 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s1;
                                                  s1 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s1;
                                                s1 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s1;
                                              s1 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s1;
                                            s1 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s1;
                                          s1 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s1;
                                        s1 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s1;
                                      s1 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s1;
                                    s1 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s1;
                                  s1 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s1;
                                s1 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s1;
                              s1 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s1;
                            s1 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s1;
                          s1 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s1;
                        s1 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s1;
                      s1 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s1;
                    s1 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s1;
                  s1 = peg$FAILED;
                }
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c157(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseejson_minkey() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 7) === peg$c158) {
          s3 = peg$c158;
          peg$currPos += 7;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c159); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 49) {
                s6 = peg$c160;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c161); }
              }
              if (s6 === peg$FAILED) {
                if (input.substr(peg$currPos, 4) === peg$c151) {
                  s6 = peg$c151;
                  peg$currPos += 4;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c152); }
                }
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_object();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c162();
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseejson_maxkey() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 7) === peg$c163) {
          s3 = peg$c163;
          peg$currPos += 7;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c164); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 49) {
                s6 = peg$c160;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c161); }
              }
              if (s6 === peg$FAILED) {
                if (input.substr(peg$currPos, 4) === peg$c151) {
                  s6 = peg$c151;
                  peg$currPos += 4;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c152); }
                }
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_object();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c165();
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseejson_long() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 11) === peg$c166) {
          s3 = peg$c166;
          peg$currPos += 11;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c167); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsequotation_mark();
              if (s6 !== peg$FAILED) {
                s7 = [];
                s8 = peg$parseplus();
                if (s8 === peg$FAILED) {
                  s8 = peg$parseminus();
                  if (s8 === peg$FAILED) {
                    s8 = peg$parseDIGIT();
                  }
                }
                if (s8 !== peg$FAILED) {
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseplus();
                    if (s8 === peg$FAILED) {
                      s8 = peg$parseminus();
                      if (s8 === peg$FAILED) {
                        s8 = peg$parseDIGIT();
                      }
                    }
                  }
                } else {
                  s7 = peg$FAILED;
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsequotation_mark();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseend_object();
                    if (s9 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$c168(s7);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseejson_decimal() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 14) === peg$c169) {
          s3 = peg$c169;
          peg$currPos += 14;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c170); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = peg$parsequotation_mark();
              if (s7 !== peg$FAILED) {
                s8 = peg$parsenumber();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parsequotation_mark();
                  if (s9 !== peg$FAILED) {
                    s7 = [s7, s8, s9];
                    s6 = s7;
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_object();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c171(s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseejson_date() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c172) {
          s3 = peg$c172;
          peg$currPos += 5;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c173); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseejson_iso8601_date();
              if (s6 === peg$FAILED) {
                s6 = peg$parseejson_long();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_object();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c174(s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseejson_iso8601_date() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsequotation_mark();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parseiso_date_time();
      if (s3 !== peg$FAILED) {
        s2 = input.substring(s2, peg$currPos);
      } else {
        s2 = s3;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsequotation_mark();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c175(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseejson_undefined() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 10) === peg$c176) {
          s3 = peg$c176;
          peg$currPos += 10;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c177); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              if (input.substr(peg$currPos, 4) === peg$c151) {
                s6 = peg$c151;
                peg$currPos += 4;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c152); }
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_object();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c178();
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseejson_dbref() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$currPos;
      s4 = peg$parsequotation_mark();
      if (s4 !== peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c179) {
          s5 = peg$c179;
          peg$currPos += 4;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c180); }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parsequotation_mark();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsename_separator();
            if (s7 !== peg$FAILED) {
              s8 = peg$parsestring();
              if (s8 !== peg$FAILED) {
                peg$savedPos = s3;
                s4 = peg$c181(s8);
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$currPos;
        s5 = peg$parsevalue_separator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parsequotation_mark();
          if (s6 !== peg$FAILED) {
            if (input.substr(peg$currPos, 3) === peg$c182) {
              s7 = peg$c182;
              peg$currPos += 3;
            } else {
              s7 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c183); }
            }
            if (s7 !== peg$FAILED) {
              s8 = peg$parsequotation_mark();
              if (s8 !== peg$FAILED) {
                s9 = peg$parsename_separator();
                if (s9 !== peg$FAILED) {
                  s10 = peg$parseleaf_value();
                  if (s10 !== peg$FAILED) {
                    peg$savedPos = s4;
                    s5 = peg$c184(s3, s10);
                    s4 = s5;
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$currPos;
          s6 = peg$parsevalue_separator();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsequotation_mark();
            if (s7 !== peg$FAILED) {
              if (input.substr(peg$currPos, 3) === peg$c185) {
                s8 = peg$c185;
                peg$currPos += 3;
              } else {
                s8 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c186); }
              }
              if (s8 !== peg$FAILED) {
                s9 = peg$parsequotation_mark();
                if (s9 !== peg$FAILED) {
                  s10 = peg$parsename_separator();
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parsestring();
                    if (s11 !== peg$FAILED) {
                      peg$savedPos = s5;
                      s6 = peg$c187(s3, s4, s11);
                      s5 = s6;
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          if (s5 !== peg$FAILED) {
            peg$savedPos = s2;
            s3 = peg$c188(s3, s4, s5);
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseend_object();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c189(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseejson_regex() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$currPos;
      s4 = peg$parsequotation_mark();
      if (s4 !== peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c190) {
          s5 = peg$c190;
          peg$currPos += 6;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c191); }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parsequotation_mark();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsename_separator();
            if (s7 !== peg$FAILED) {
              s8 = peg$parsestring();
              if (s8 !== peg$FAILED) {
                peg$savedPos = s3;
                s4 = peg$c181(s8);
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$currPos;
        s5 = peg$parsevalue_separator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parsequotation_mark();
          if (s6 !== peg$FAILED) {
            if (input.substr(peg$currPos, 8) === peg$c192) {
              s7 = peg$c192;
              peg$currPos += 8;
            } else {
              s7 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c193); }
            }
            if (s7 !== peg$FAILED) {
              s8 = peg$parsequotation_mark();
              if (s8 !== peg$FAILED) {
                s9 = peg$parsename_separator();
                if (s9 !== peg$FAILED) {
                  s10 = peg$parsequotation_mark();
                  if (s10 !== peg$FAILED) {
                    s11 = [];
                    if (peg$c194.test(input.charAt(peg$currPos))) {
                      s12 = input.charAt(peg$currPos);
                      peg$currPos++;
                    } else {
                      s12 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c195); }
                    }
                    while (s12 !== peg$FAILED) {
                      s11.push(s12);
                      if (peg$c194.test(input.charAt(peg$currPos))) {
                        s12 = input.charAt(peg$currPos);
                        peg$currPos++;
                      } else {
                        s12 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c195); }
                      }
                    }
                    if (s11 !== peg$FAILED) {
                      s12 = peg$parsequotation_mark();
                      if (s12 !== peg$FAILED) {
                        peg$savedPos = s4;
                        s5 = peg$c196(s3, s11);
                        s4 = s5;
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        if (s4 !== peg$FAILED) {
          peg$savedPos = s2;
          s3 = peg$c197(s3, s4);
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseend_object();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c189(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseejson_binary() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$currPos;
      s4 = peg$parsequotation_mark();
      if (s4 !== peg$FAILED) {
        if (input.substr(peg$currPos, 7) === peg$c198) {
          s5 = peg$c198;
          peg$currPos += 7;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c199); }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parsequotation_mark();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsename_separator();
            if (s7 !== peg$FAILED) {
              s8 = peg$parsestring();
              if (s8 !== peg$FAILED) {
                peg$savedPos = s3;
                s4 = peg$c181(s8);
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$currPos;
        s5 = peg$parsevalue_separator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parsequotation_mark();
          if (s6 !== peg$FAILED) {
            if (input.substr(peg$currPos, 5) === peg$c32) {
              s7 = peg$c32;
              peg$currPos += 5;
            } else {
              s7 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c33); }
            }
            if (s7 !== peg$FAILED) {
              s8 = peg$parsequotation_mark();
              if (s8 !== peg$FAILED) {
                s9 = peg$parsename_separator();
                if (s9 !== peg$FAILED) {
                  s10 = peg$parsequotation_mark();
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parseHEXDIG();
                    if (s11 !== peg$FAILED) {
                      s12 = peg$parsequotation_mark();
                      if (s12 !== peg$FAILED) {
                        peg$savedPos = s4;
                        s5 = peg$c200(s3, s11);
                        s4 = s5;
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          peg$savedPos = s2;
          s3 = peg$c201(s3, s4);
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseend_object();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c189(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseejson_timestamp() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsequotation_mark();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 10) === peg$c202) {
          s3 = peg$c202;
          peg$currPos += 10;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c203); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsequotation_mark();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsename_separator();
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = peg$parsebegin_object();
              if (s7 !== peg$FAILED) {
                s8 = peg$parsequotation_mark();
                if (s8 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 116) {
                    s9 = peg$c204;
                    peg$currPos++;
                  } else {
                    s9 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c205); }
                  }
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parsequotation_mark();
                    if (s10 !== peg$FAILED) {
                      s11 = peg$parsename_separator();
                      if (s11 !== peg$FAILED) {
                        s12 = peg$parsenumber();
                        if (s12 !== peg$FAILED) {
                          s13 = peg$parsevalue_separator();
                          if (s13 !== peg$FAILED) {
                            s14 = peg$parsequotation_mark();
                            if (s14 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 105) {
                                s15 = peg$c206;
                                peg$currPos++;
                              } else {
                                s15 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c207); }
                              }
                              if (s15 !== peg$FAILED) {
                                s16 = peg$parsequotation_mark();
                                if (s16 !== peg$FAILED) {
                                  s17 = peg$parsename_separator();
                                  if (s17 !== peg$FAILED) {
                                    s18 = peg$parsenumber();
                                    if (s18 !== peg$FAILED) {
                                      s19 = peg$parseend_object();
                                      if (s19 !== peg$FAILED) {
                                        peg$savedPos = s6;
                                        s7 = peg$c208(s12, s18);
                                        s6 = s7;
                                      } else {
                                        peg$currPos = s6;
                                        s6 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s6;
                                      s6 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s6;
                                    s6 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s6;
                                  s6 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s6;
                                s6 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s6;
                              s6 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s6;
                            s6 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s6;
                          s6 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s6;
                        s6 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s6;
                      s6 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_object();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c209(s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseobject() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsebegin_object();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parsemember();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$currPos;
        s6 = peg$parsevalue_separator();
        if (s6 !== peg$FAILED) {
          s7 = peg$parsemember();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s5;
            s6 = peg$c210(s3, s7);
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$currPos;
          s6 = peg$parsevalue_separator();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsemember();
            if (s7 !== peg$FAILED) {
              peg$savedPos = s5;
              s6 = peg$c210(s3, s7);
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        }
        if (s4 !== peg$FAILED) {
          peg$savedPos = s2;
          s3 = peg$c211(s3, s4);
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseend_object();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c212(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsemember() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsekey();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsename_separator();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseleaf_value();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c213(s1, s3);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsearray() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsebegin_array();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parseleaf_value();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$currPos;
        s6 = peg$parsevalue_separator();
        if (s6 !== peg$FAILED) {
          s7 = peg$parseleaf_value();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s5;
            s6 = peg$c99(s3, s7);
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$currPos;
          s6 = peg$parsevalue_separator();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseleaf_value();
            if (s7 !== peg$FAILED) {
              peg$savedPos = s5;
              s6 = peg$c99(s3, s7);
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        }
        if (s4 !== peg$FAILED) {
          peg$savedPos = s2;
          s3 = peg$c2(s3, s4);
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseend_array();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c123(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsearray_number() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsebegin_array();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parsenumber();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$currPos;
        s6 = peg$parsevalue_separator();
        if (s6 !== peg$FAILED) {
          s7 = peg$parsenumber();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s5;
            s6 = peg$c99(s3, s7);
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$currPos;
          s6 = peg$parsevalue_separator();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsenumber();
            if (s7 !== peg$FAILED) {
              peg$savedPos = s5;
              s6 = peg$c99(s3, s7);
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        }
        if (s4 !== peg$FAILED) {
          peg$savedPos = s2;
          s3 = peg$c2(s3, s4);
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseend_array();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c123(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsenumber() {
    var s0, s1, s2, s3, s4;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseminus();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseint();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsefrac();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseexp();
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c215();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c214); }
    }

    return s0;
  }

  function peg$parsenumber_positive() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseint();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsefrac();
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseexp();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c215();
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsenumber_longitude() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parseminus();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      if (input.substr(peg$currPos, 3) === peg$c216) {
        s3 = peg$c216;
        peg$currPos += 3;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c217); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$currPos;
        s5 = peg$parsedecimal_point();
        if (s5 !== peg$FAILED) {
          s6 = peg$parsezero();
          if (s6 !== peg$FAILED) {
            s5 = [s5, s6];
            s4 = s5;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        if (s4 !== peg$FAILED) {
          s3 = [s3, s4];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 49) {
          s4 = peg$c160;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c161); }
        }
        if (s4 !== peg$FAILED) {
          if (peg$c218.test(input.charAt(peg$currPos))) {
            s5 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c219); }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseDIGIT();
            if (s6 !== peg$FAILED) {
              s4 = [s4, s5, s6];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parsedigit1_9();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseDIGIT();
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$parseDIGIT();
          }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsedecimal_point();
          if (s4 !== peg$FAILED) {
            s5 = [];
            s6 = peg$parseint();
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$parseint();
            }
            if (s5 !== peg$FAILED) {
              s3 = [s3, s4, s5];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 49) {
            s3 = peg$c160;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c161); }
          }
          if (s3 !== peg$FAILED) {
            if (peg$c218.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c219); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseDIGIT();
              if (s5 !== peg$FAILED) {
                s3 = [s3, s4, s5];
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = peg$currPos;
            s3 = peg$parsedigit1_9();
            if (s3 !== peg$FAILED) {
              s4 = peg$parseDIGIT();
              if (s4 !== peg$FAILED) {
                s3 = [s3, s4];
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
            if (s2 === peg$FAILED) {
              s2 = peg$parseDIGIT();
            }
          }
        }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsenumber_latitude() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parseminus();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      if (input.substr(peg$currPos, 2) === peg$c220) {
        s3 = peg$c220;
        peg$currPos += 2;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c221); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$currPos;
        s5 = peg$parsedecimal_point();
        if (s5 !== peg$FAILED) {
          s6 = peg$parsezero();
          if (s6 !== peg$FAILED) {
            s5 = [s5, s6];
            s4 = s5;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        if (s4 !== peg$FAILED) {
          s3 = [s3, s4];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$currPos;
        s4 = peg$parsedigit1_9();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseDIGIT();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$parseDIGIT();
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsedecimal_point();
          if (s4 !== peg$FAILED) {
            s5 = [];
            s6 = peg$parseint();
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$parseint();
            }
            if (s5 !== peg$FAILED) {
              s3 = [s3, s4, s5];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          s3 = peg$parsedigit1_9();
          if (s3 !== peg$FAILED) {
            s4 = peg$parseDIGIT();
            if (s4 !== peg$FAILED) {
              s3 = [s3, s4];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = peg$parseDIGIT();
          }
        }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedecimal_point() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 46) {
      s0 = peg$c222;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c223); }
    }

    return s0;
  }

  function peg$parsedigit1_9() {
    var s0;

    if (peg$c224.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c225); }
    }

    return s0;
  }

  function peg$parsee() {
    var s0;

    if (peg$c226.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c227); }
    }

    return s0;
  }

  function peg$parseexp() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parsee();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseminus();
      if (s2 === peg$FAILED) {
        s2 = peg$parseplus();
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parseDIGIT();
        if (s4 !== peg$FAILED) {
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseDIGIT();
          }
        } else {
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefrac() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsedecimal_point();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseDIGIT();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseDIGIT();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseint() {
    var s0, s1, s2, s3;

    s0 = peg$parsezero();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsedigit1_9();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseDIGIT();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseDIGIT();
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseminus() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 45) {
      s0 = peg$c228;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c229); }
    }

    return s0;
  }

  function peg$parseplus() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 43) {
      s0 = peg$c230;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c231); }
    }

    return s0;
  }

  function peg$parsezero() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 48) {
      s0 = peg$c232;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c233); }
    }

    return s0;
  }

  function peg$parsestring() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parsequotation_mark();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsechar();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsechar();
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsequotation_mark();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c235(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c234); }
    }

    return s0;
  }

  function peg$parsechar() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$parseunescaped();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseescape();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 34) {
          s2 = peg$c236;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c237); }
        }
        if (s2 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 92) {
            s2 = peg$c238;
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c239); }
          }
          if (s2 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 47) {
              s2 = peg$c240;
              peg$currPos++;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c241); }
            }
            if (s2 === peg$FAILED) {
              s2 = peg$currPos;
              if (input.charCodeAt(peg$currPos) === 98) {
                s3 = peg$c242;
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c243); }
              }
              if (s3 !== peg$FAILED) {
                peg$savedPos = s2;
                s3 = peg$c244();
              }
              s2 = s3;
              if (s2 === peg$FAILED) {
                s2 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 102) {
                  s3 = peg$c245;
                  peg$currPos++;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c246); }
                }
                if (s3 !== peg$FAILED) {
                  peg$savedPos = s2;
                  s3 = peg$c247();
                }
                s2 = s3;
                if (s2 === peg$FAILED) {
                  s2 = peg$currPos;
                  if (input.charCodeAt(peg$currPos) === 110) {
                    s3 = peg$c248;
                    peg$currPos++;
                  } else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c249); }
                  }
                  if (s3 !== peg$FAILED) {
                    peg$savedPos = s2;
                    s3 = peg$c250();
                  }
                  s2 = s3;
                  if (s2 === peg$FAILED) {
                    s2 = peg$currPos;
                    if (input.charCodeAt(peg$currPos) === 114) {
                      s3 = peg$c251;
                      peg$currPos++;
                    } else {
                      s3 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c252); }
                    }
                    if (s3 !== peg$FAILED) {
                      peg$savedPos = s2;
                      s3 = peg$c253();
                    }
                    s2 = s3;
                    if (s2 === peg$FAILED) {
                      s2 = peg$currPos;
                      if (input.charCodeAt(peg$currPos) === 116) {
                        s3 = peg$c204;
                        peg$currPos++;
                      } else {
                        s3 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c205); }
                      }
                      if (s3 !== peg$FAILED) {
                        peg$savedPos = s2;
                        s3 = peg$c254();
                      }
                      s2 = s3;
                      if (s2 === peg$FAILED) {
                        s2 = peg$currPos;
                        if (input.charCodeAt(peg$currPos) === 117) {
                          s3 = peg$c255;
                          peg$currPos++;
                        } else {
                          s3 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c256); }
                        }
                        if (s3 !== peg$FAILED) {
                          s4 = peg$currPos;
                          s5 = peg$currPos;
                          s6 = peg$parseHEXDIG();
                          if (s6 !== peg$FAILED) {
                            s7 = peg$parseHEXDIG();
                            if (s7 !== peg$FAILED) {
                              s8 = peg$parseHEXDIG();
                              if (s8 !== peg$FAILED) {
                                s9 = peg$parseHEXDIG();
                                if (s9 !== peg$FAILED) {
                                  s6 = [s6, s7, s8, s9];
                                  s5 = s6;
                                } else {
                                  peg$currPos = s5;
                                  s5 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s5;
                                s5 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s5;
                              s5 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s5;
                            s5 = peg$FAILED;
                          }
                          if (s5 !== peg$FAILED) {
                            s4 = input.substring(s4, peg$currPos);
                          } else {
                            s4 = s5;
                          }
                          if (s4 !== peg$FAILED) {
                            peg$savedPos = s2;
                            s3 = peg$c257(s4);
                            s2 = s3;
                          } else {
                            peg$currPos = s2;
                            s2 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c258(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseescape() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 92) {
      s0 = peg$c238;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c239); }
    }

    return s0;
  }

  function peg$parsequotation_mark() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 34) {
      s0 = peg$c236;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c237); }
    }

    return s0;
  }

  function peg$parseunescaped() {
    var s0;

    if (peg$c259.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c260); }
    }

    return s0;
  }

  function peg$parseDIGIT() {
    var s0;

    if (peg$c261.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c262); }
    }

    return s0;
  }

  function peg$parseHEXDIG() {
    var s0;

    if (peg$c263.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c264); }
    }

    return s0;
  }

  function peg$parsedate_century() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parseDIGIT();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parsedate_year() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parseDIGIT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseDIGIT();
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedate_fullyear() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parsedate_century();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedate_year();
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedate_month() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parseDIGIT();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parsedate_mday() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parseDIGIT();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parsedate_yday() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parseDIGIT();
      if (s3 !== peg$FAILED) {
        s4 = peg$parseDIGIT();
        if (s4 !== peg$FAILED) {
          s2 = [s2, s3, s4];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parsedate_week() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parseDIGIT();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parsedatepart_fullyear() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsedate_century();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedate_year();
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s3 = peg$c228;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c229); }
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedatepart_ptyear() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 45) {
      s1 = peg$c228;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c229); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parseDIGIT();
      if (s3 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s4 = peg$c228;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c229); }
        }
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        if (s4 !== peg$FAILED) {
          s3 = [s3, s4];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedatepart_wkyear() {
    var s0;

    s0 = peg$parsedatepart_ptyear();
    if (s0 === peg$FAILED) {
      s0 = peg$parsedatepart_fullyear();
    }

    return s0;
  }

  function peg$parsedateopt_century() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 45) {
      s0 = peg$c228;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c229); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsedate_century();
    }

    return s0;
  }

  function peg$parsedateopt_fullyear() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 45) {
      s0 = peg$c228;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c229); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsedatepart_fullyear();
    }

    return s0;
  }

  function peg$parsedateopt_year() {
    var s0, s1, s2;

    if (input.charCodeAt(peg$currPos) === 45) {
      s0 = peg$c228;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c229); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsedate_year();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s2 = peg$c228;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c229); }
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsedateopt_month() {
    var s0, s1, s2;

    if (input.charCodeAt(peg$currPos) === 45) {
      s0 = peg$c228;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c229); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsedate_month();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s2 = peg$c228;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c229); }
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsedateopt_week() {
    var s0, s1, s2;

    if (input.charCodeAt(peg$currPos) === 45) {
      s0 = peg$c228;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c229); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsedate_week();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s2 = peg$c228;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c229); }
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsedatespec_full() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parsedatepart_fullyear();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedate_month();
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s3 = peg$c228;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c229); }
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsedate_mday();
          if (s4 !== peg$FAILED) {
            s1 = [s1, s2, s3, s4];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedatespec_year() {
    var s0, s1, s2;

    s0 = peg$parsedate_century();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsedateopt_century();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsedate_year();
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsedatespec_month() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 45) {
      s1 = peg$c228;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c229); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedateopt_year();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsedate_month();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 45) {
            s5 = peg$c228;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c229); }
          }
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parsedate_mday();
            if (s6 !== peg$FAILED) {
              s5 = [s5, s6];
              s4 = s5;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s1 = [s1, s2, s3, s4];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedatespec_mday() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c265) {
      s1 = peg$c265;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c266); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedateopt_month();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsedate_mday();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedatespec_week() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsedatepart_wkyear();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 87) {
        s2 = peg$c267;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c268); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsedate_week();
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parsedateopt_week();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseDIGIT();
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedatespec_wday() {
    var s0, s1, s2;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3) === peg$c269) {
      s1 = peg$c269;
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c270); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseDIGIT();
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedatespec_yday() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parsedateopt_fullyear();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedate_yday();
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedate() {
    var s0;

    s0 = peg$parsedatespec_full();
    if (s0 === peg$FAILED) {
      s0 = peg$parsedatespec_year();
      if (s0 === peg$FAILED) {
        s0 = peg$parsedatespec_month();
        if (s0 === peg$FAILED) {
          s0 = peg$parsedatespec_mday();
          if (s0 === peg$FAILED) {
            s0 = peg$parsedatespec_week();
            if (s0 === peg$FAILED) {
              s0 = peg$parsedatespec_wday();
              if (s0 === peg$FAILED) {
                s0 = peg$parsedatespec_yday();
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsetime_hour() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parseDIGIT();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parsetime_minute() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parseDIGIT();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parsetime_second() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parseDIGIT();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parsetime_fraction() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 44) {
      s1 = peg$c140;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c141); }
    }
    if (s1 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 46) {
        s1 = peg$c222;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c223); }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = [];
      s4 = peg$parseDIGIT();
      if (s4 !== peg$FAILED) {
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parseDIGIT();
        }
      } else {
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s2 = input.substring(s2, peg$currPos);
      } else {
        s2 = s3;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetime_numoffset() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 43) {
      s1 = peg$c230;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c231); }
    }
    if (s1 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 45) {
        s1 = peg$c228;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c229); }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsetime_hour();
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 58) {
          s4 = peg$c138;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c139); }
        }
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsetime_minute();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetime_zone() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 90) {
      s0 = peg$c271;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c272); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsetime_numoffset();
    }

    return s0;
  }

  function peg$parsetimeopt_hour() {
    var s0, s1, s2;

    if (input.charCodeAt(peg$currPos) === 45) {
      s0 = peg$c228;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c229); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsetime_hour();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 58) {
          s2 = peg$c138;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c139); }
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsetimeopt_minute() {
    var s0, s1, s2;

    if (input.charCodeAt(peg$currPos) === 45) {
      s0 = peg$c228;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c229); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsetime_minute();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 58) {
          s2 = peg$c138;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c139); }
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsetimespec_hour() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsetime_hour();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 58) {
        s3 = peg$c138;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c139); }
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parsetime_minute();
        if (s4 !== peg$FAILED) {
          s5 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 58) {
            s6 = peg$c138;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c139); }
          }
          if (s6 === peg$FAILED) {
            s6 = null;
          }
          if (s6 !== peg$FAILED) {
            s7 = peg$parsetime_second();
            if (s7 !== peg$FAILED) {
              s6 = [s6, s7];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          if (s5 !== peg$FAILED) {
            s3 = [s3, s4, s5];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetimespec_minute() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsetimeopt_hour();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsetime_minute();
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 58) {
          s4 = peg$c138;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c139); }
        }
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsetime_second();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetimespec_second() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 45) {
      s1 = peg$c228;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c229); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsetimeopt_minute();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsetime_second();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetimespec_base() {
    var s0;

    s0 = peg$parsetimespec_hour();
    if (s0 === peg$FAILED) {
      s0 = peg$parsetimespec_minute();
      if (s0 === peg$FAILED) {
        s0 = peg$parsetimespec_second();
      }
    }

    return s0;
  }

  function peg$parsetime() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsetimespec_base();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsetime_fraction();
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsetime_zone();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseiso_date_time() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsedate();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 84) {
        s2 = peg$c273;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c274); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsetime();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedur_second() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseDIGIT();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 83) {
        s2 = peg$c275;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c276); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedur_minute() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseDIGIT();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 77) {
        s2 = peg$c277;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c278); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsedur_second();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedur_hour() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseDIGIT();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 72) {
        s2 = peg$c279;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c280); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsedur_minute();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedur_time() {
    var s0, s1, s2;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 84) {
      s1 = peg$c273;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c274); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedur_hour();
      if (s2 === peg$FAILED) {
        s2 = peg$parsedur_minute();
        if (s2 === peg$FAILED) {
          s2 = peg$parsedur_second();
        }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedur_day() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseDIGIT();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 68) {
        s2 = peg$c281;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c282); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedur_week() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseDIGIT();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 87) {
        s2 = peg$c267;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c268); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedur_month() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseDIGIT();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 77) {
        s2 = peg$c277;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c278); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsedur_day();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedur_year() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseDIGIT();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseDIGIT();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 89) {
        s2 = peg$c283;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c284); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsedur_month();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedur_date() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parsedur_day();
    if (s1 === peg$FAILED) {
      s1 = peg$parsedur_month();
      if (s1 === peg$FAILED) {
        s1 = peg$parsedur_year();
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedur_time();
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseduration() {
    var s0, s1, s2;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 80) {
      s1 = peg$c285;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c286); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedur_date();
      if (s2 === peg$FAILED) {
        s2 = peg$parsedur_time();
        if (s2 === peg$FAILED) {
          s2 = peg$parsedur_week();
        }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseperiod_explicit() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseiso_date_time();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 47) {
        s2 = peg$c240;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c241); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseiso_date_time();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseperiod_start() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseiso_date_time();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 47) {
        s2 = peg$c240;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c241); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseduration();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseperiod_end() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseduration();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 47) {
        s2 = peg$c240;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c241); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseiso_date_time();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseperiod() {
    var s0;

    s0 = peg$parseperiod_explicit();
    if (s0 === peg$FAILED) {
      s0 = peg$parseperiod_start();
      if (s0 === peg$FAILED) {
        s0 = peg$parseperiod_end();
      }
    }

    return s0;
  }

  peg$result = peg$startRuleFunction();

  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
    );
  }
}

module.exports = {
  SyntaxError: peg$SyntaxError,
  parse:       peg$parse
};
