package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;

import fr.gouv.vitamui.iam.openapiclient.domain.GroupDto;
import fr.gouv.vitamui.iam.openapiclient.domain.PaginatedValuesDtoUserDto;
import fr.gouv.vitamui.iam.openapiclient.domain.SubrogationDto;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-10-29T21:39:28.961721984+01:00[Europe/Paris]", comments = "Generator version: 7.4.0")
public class SubrogationsApi {
    private ApiClient apiClient;

    public SubrogationsApi() {
        this(new ApiClient());
    }

    public SubrogationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Accept a subrogation
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return SubrogationDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public SubrogationDto accept(String id) throws RestClientException {
        return acceptWithHttpInfo(id).getBody();
    }

    /**
     * Accept a subrogation
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;SubrogationDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<SubrogationDto> acceptWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling accept");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<SubrogationDto> localReturnType = new ParameterizedTypeReference<SubrogationDto>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations/surrogate/accept/{id}", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Check the existence of a subrogation by id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void checkExist(String id) throws RestClientException {
        checkExistWithHttpInfo(id);
    }

    /**
     * Check the existence of a subrogation by id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> checkExistWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling checkExist");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = {  };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations/{id}", HttpMethod.HEAD, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Create a subrogation
     * 
     * <p><b>200</b> - OK
     * @param subrogationDto  (required)
     * @return SubrogationDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public SubrogationDto create(SubrogationDto subrogationDto) throws RestClientException {
        return createWithHttpInfo(subrogationDto).getBody();
    }

    /**
     * Create a subrogation
     * 
     * <p><b>200</b> - OK
     * @param subrogationDto  (required)
     * @return ResponseEntity&lt;SubrogationDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<SubrogationDto> createWithHttpInfo(SubrogationDto subrogationDto) throws RestClientException {
        Object localVarPostBody = subrogationDto;
        
        // verify the required parameter 'subrogationDto' is set
        if (subrogationDto == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'subrogationDto' when calling create");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<SubrogationDto> localReturnType = new ParameterizedTypeReference<SubrogationDto>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Decline a subrogation
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void decline(String id) throws RestClientException {
        declineWithHttpInfo(id);
    }

    /**
     * Decline a subrogation
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> declineWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling decline");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = {  };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations/surrogate/decline/{id}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Delete a subrogation by id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void delete(String id) throws RestClientException {
        deleteWithHttpInfo(id);
    }

    /**
     * Delete a subrogation by id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> deleteWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling delete");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = {  };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations/{id}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get all subrogations
     * 
     * <p><b>200</b> - OK
     * @param criteria  (optional)
     * @return List&lt;SubrogationDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<SubrogationDto> getAll(String criteria) throws RestClientException {
        return getAllWithHttpInfo(criteria).getBody();
    }

    /**
     * Get all subrogations
     * 
     * <p><b>200</b> - OK
     * @param criteria  (optional)
     * @return ResponseEntity&lt;List&lt;SubrogationDto&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<SubrogationDto>> getAllWithHttpInfo(String criteria) throws RestClientException {
        Object localVarPostBody = null;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<List<SubrogationDto>> localReturnType = new ParameterizedTypeReference<List<SubrogationDto>>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get all generic users with criteria
     * 
     * <p><b>200</b> - OK
     * @param page  (required)
     * @param size  (required)
     * @param criteria  (optional)
     * @param orderBy  (optional)
     * @param direction  (optional)
     * @return PaginatedValuesDtoUserDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public PaginatedValuesDtoUserDto getGenericUsers(Integer page, Integer size, String criteria, String orderBy, String direction) throws RestClientException {
        return getGenericUsersWithHttpInfo(page, size, criteria, orderBy, direction).getBody();
    }

    /**
     * Get all generic users with criteria
     * 
     * <p><b>200</b> - OK
     * @param page  (required)
     * @param size  (required)
     * @param criteria  (optional)
     * @param orderBy  (optional)
     * @param direction  (optional)
     * @return ResponseEntity&lt;PaginatedValuesDtoUserDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<PaginatedValuesDtoUserDto> getGenericUsersWithHttpInfo(Integer page, Integer size, String criteria, String orderBy, String direction) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'page' is set
        if (page == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'page' when calling getGenericUsers");
        }
        
        // verify the required parameter 'size' is set
        if (size == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'size' when calling getGenericUsers");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "orderBy", orderBy));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "direction", direction));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<PaginatedValuesDtoUserDto> localReturnType = new ParameterizedTypeReference<PaginatedValuesDtoUserDto>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations/users/generic", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get group by id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return GroupDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public GroupDto getGroupById(String id) throws RestClientException {
        return getGroupByIdWithHttpInfo(id).getBody();
    }

    /**
     * Get group by id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;GroupDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<GroupDto> getGroupByIdWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getGroupById");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<GroupDto> localReturnType = new ParameterizedTypeReference<GroupDto>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations/groups/{id}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get authenticated user&#39;s subrogation as superuser
     * 
     * <p><b>200</b> - OK
     * @return SubrogationDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public SubrogationDto getMySubrogationAsSuperuser() throws RestClientException {
        return getMySubrogationAsSuperuserWithHttpInfo().getBody();
    }

    /**
     * Get authenticated user&#39;s subrogation as superuser
     * 
     * <p><b>200</b> - OK
     * @return ResponseEntity&lt;SubrogationDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<SubrogationDto> getMySubrogationAsSuperuserWithHttpInfo() throws RestClientException {
        Object localVarPostBody = null;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<SubrogationDto> localReturnType = new ParameterizedTypeReference<SubrogationDto>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations/me/superuser", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get authenticated user&#39;s subrogation as surrogate
     * 
     * <p><b>200</b> - OK
     * @return SubrogationDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public SubrogationDto getMySubrogationAsSurrogate() throws RestClientException {
        return getMySubrogationAsSurrogateWithHttpInfo().getBody();
    }

    /**
     * Get authenticated user&#39;s subrogation as surrogate
     * 
     * <p><b>200</b> - OK
     * @return ResponseEntity&lt;SubrogationDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<SubrogationDto> getMySubrogationAsSurrogateWithHttpInfo() throws RestClientException {
        Object localVarPostBody = null;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<SubrogationDto> localReturnType = new ParameterizedTypeReference<SubrogationDto>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations/me/surrogate", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get subrogation by id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return SubrogationDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public SubrogationDto getOne(String id) throws RestClientException {
        return getOneWithHttpInfo(id).getBody();
    }

    /**
     * Get subrogation by id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;SubrogationDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<SubrogationDto> getOneWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getOne");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<SubrogationDto> localReturnType = new ParameterizedTypeReference<SubrogationDto>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations/{id}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Update a subrogation
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param subrogationDto  (required)
     * @return SubrogationDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public SubrogationDto update(String id, SubrogationDto subrogationDto) throws RestClientException {
        return updateWithHttpInfo(id, subrogationDto).getBody();
    }

    /**
     * Update a subrogation
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param subrogationDto  (required)
     * @return ResponseEntity&lt;SubrogationDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<SubrogationDto> updateWithHttpInfo(String id, SubrogationDto subrogationDto) throws RestClientException {
        Object localVarPostBody = subrogationDto;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling update");
        }
        
        // verify the required parameter 'subrogationDto' is set
        if (subrogationDto == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'subrogationDto' when calling update");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<SubrogationDto> localReturnType = new ParameterizedTypeReference<SubrogationDto>() {};
        return apiClient.invokeAPI("/iam/v1/subrogations/{id}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
