package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;

import fr.gouv.vitamui.iam.openapiclient.domain.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.openapiclient.domain.PaginatedValuesDtoProfileDto;
import fr.gouv.vitamui.iam.openapiclient.domain.ProfileDto;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-10-29T21:39:28.961721984+01:00[Europe/Paris]", comments = "Generator version: 7.4.0")
public class ProfilesApi {
    private ApiClient apiClient;

    public ProfilesApi() {
        this(new ApiClient());
    }

    public ProfilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Check the existence of a profile by criteria
     * 
     * <p><b>200</b> - OK
     * @param criteria  (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void checkExist(String criteria) throws RestClientException {
        checkExistWithHttpInfo(criteria);
    }

    /**
     * Check the existence of a profile by criteria
     * 
     * <p><b>200</b> - OK
     * @param criteria  (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> checkExistWithHttpInfo(String criteria) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'criteria' is set
        if (criteria == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'criteria' when calling checkExist");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        

        final String[] localVarAccepts = {  };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/iam/v1/profiles/check", HttpMethod.HEAD, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Create a profile
     * 
     * <p><b>200</b> - OK
     * @param profileDto  (required)
     * @return ProfileDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ProfileDto create(ProfileDto profileDto) throws RestClientException {
        return createWithHttpInfo(profileDto).getBody();
    }

    /**
     * Create a profile
     * 
     * <p><b>200</b> - OK
     * @param profileDto  (required)
     * @return ResponseEntity&lt;ProfileDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ProfileDto> createWithHttpInfo(ProfileDto profileDto) throws RestClientException {
        Object localVarPostBody = profileDto;
        
        // verify the required parameter 'profileDto' is set
        if (profileDto == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'profileDto' when calling create");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<ProfileDto> localReturnType = new ParameterizedTypeReference<ProfileDto>() {};
        return apiClient.invokeAPI("/iam/v1/profiles", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get profile history by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return LogbookOperationsCommonResponseDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws RestClientException {
        return findHistoryByIdWithHttpInfo(id).getBody();
    }

    /**
     * Get profile history by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;LogbookOperationsCommonResponseDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<LogbookOperationsCommonResponseDto> findHistoryByIdWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling findHistoryById");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<LogbookOperationsCommonResponseDto> localReturnType = new ParameterizedTypeReference<LogbookOperationsCommonResponseDto>() {};
        return apiClient.invokeAPI("/iam/v1/profiles/{id}/history", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get all profiles
     * 
     * <p><b>200</b> - OK
     * @param criteria  (optional)
     * @param embedded  (optional)
     * @return List&lt;ProfileDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<ProfileDto> getAll(String criteria, String embedded) throws RestClientException {
        return getAllWithHttpInfo(criteria, embedded).getBody();
    }

    /**
     * Get all profiles
     * 
     * <p><b>200</b> - OK
     * @param criteria  (optional)
     * @param embedded  (optional)
     * @return ResponseEntity&lt;List&lt;ProfileDto&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<ProfileDto>> getAllWithHttpInfo(String criteria, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<List<ProfileDto>> localReturnType = new ParameterizedTypeReference<List<ProfileDto>>() {};
        return apiClient.invokeAPI("/iam/v1/profiles", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get all profiles, paginated result
     * 
     * <p><b>200</b> - OK
     * @param page  (required)
     * @param size  (required)
     * @param criteria  (optional)
     * @param orderBy  (optional)
     * @param direction  (optional)
     * @param embedded  (optional)
     * @return PaginatedValuesDtoProfileDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public PaginatedValuesDtoProfileDto getAllPaginated(Integer page, Integer size, String criteria, String orderBy, String direction, String embedded) throws RestClientException {
        return getAllPaginatedWithHttpInfo(page, size, criteria, orderBy, direction, embedded).getBody();
    }

    /**
     * Get all profiles, paginated result
     * 
     * <p><b>200</b> - OK
     * @param page  (required)
     * @param size  (required)
     * @param criteria  (optional)
     * @param orderBy  (optional)
     * @param direction  (optional)
     * @param embedded  (optional)
     * @return ResponseEntity&lt;PaginatedValuesDtoProfileDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<PaginatedValuesDtoProfileDto> getAllPaginatedWithHttpInfo(Integer page, Integer size, String criteria, String orderBy, String direction, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'page' is set
        if (page == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'page' when calling getAllPaginated");
        }
        
        // verify the required parameter 'size' is set
        if (size == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'size' when calling getAllPaginated");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "orderBy", orderBy));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "direction", direction));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<PaginatedValuesDtoProfileDto> localReturnType = new ParameterizedTypeReference<PaginatedValuesDtoProfileDto>() {};
        return apiClient.invokeAPI("/iam/v1/profiles/paginated", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get levels by criteria
     * 
     * <p><b>200</b> - OK
     * @param criteria  (optional)
     * @return List&lt;String&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<String> getLevels(String criteria) throws RestClientException {
        return getLevelsWithHttpInfo(criteria).getBody();
    }

    /**
     * Get levels by criteria
     * 
     * <p><b>200</b> - OK
     * @param criteria  (optional)
     * @return ResponseEntity&lt;List&lt;String&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<String>> getLevelsWithHttpInfo(String criteria) throws RestClientException {
        Object localVarPostBody = null;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<List<String>> localReturnType = new ParameterizedTypeReference<List<String>>() {};
        return apiClient.invokeAPI("/iam/v1/profiles/levels", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get a profile by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param embedded  (optional)
     * @return ProfileDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ProfileDto getOne(String id, String embedded) throws RestClientException {
        return getOneWithHttpInfo(id, embedded).getBody();
    }

    /**
     * Get a profile by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param embedded  (optional)
     * @return ResponseEntity&lt;ProfileDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ProfileDto> getOneWithHttpInfo(String id, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getOne");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<ProfileDto> localReturnType = new ParameterizedTypeReference<ProfileDto>() {};
        return apiClient.invokeAPI("/iam/v1/profiles/{id}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Patch a profile
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param requestBody  (required)
     * @return ProfileDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ProfileDto patch(String id, Map<String, Object> requestBody) throws RestClientException {
        return patchWithHttpInfo(id, requestBody).getBody();
    }

    /**
     * Patch a profile
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param requestBody  (required)
     * @return ResponseEntity&lt;ProfileDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ProfileDto> patchWithHttpInfo(String id, Map<String, Object> requestBody) throws RestClientException {
        Object localVarPostBody = requestBody;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling patch");
        }
        
        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'requestBody' when calling patch");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<ProfileDto> localReturnType = new ParameterizedTypeReference<ProfileDto>() {};
        return apiClient.invokeAPI("/iam/v1/profiles/{id}", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
