package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;

import fr.gouv.vitamui.iam.openapiclient.domain.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.openapiclient.domain.OwnerDto;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-10-29T21:39:28.961721984+01:00[Europe/Paris]", comments = "Generator version: 7.4.0")
public class OwnersApi {
    private ApiClient apiClient;

    public OwnersApi() {
        this(new ApiClient());
    }

    public OwnersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Check the existence of an owner by criteria
     * 
     * <p><b>200</b> - OK
     * @param criteria  (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void checkExist(String criteria) throws RestClientException {
        checkExistWithHttpInfo(criteria);
    }

    /**
     * Check the existence of an owner by criteria
     * 
     * <p><b>200</b> - OK
     * @param criteria  (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> checkExistWithHttpInfo(String criteria) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'criteria' is set
        if (criteria == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'criteria' when calling checkExist");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        

        final String[] localVarAccepts = {  };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/iam/v1/owners/check", HttpMethod.HEAD, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Create an owner
     * 
     * <p><b>200</b> - OK
     * @param ownerDto  (required)
     * @return OwnerDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public OwnerDto create(OwnerDto ownerDto) throws RestClientException {
        return createWithHttpInfo(ownerDto).getBody();
    }

    /**
     * Create an owner
     * 
     * <p><b>200</b> - OK
     * @param ownerDto  (required)
     * @return ResponseEntity&lt;OwnerDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<OwnerDto> createWithHttpInfo(OwnerDto ownerDto) throws RestClientException {
        Object localVarPostBody = ownerDto;
        
        // verify the required parameter 'ownerDto' is set
        if (ownerDto == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ownerDto' when calling create");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<OwnerDto> localReturnType = new ParameterizedTypeReference<OwnerDto>() {};
        return apiClient.invokeAPI("/iam/v1/owners", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get owner history by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return LogbookOperationsCommonResponseDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws RestClientException {
        return findHistoryByIdWithHttpInfo(id).getBody();
    }

    /**
     * Get owner history by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;LogbookOperationsCommonResponseDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<LogbookOperationsCommonResponseDto> findHistoryByIdWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling findHistoryById");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<LogbookOperationsCommonResponseDto> localReturnType = new ParameterizedTypeReference<LogbookOperationsCommonResponseDto>() {};
        return apiClient.invokeAPI("/iam/v1/owners/{id}/history", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get an owner by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return OwnerDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public OwnerDto getOne(String id) throws RestClientException {
        return getOneWithHttpInfo(id).getBody();
    }

    /**
     * Get an owner by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;OwnerDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<OwnerDto> getOneWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getOne");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<OwnerDto> localReturnType = new ParameterizedTypeReference<OwnerDto>() {};
        return apiClient.invokeAPI("/iam/v1/owners/{id}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Patch an owner
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param requestBody  (required)
     * @return OwnerDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public OwnerDto patch(String id, Map<String, Object> requestBody) throws RestClientException {
        return patchWithHttpInfo(id, requestBody).getBody();
    }

    /**
     * Patch an owner
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param requestBody  (required)
     * @return ResponseEntity&lt;OwnerDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<OwnerDto> patchWithHttpInfo(String id, Map<String, Object> requestBody) throws RestClientException {
        Object localVarPostBody = requestBody;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling patch");
        }
        
        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'requestBody' when calling patch");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<OwnerDto> localReturnType = new ParameterizedTypeReference<OwnerDto>() {};
        return apiClient.invokeAPI("/iam/v1/owners/{id}", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Update an owner
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param ownerDto  (required)
     * @return OwnerDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public OwnerDto update(String id, OwnerDto ownerDto) throws RestClientException {
        return updateWithHttpInfo(id, ownerDto).getBody();
    }

    /**
     * Update an owner
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param ownerDto  (required)
     * @return ResponseEntity&lt;OwnerDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<OwnerDto> updateWithHttpInfo(String id, OwnerDto ownerDto) throws RestClientException {
        Object localVarPostBody = ownerDto;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling update");
        }
        
        // verify the required parameter 'ownerDto' is set
        if (ownerDto == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ownerDto' when calling update");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<OwnerDto> localReturnType = new ParameterizedTypeReference<OwnerDto>() {};
        return apiClient.invokeAPI("/iam/v1/owners/{id}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
