package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;

import fr.gouv.vitamui.iam.openapiclient.domain.LogbookLifeCycleResponseDto;
import fr.gouv.vitamui.iam.openapiclient.domain.LogbookOperationsCommonResponseDto;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-10-29T21:39:28.961721984+01:00[Europe/Paris]", comments = "Generator version: 7.4.0")
public class LogbooksApi {
    private ApiClient apiClient;

    public LogbooksApi() {
        this(new ApiClient());
    }

    public LogbooksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Download the ATR file for a given operation
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param id  (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void downloadAtr(Integer xTenantId, String id) throws RestClientException {
        downloadAtrWithHttpInfo(xTenantId, id);
    }

    /**
     * Download the ATR file for a given operation
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param id  (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> downloadAtrWithHttpInfo(Integer xTenantId, String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'xTenantId' is set
        if (xTenantId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xTenantId' when calling downloadAtr");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling downloadAtr");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        if (xTenantId != null)
        localVarHeaderParams.add("X-Tenant-Id", apiClient.parameterToString(xTenantId));

        final String[] localVarAccepts = {  };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/v1/logbooks/operations/{id}/download/atr", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Download the manifest for a given operation
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param id  (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void downloadManifest(Integer xTenantId, String id) throws RestClientException {
        downloadManifestWithHttpInfo(xTenantId, id);
    }

    /**
     * Download the manifest for a given operation
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param id  (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> downloadManifestWithHttpInfo(Integer xTenantId, String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'xTenantId' is set
        if (xTenantId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xTenantId' when calling downloadManifest");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling downloadManifest");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        if (xTenantId != null)
        localVarHeaderParams.add("X-Tenant-Id", apiClient.parameterToString(xTenantId));

        final String[] localVarAccepts = {  };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/v1/logbooks/operations/{id}/download/manifest", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Download the report file for a given operation
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param xAccessContractId  (required)
     * @param id  (required)
     * @param downloadType  (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void downloadReport(Integer xTenantId, String xAccessContractId, String id, String downloadType) throws RestClientException {
        downloadReportWithHttpInfo(xTenantId, xAccessContractId, id, downloadType);
    }

    /**
     * Download the report file for a given operation
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param xAccessContractId  (required)
     * @param id  (required)
     * @param downloadType  (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> downloadReportWithHttpInfo(Integer xTenantId, String xAccessContractId, String id, String downloadType) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'xTenantId' is set
        if (xTenantId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xTenantId' when calling downloadReport");
        }
        
        // verify the required parameter 'xAccessContractId' is set
        if (xAccessContractId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xAccessContractId' when calling downloadReport");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling downloadReport");
        }
        
        // verify the required parameter 'downloadType' is set
        if (downloadType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'downloadType' when calling downloadReport");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        uriVariables.put("downloadType", downloadType);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        if (xTenantId != null)
        localVarHeaderParams.add("X-Tenant-Id", apiClient.parameterToString(xTenantId));
        if (xAccessContractId != null)
        localVarHeaderParams.add("X-Access-Contract-Id", apiClient.parameterToString(xAccessContractId));

        final String[] localVarAccepts = {  };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/v1/logbooks/operations/{id}/download/{downloadType}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get object lifecycle by id
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param xAccessContractId  (required)
     * @param id  (required)
     * @return LogbookLifeCycleResponseDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public LogbookLifeCycleResponseDto findObjectGroupLifeCyclesByUnitId(Integer xTenantId, String xAccessContractId, String id) throws RestClientException {
        return findObjectGroupLifeCyclesByUnitIdWithHttpInfo(xTenantId, xAccessContractId, id).getBody();
    }

    /**
     * Get object lifecycle by id
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param xAccessContractId  (required)
     * @param id  (required)
     * @return ResponseEntity&lt;LogbookLifeCycleResponseDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<LogbookLifeCycleResponseDto> findObjectGroupLifeCyclesByUnitIdWithHttpInfo(Integer xTenantId, String xAccessContractId, String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'xTenantId' is set
        if (xTenantId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xTenantId' when calling findObjectGroupLifeCyclesByUnitId");
        }
        
        // verify the required parameter 'xAccessContractId' is set
        if (xAccessContractId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xAccessContractId' when calling findObjectGroupLifeCyclesByUnitId");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling findObjectGroupLifeCyclesByUnitId");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        if (xTenantId != null)
        localVarHeaderParams.add("X-Tenant-Id", apiClient.parameterToString(xTenantId));
        if (xAccessContractId != null)
        localVarHeaderParams.add("X-Access-Contract-Id", apiClient.parameterToString(xAccessContractId));

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<LogbookLifeCycleResponseDto> localReturnType = new ParameterizedTypeReference<LogbookLifeCycleResponseDto>() {};
        return apiClient.invokeAPI("/v1/logbooks/objectslifecycles/{id}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get operation by id
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param xAccessContractId  (required)
     * @param id  (required)
     * @return LogbookOperationsCommonResponseDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public LogbookOperationsCommonResponseDto findOperationByUnitId(Integer xTenantId, String xAccessContractId, String id) throws RestClientException {
        return findOperationByUnitIdWithHttpInfo(xTenantId, xAccessContractId, id).getBody();
    }

    /**
     * Get operation by id
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param xAccessContractId  (required)
     * @param id  (required)
     * @return ResponseEntity&lt;LogbookOperationsCommonResponseDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<LogbookOperationsCommonResponseDto> findOperationByUnitIdWithHttpInfo(Integer xTenantId, String xAccessContractId, String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'xTenantId' is set
        if (xTenantId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xTenantId' when calling findOperationByUnitId");
        }
        
        // verify the required parameter 'xAccessContractId' is set
        if (xAccessContractId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xAccessContractId' when calling findOperationByUnitId");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling findOperationByUnitId");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        if (xTenantId != null)
        localVarHeaderParams.add("X-Tenant-Id", apiClient.parameterToString(xTenantId));
        if (xAccessContractId != null)
        localVarHeaderParams.add("X-Access-Contract-Id", apiClient.parameterToString(xAccessContractId));

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<LogbookOperationsCommonResponseDto> localReturnType = new ParameterizedTypeReference<LogbookOperationsCommonResponseDto>() {};
        return apiClient.invokeAPI("/v1/logbooks/operations/{id}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get log book operation by json select
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param body  (required)
     * @param vitamTenantIdentifier  (optional)
     * @return LogbookOperationsCommonResponseDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public LogbookOperationsCommonResponseDto findOperations(Integer xTenantId, Object body, Integer vitamTenantIdentifier) throws RestClientException {
        return findOperationsWithHttpInfo(xTenantId, body, vitamTenantIdentifier).getBody();
    }

    /**
     * Get log book operation by json select
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param body  (required)
     * @param vitamTenantIdentifier  (optional)
     * @return ResponseEntity&lt;LogbookOperationsCommonResponseDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<LogbookOperationsCommonResponseDto> findOperationsWithHttpInfo(Integer xTenantId, Object body, Integer vitamTenantIdentifier) throws RestClientException {
        Object localVarPostBody = body;
        
        // verify the required parameter 'xTenantId' is set
        if (xTenantId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xTenantId' when calling findOperations");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling findOperations");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "vitamTenantIdentifier", vitamTenantIdentifier));
        

        if (xTenantId != null)
        localVarHeaderParams.add("X-Tenant-Id", apiClient.parameterToString(xTenantId));

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<LogbookOperationsCommonResponseDto> localReturnType = new ParameterizedTypeReference<LogbookOperationsCommonResponseDto>() {};
        return apiClient.invokeAPI("/v1/logbooks/operations", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get unit lifecycle by id
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param xAccessContractId  (required)
     * @param id  (required)
     * @return LogbookLifeCycleResponseDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public LogbookLifeCycleResponseDto findUnitLifeCyclesByUnitId(Integer xTenantId, String xAccessContractId, String id) throws RestClientException {
        return findUnitLifeCyclesByUnitIdWithHttpInfo(xTenantId, xAccessContractId, id).getBody();
    }

    /**
     * Get unit lifecycle by id
     * 
     * <p><b>200</b> - OK
     * @param xTenantId  (required)
     * @param xAccessContractId  (required)
     * @param id  (required)
     * @return ResponseEntity&lt;LogbookLifeCycleResponseDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<LogbookLifeCycleResponseDto> findUnitLifeCyclesByUnitIdWithHttpInfo(Integer xTenantId, String xAccessContractId, String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'xTenantId' is set
        if (xTenantId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xTenantId' when calling findUnitLifeCyclesByUnitId");
        }
        
        // verify the required parameter 'xAccessContractId' is set
        if (xAccessContractId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xAccessContractId' when calling findUnitLifeCyclesByUnitId");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling findUnitLifeCyclesByUnitId");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        if (xTenantId != null)
        localVarHeaderParams.add("X-Tenant-Id", apiClient.parameterToString(xTenantId));
        if (xAccessContractId != null)
        localVarHeaderParams.add("X-Access-Contract-Id", apiClient.parameterToString(xAccessContractId));

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<LogbookLifeCycleResponseDto> localReturnType = new ParameterizedTypeReference<LogbookLifeCycleResponseDto>() {};
        return apiClient.invokeAPI("/v1/logbooks/unitlifecycles/{id}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
