package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;

import java.io.File;
import fr.gouv.vitamui.iam.openapiclient.domain.IdentityProviderDto;
import fr.gouv.vitamui.iam.openapiclient.domain.IdentityProvidersCreateRequest;
import fr.gouv.vitamui.iam.openapiclient.domain.IdentityProvidersPatchProviderIdpMetadataRequest;
import fr.gouv.vitamui.iam.openapiclient.domain.IdentityProvidersPatchProviderKeystoreRequest;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-10-29T21:39:28.961721984+01:00[Europe/Paris]", comments = "Generator version: 7.4.0")
public class IdentityProvidersApi {
    private ApiClient apiClient;

    public IdentityProvidersApi() {
        this(new ApiClient());
    }

    public IdentityProvidersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create an identity provider
     * 
     * <p><b>201</b> - Created
     * @param identityProvidersCreateRequest  (optional)
     * @return IdentityProviderDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public IdentityProviderDto create(IdentityProvidersCreateRequest identityProvidersCreateRequest) throws RestClientException {
        return createWithHttpInfo(identityProvidersCreateRequest).getBody();
    }

    /**
     * Create an identity provider
     * 
     * <p><b>201</b> - Created
     * @param identityProvidersCreateRequest  (optional)
     * @return ResponseEntity&lt;IdentityProviderDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<IdentityProviderDto> createWithHttpInfo(IdentityProvidersCreateRequest identityProvidersCreateRequest) throws RestClientException {
        Object localVarPostBody = identityProvidersCreateRequest;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<IdentityProviderDto> localReturnType = new ParameterizedTypeReference<IdentityProviderDto>() {};
        return apiClient.invokeAPI("/iam/v1/providers", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get all identity providers
     * 
     * <p><b>200</b> - OK
     * @param criteria  (optional)
     * @param embedded  (optional)
     * @return List&lt;IdentityProviderDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<IdentityProviderDto> getAll(String criteria, String embedded) throws RestClientException {
        return getAllWithHttpInfo(criteria, embedded).getBody();
    }

    /**
     * Get all identity providers
     * 
     * <p><b>200</b> - OK
     * @param criteria  (optional)
     * @param embedded  (optional)
     * @return ResponseEntity&lt;List&lt;IdentityProviderDto&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<IdentityProviderDto>> getAllWithHttpInfo(String criteria, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<List<IdentityProviderDto>> localReturnType = new ParameterizedTypeReference<List<IdentityProviderDto>>() {};
        return apiClient.invokeAPI("/iam/v1/providers", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get an identity provider&#39;s idp metadata by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return File
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public org.springframework.core.io.Resource getIdpMetadataProviderByProviderId(String id) throws RestClientException {
        return getIdpMetadataProviderByProviderIdWithHttpInfo(id).getBody();
    }

    /**
     * Get an identity provider&#39;s idp metadata by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;File&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<org.springframework.core.io.Resource> getIdpMetadataProviderByProviderIdWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getIdpMetadataProviderByProviderId");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<org.springframework.core.io.Resource> localReturnType = new ParameterizedTypeReference<org.springframework.core.io.Resource>() {};
        return apiClient.invokeAPI("/iam/v1/providers/{id}/idpMetadata", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get an identity provider by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param criteria  (optional)
     * @param embedded  (optional)
     * @return IdentityProviderDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public IdentityProviderDto getOne(String id, String criteria, String embedded) throws RestClientException {
        return getOneWithHttpInfo(id, criteria, embedded).getBody();
    }

    /**
     * Get an identity provider by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param criteria  (optional)
     * @param embedded  (optional)
     * @return ResponseEntity&lt;IdentityProviderDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<IdentityProviderDto> getOneWithHttpInfo(String id, String criteria, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getOne");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<IdentityProviderDto> localReturnType = new ParameterizedTypeReference<IdentityProviderDto>() {};
        return apiClient.invokeAPI("/iam/v1/providers/{id}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get an identity provider&#39;s sp metadata by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return File
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public org.springframework.core.io.Resource getSpMetadataProviderByProviderId(String id) throws RestClientException {
        return getSpMetadataProviderByProviderIdWithHttpInfo(id).getBody();
    }

    /**
     * Get an identity provider&#39;s sp metadata by its id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;File&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<org.springframework.core.io.Resource> getSpMetadataProviderByProviderIdWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getSpMetadataProviderByProviderId");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<org.springframework.core.io.Resource> localReturnType = new ParameterizedTypeReference<org.springframework.core.io.Resource>() {};
        return apiClient.invokeAPI("/iam/v1/providers/{id}/spMetadata", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Patch an identity provider
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param requestBody  (required)
     * @return IdentityProviderDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public IdentityProviderDto patch(String id, Map<String, Object> requestBody) throws RestClientException {
        return patchWithHttpInfo(id, requestBody).getBody();
    }

    /**
     * Patch an identity provider
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param requestBody  (required)
     * @return ResponseEntity&lt;IdentityProviderDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<IdentityProviderDto> patchWithHttpInfo(String id, Map<String, Object> requestBody) throws RestClientException {
        Object localVarPostBody = requestBody;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling patch");
        }
        
        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'requestBody' when calling patch");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<IdentityProviderDto> localReturnType = new ParameterizedTypeReference<IdentityProviderDto>() {};
        return apiClient.invokeAPI("/iam/v1/providers/{id}", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Update idpMetadata provider
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param identityProvidersPatchProviderIdpMetadataRequest  (optional)
     * @return IdentityProviderDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public IdentityProviderDto patchProviderIdpMetadata(String id, IdentityProvidersPatchProviderIdpMetadataRequest identityProvidersPatchProviderIdpMetadataRequest) throws RestClientException {
        return patchProviderIdpMetadataWithHttpInfo(id, identityProvidersPatchProviderIdpMetadataRequest).getBody();
    }

    /**
     * Update idpMetadata provider
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param identityProvidersPatchProviderIdpMetadataRequest  (optional)
     * @return ResponseEntity&lt;IdentityProviderDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<IdentityProviderDto> patchProviderIdpMetadataWithHttpInfo(String id, IdentityProvidersPatchProviderIdpMetadataRequest identityProvidersPatchProviderIdpMetadataRequest) throws RestClientException {
        Object localVarPostBody = identityProvidersPatchProviderIdpMetadataRequest;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling patchProviderIdpMetadata");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<IdentityProviderDto> localReturnType = new ParameterizedTypeReference<IdentityProviderDto>() {};
        return apiClient.invokeAPI("/iam/v1/providers/{id}/idpMetadata", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Patch a keystore provider
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param identityProvidersPatchProviderKeystoreRequest  (optional)
     * @return IdentityProviderDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public IdentityProviderDto patchProviderKeystore(String id, IdentityProvidersPatchProviderKeystoreRequest identityProvidersPatchProviderKeystoreRequest) throws RestClientException {
        return patchProviderKeystoreWithHttpInfo(id, identityProvidersPatchProviderKeystoreRequest).getBody();
    }

    /**
     * Patch a keystore provider
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @param identityProvidersPatchProviderKeystoreRequest  (optional)
     * @return ResponseEntity&lt;IdentityProviderDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<IdentityProviderDto> patchProviderKeystoreWithHttpInfo(String id, IdentityProvidersPatchProviderKeystoreRequest identityProvidersPatchProviderKeystoreRequest) throws RestClientException {
        Object localVarPostBody = identityProvidersPatchProviderKeystoreRequest;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling patchProviderKeystore");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<IdentityProviderDto> localReturnType = new ParameterizedTypeReference<IdentityProviderDto>() {};
        return apiClient.invokeAPI("/iam/v1/providers/{id}/keystore", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
