package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;

import fr.gouv.vitamui.iam.openapiclient.domain.ExternalParamProfileDto;
import fr.gouv.vitamui.iam.openapiclient.domain.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.openapiclient.domain.PaginatedValuesDtoExternalParamProfileDto;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-10-29T21:39:28.961721984+01:00[Europe/Paris]", comments = "Generator version: 7.4.0")
public class ExternalParamProfileApi {
    private ApiClient apiClient;

    public ExternalParamProfileApi() {
        this(new ApiClient());
    }

    public ExternalParamProfileApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Check existence of external parameter profile
     * 
     * <p><b>200</b> - OK
     * @param body  (optional)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void checkExist(String body) throws RestClientException {
        checkExistWithHttpInfo(body);
    }

    /**
     * Check existence of external parameter profile
     * 
     * <p><b>200</b> - OK
     * @param body  (optional)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> checkExistWithHttpInfo(String body) throws RestClientException {
        Object localVarPostBody = body;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = {  };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/iam/v1/externalparamprofile/check", HttpMethod.HEAD, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Create external parameter profile
     * 
     * <p><b>201</b> - Created
     * @param externalParamProfileDto  (required)
     * @return ExternalParamProfileDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ExternalParamProfileDto create(ExternalParamProfileDto externalParamProfileDto) throws RestClientException {
        return createWithHttpInfo(externalParamProfileDto).getBody();
    }

    /**
     * Create external parameter profile
     * 
     * <p><b>201</b> - Created
     * @param externalParamProfileDto  (required)
     * @return ResponseEntity&lt;ExternalParamProfileDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ExternalParamProfileDto> createWithHttpInfo(ExternalParamProfileDto externalParamProfileDto) throws RestClientException {
        Object localVarPostBody = externalParamProfileDto;
        
        // verify the required parameter 'externalParamProfileDto' is set
        if (externalParamProfileDto == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'externalParamProfileDto' when calling create");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<ExternalParamProfileDto> localReturnType = new ParameterizedTypeReference<ExternalParamProfileDto>() {};
        return apiClient.invokeAPI("/iam/v1/externalparamprofile", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get history by external parameter profile profile&#39;s id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return LogbookOperationsCommonResponseDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws RestClientException {
        return findHistoryByIdWithHttpInfo(id).getBody();
    }

    /**
     * Get history by external parameter profile profile&#39;s id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;LogbookOperationsCommonResponseDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<LogbookOperationsCommonResponseDto> findHistoryByIdWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling findHistoryById");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<LogbookOperationsCommonResponseDto> localReturnType = new ParameterizedTypeReference<LogbookOperationsCommonResponseDto>() {};
        return apiClient.invokeAPI("/iam/v1/externalparamprofile/{id}/history", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get external parameters profile, paginated result
     * 
     * <p><b>200</b> - OK
     * @param page  (required)
     * @param size  (required)
     * @param criteria  (optional)
     * @param orderBy  (optional)
     * @param direction  (optional)
     * @param embedded  (optional)
     * @return PaginatedValuesDtoExternalParamProfileDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public PaginatedValuesDtoExternalParamProfileDto getAllPaginated(Integer page, Integer size, String criteria, String orderBy, String direction, String embedded) throws RestClientException {
        return getAllPaginatedWithHttpInfo(page, size, criteria, orderBy, direction, embedded).getBody();
    }

    /**
     * Get external parameters profile, paginated result
     * 
     * <p><b>200</b> - OK
     * @param page  (required)
     * @param size  (required)
     * @param criteria  (optional)
     * @param orderBy  (optional)
     * @param direction  (optional)
     * @param embedded  (optional)
     * @return ResponseEntity&lt;PaginatedValuesDtoExternalParamProfileDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<PaginatedValuesDtoExternalParamProfileDto> getAllPaginatedWithHttpInfo(Integer page, Integer size, String criteria, String orderBy, String direction, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'page' is set
        if (page == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'page' when calling getAllPaginated");
        }
        
        // verify the required parameter 'size' is set
        if (size == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'size' when calling getAllPaginated");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "orderBy", orderBy));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "direction", direction));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<PaginatedValuesDtoExternalParamProfileDto> localReturnType = new ParameterizedTypeReference<PaginatedValuesDtoExternalParamProfileDto>() {};
        return apiClient.invokeAPI("/iam/v1/externalparamprofile", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get external parameter profile by id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ExternalParamProfileDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ExternalParamProfileDto getOne(String id) throws RestClientException {
        return getOneWithHttpInfo(id).getBody();
    }

    /**
     * Get external parameter profile by id
     * 
     * <p><b>200</b> - OK
     * @param id  (required)
     * @return ResponseEntity&lt;ExternalParamProfileDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ExternalParamProfileDto> getOneWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getOne");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<ExternalParamProfileDto> localReturnType = new ParameterizedTypeReference<ExternalParamProfileDto>() {};
        return apiClient.invokeAPI("/iam/v1/externalparamprofile/{id}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Patch external parameter profile
     * 
     * <p><b>200</b> - OK
     * @param requestBody  (required)
     * @return ExternalParamProfileDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ExternalParamProfileDto patchMe(Map<String, Object> requestBody) throws RestClientException {
        return patchMeWithHttpInfo(requestBody).getBody();
    }

    /**
     * Patch external parameter profile
     * 
     * <p><b>200</b> - OK
     * @param requestBody  (required)
     * @return ResponseEntity&lt;ExternalParamProfileDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ExternalParamProfileDto> patchMeWithHttpInfo(Map<String, Object> requestBody) throws RestClientException {
        Object localVarPostBody = requestBody;
        
        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'requestBody' when calling patchMe");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<ExternalParamProfileDto> localReturnType = new ParameterizedTypeReference<ExternalParamProfileDto>() {};
        return apiClient.invokeAPI("/iam/v1/externalparamprofile/me", HttpMethod.PATCH, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
