package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;

import fr.gouv.vitamui.iam.openapiclient.domain.CustomerDto;
import fr.gouv.vitamui.iam.openapiclient.domain.LoginRequestDto;
import fr.gouv.vitamui.iam.openapiclient.domain.SubrogationDto;
import fr.gouv.vitamui.iam.openapiclient.domain.UserDto;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-10-29T21:39:28.961721984+01:00[Europe/Paris]", comments = "Generator version: 7.4.0")
public class CasApi {
    private ApiClient apiClient;

    public CasApi() {
        this(new ApiClient());
    }

    public CasApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Change password of a user
     * 
     * <p><b>200</b> - OK
     * @param username  (required)
     * @param password  (required)
     * @param customerId  (required)
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public String changePassword(String username, String password, String customerId) throws RestClientException {
        return changePasswordWithHttpInfo(username, password, customerId).getBody();
    }

    /**
     * Change password of a user
     * 
     * <p><b>200</b> - OK
     * @param username  (required)
     * @param password  (required)
     * @param customerId  (required)
     * @return ResponseEntity&lt;String&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<String> changePasswordWithHttpInfo(String username, String password, String customerId) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'username' is set
        if (username == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'username' when calling changePassword");
        }
        
        // verify the required parameter 'password' is set
        if (password == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'password' when calling changePassword");
        }
        
        // verify the required parameter 'customerId' is set
        if (customerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customerId' when calling changePassword");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        if (username != null)
        localVarHeaderParams.add("username", apiClient.parameterToString(username));
        if (password != null)
        localVarHeaderParams.add("password", apiClient.parameterToString(password));
        if (customerId != null)
        localVarHeaderParams.add("customerId", apiClient.parameterToString(customerId));

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<String> localReturnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI("/iam/v1/cas/password/change", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get all customers by ids
     * 
     * <p><b>200</b> - OK
     * @param customerIds  (required)
     * @return List&lt;CustomerDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<CustomerDto> getCustomersByIds(List<String> customerIds) throws RestClientException {
        return getCustomersByIdsWithHttpInfo(customerIds).getBody();
    }

    /**
     * Get all customers by ids
     * 
     * <p><b>200</b> - OK
     * @param customerIds  (required)
     * @return ResponseEntity&lt;List&lt;CustomerDto&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<CustomerDto>> getCustomersByIdsWithHttpInfo(List<String> customerIds) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'customerIds' is set
        if (customerIds == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customerIds' when calling getCustomersByIds");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "customerIds", customerIds));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<List<CustomerDto>> localReturnType = new ParameterizedTypeReference<List<CustomerDto>>() {};
        return apiClient.invokeAPI("/iam/v1/cas/customers", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get available subrogations for a super user by super user id or by super user email and customerId
     * 
     * <p><b>200</b> - OK
     * @param superUserId  (optional)
     * @param superUserEmail  (optional)
     * @param superUserCustomerId  (optional)
     * @return List&lt;SubrogationDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<SubrogationDto> getSubrogationsBySuperUserIdOrEmailAndCustomerId(String superUserId, String superUserEmail, String superUserCustomerId) throws RestClientException {
        return getSubrogationsBySuperUserIdOrEmailAndCustomerIdWithHttpInfo(superUserId, superUserEmail, superUserCustomerId).getBody();
    }

    /**
     * Get available subrogations for a super user by super user id or by super user email and customerId
     * 
     * <p><b>200</b> - OK
     * @param superUserId  (optional)
     * @param superUserEmail  (optional)
     * @param superUserCustomerId  (optional)
     * @return ResponseEntity&lt;List&lt;SubrogationDto&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<SubrogationDto>> getSubrogationsBySuperUserIdOrEmailAndCustomerIdWithHttpInfo(String superUserId, String superUserEmail, String superUserCustomerId) throws RestClientException {
        Object localVarPostBody = null;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "superUserId", superUserId));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "superUserEmail", superUserEmail));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "superUserCustomerId", superUserCustomerId));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<List<SubrogationDto>> localReturnType = new ParameterizedTypeReference<List<SubrogationDto>>() {};
        return apiClient.invokeAPI("/iam/v1/cas/subrogations", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get a user by their loginEmail, loginCustomerId and idp
     * 
     * <p><b>200</b> - OK
     * @param loginEmail  (required)
     * @param loginCustomerId  (required)
     * @param idp  (required)
     * @param userIdentifier  (optional)
     * @param embedded  (optional)
     * @return UserDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public UserDto getUser(String loginEmail, String loginCustomerId, String idp, String userIdentifier, String embedded) throws RestClientException {
        return getUserWithHttpInfo(loginEmail, loginCustomerId, idp, userIdentifier, embedded).getBody();
    }

    /**
     * Get a user by their loginEmail, loginCustomerId and idp
     * 
     * <p><b>200</b> - OK
     * @param loginEmail  (required)
     * @param loginCustomerId  (required)
     * @param idp  (required)
     * @param userIdentifier  (optional)
     * @param embedded  (optional)
     * @return ResponseEntity&lt;UserDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<UserDto> getUserWithHttpInfo(String loginEmail, String loginCustomerId, String idp, String userIdentifier, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'loginEmail' is set
        if (loginEmail == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'loginEmail' when calling getUser");
        }
        
        // verify the required parameter 'loginCustomerId' is set
        if (loginCustomerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'loginCustomerId' when calling getUser");
        }
        
        // verify the required parameter 'idp' is set
        if (idp == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idp' when calling getUser");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "loginEmail", loginEmail));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "loginCustomerId", loginCustomerId));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "idp", idp));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "userIdentifier", userIdentifier));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<UserDto> localReturnType = new ParameterizedTypeReference<UserDto>() {};
        return apiClient.invokeAPI("/iam/v1/cas/users/provisioning", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get all users having a given email address
     * 
     * <p><b>200</b> - OK
     * @param email  (required)
     * @param embedded  (optional)
     * @return List&lt;UserDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<UserDto> getUsersByEmail(String email, String embedded) throws RestClientException {
        return getUsersByEmailWithHttpInfo(email, embedded).getBody();
    }

    /**
     * Get all users having a given email address
     * 
     * <p><b>200</b> - OK
     * @param email  (required)
     * @param embedded  (optional)
     * @return ResponseEntity&lt;List&lt;UserDto&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<UserDto>> getUsersByEmailWithHttpInfo(String email, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'email' is set
        if (email == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'email' when calling getUsersByEmail");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "email", email));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<List<UserDto>> localReturnType = new ParameterizedTypeReference<List<UserDto>>() {};
        return apiClient.invokeAPI("/iam/v1/cas/users", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Performs the login of a user
     * 
     * <p><b>200</b> - OK
     * @param loginRequestDto  (required)
     * @return UserDto
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public UserDto login(LoginRequestDto loginRequestDto) throws RestClientException {
        return loginWithHttpInfo(loginRequestDto).getBody();
    }

    /**
     * Performs the login of a user
     * 
     * <p><b>200</b> - OK
     * @param loginRequestDto  (required)
     * @return ResponseEntity&lt;UserDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<UserDto> loginWithHttpInfo(LoginRequestDto loginRequestDto) throws RestClientException {
        Object localVarPostBody = loginRequestDto;
        
        // verify the required parameter 'loginRequestDto' is set
        if (loginRequestDto == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'loginRequestDto' when calling login");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<UserDto> localReturnType = new ParameterizedTypeReference<UserDto>() {};
        return apiClient.invokeAPI("/iam/v1/cas/login", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Logout a user, remove the token and delete the subrogation if needed
     * 
     * <p><b>200</b> - OK
     * @param authToken  (required)
     * @param superUser  (required)
     * @param superUserCustomerId  (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void logout(String authToken, String superUser, String superUserCustomerId) throws RestClientException {
        logoutWithHttpInfo(authToken, superUser, superUserCustomerId);
    }

    /**
     * Logout a user, remove the token and delete the subrogation if needed
     * 
     * <p><b>200</b> - OK
     * @param authToken  (required)
     * @param superUser  (required)
     * @param superUserCustomerId  (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> logoutWithHttpInfo(String authToken, String superUser, String superUserCustomerId) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'authToken' is set
        if (authToken == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authToken' when calling logout");
        }
        
        // verify the required parameter 'superUser' is set
        if (superUser == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'superUser' when calling logout");
        }
        
        // verify the required parameter 'superUserCustomerId' is set
        if (superUserCustomerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'superUserCustomerId' when calling logout");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "authToken", authToken));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "superUser", superUser));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "superUserCustomerId", superUserCustomerId));
        

        final String[] localVarAccepts = {  };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/iam/v1/cas/logout", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
