package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;

import fr.gouv.vitamui.iam.openapiclient.domain.ApplicationDto;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-10-29T21:39:28.961721984+01:00[Europe/Paris]", comments = "Generator version: 7.4.0")
public class ApplicationsApi {
    private ApiClient apiClient;

    public ApplicationsApi() {
        this(new ApiClient());
    }

    public ApplicationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Return all applications matching user privileges
     * 
     * <p><b>200</b> - OK
     * @param criteria Criteria to filter the applications (optional)
     * @param embedded  (optional)
     * @return List&lt;ApplicationDto&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<ApplicationDto> getAll(String criteria, String embedded) throws RestClientException {
        return getAllWithHttpInfo(criteria, embedded).getBody();
    }

    /**
     * Return all applications matching user privileges
     * 
     * <p><b>200</b> - OK
     * @param criteria Criteria to filter the applications (optional)
     * @param embedded  (optional)
     * @return ResponseEntity&lt;List&lt;ApplicationDto&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<ApplicationDto>> getAllWithHttpInfo(String criteria, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<List<ApplicationDto>> localReturnType = new ParameterizedTypeReference<List<ApplicationDto>>() {};
        return apiClient.invokeAPI("/iam/v1/applications", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Return config about applications and categories
     * 
     * <p><b>200</b> - OK
     * @param filterApp  (optional, default to true)
     * @return Map&lt;String, List&lt;ApplicationDto&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Map<String, List<ApplicationDto>> getApplicationsFromUi(Boolean filterApp) throws RestClientException {
        return getApplicationsFromUiWithHttpInfo(filterApp).getBody();
    }

    /**
     * Return config about applications and categories
     * 
     * <p><b>200</b> - OK
     * @param filterApp  (optional, default to true)
     * @return ResponseEntity&lt;Map&lt;String, List&lt;ApplicationDto&gt;&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Map<String, List<ApplicationDto>>> getApplicationsFromUiWithHttpInfo(Boolean filterApp) throws RestClientException {
        Object localVarPostBody = null;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filterApp", filterApp));
        

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Map<String, List<ApplicationDto>>> localReturnType = new ParameterizedTypeReference<Map<String, List<ApplicationDto>>>() {};
        return apiClient.invokeAPI("/iam/v1/applications/filtered", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Check if an application can have an external identifier
     * 
     * <p><b>200</b> - OK
     * @param identifier  (required)
     * @return Boolean
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Boolean isApplicationExternalIdentifierEnabled(String identifier) throws RestClientException {
        return isApplicationExternalIdentifierEnabledWithHttpInfo(identifier).getBody();
    }

    /**
     * Check if an application can have an external identifier
     * 
     * <p><b>200</b> - OK
     * @param identifier  (required)
     * @return ResponseEntity&lt;Boolean&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Boolean> isApplicationExternalIdentifierEnabledWithHttpInfo(String identifier) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'identifier' when calling isApplicationExternalIdentifierEnabled");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("identifier", identifier);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "x-tenant-id", "bearer" };

        ParameterizedTypeReference<Boolean> localReturnType = new ParameterizedTypeReference<Boolean>() {};
        return apiClient.invokeAPI("/iam/v1/applications/{identifier}/externalid", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
