/**
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 *
 * contact@programmevitam.fr
 *
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */

package fr.gouv.vitamui.iam.server.rest;

import fr.gouv.vitamui.commons.api.CommonConstants;
import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.ParameterDto;
import fr.gouv.vitamui.commons.api.domain.ServicesData;
import fr.gouv.vitamui.iam.common.rest.RestApi;
import fr.gouv.vitamui.iam.server.externalParameters.service.ExternalParametersService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Getter;
import lombok.Setter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * The controller to check existence, create, read, update and delete the external parameters.
 */
@RestController
@RequestMapping(RestApi.V1_EXTERNAL_PARAMETERS_URL)
@Getter
@Setter
@Tag(name = "ExternalParameters", description = "External Parameters Management")
public class ExternalParametersController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalParametersController.class);

    private ExternalParametersService externalParametersService;

    @Autowired
    public ExternalParametersController(final ExternalParametersService externalParametersService) {
        this.externalParametersService = externalParametersService;
    }

    /**
     * Retrieve the external parameters associated to the authenticated user.
     * @return
     */
    @GetMapping(CommonConstants.PATH_ME)
    @Operation(
        operationId = "externalParameters_getMyExternalParameters",
        summary = "Get external parameters of the authenticated user"
    )
    @Secured({ ServicesData.ROLE_GET_EXTERNAL_PARAMS, ServicesData.ROLE_INTERNAL })
    public Map<String, String> getMyExternalParameters() {
        LOGGER.debug("GetMyExternalParameters");
        final ExternalParametersDto userParameters = externalParametersService.getMyExternalParameters();
        if (userParameters != null && userParameters.getParameters() != null) {
            return userParameters
                .getParameters()
                .stream()
                .collect(Collectors.toMap(ParameterDto::getKey, ParameterDto::getValue));
        }
        return Collections.emptyMap();
    }
}
