/**
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 *
 * contact@programmevitam.fr
 *
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */
package fr.gouv.vitamui.iam.server.provisioning.client;

import fr.gouv.vitamui.commons.rest.client.BaseCrudWebClient;
import fr.gouv.vitamui.commons.rest.client.BaseWebClient;
import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.iam.common.dto.ProvidedUserDto;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.WebClient;

/**
 * External WebClient for Customer operations.
 *
 *
 */
public class ProvisioningWebClient extends BaseWebClient<HttpContext> {

    private static final Logger LOGGER = LoggerFactory.getLogger(ProvisioningWebClient.class);

    public ProvisioningWebClient(final WebClient webClient, final String baseUrl) {
        super(webClient, baseUrl);
    }

    public ProvidedUserDto getProvidedUser(
        final HttpContext context,
        final String email,
        final String loginCustomerId,
        final String groupId,
        final String unit,
        final String userIdentifier
    ) {
        final URIBuilder builder = getUriBuilderFromUrl();

        if (StringUtils.isNotBlank(email)) {
            builder.addParameter("email", email);
        }
        if (StringUtils.isNotBlank(loginCustomerId)) {
            builder.addParameter("customerId", loginCustomerId);
        }
        if (StringUtils.isNotBlank(groupId)) {
            builder.addParameter("groupId", groupId);
        }
        if (StringUtils.isNotBlank(unit)) {
            builder.addParameter("unit", unit);
        }
        if (StringUtils.isNotBlank(userIdentifier)) {
            builder.addParameter("technicalUserId", userIdentifier);
        }

        return webClient
            .get()
            .uri(buildUriBuilder(builder))
            .headers(headersConsumer -> headersConsumer.addAll(buildHeaders(context)))
            .retrieve()
            .onStatus(status -> !status.is2xxSuccessful(), BaseCrudWebClient::createResponseException)
            .bodyToMono(ProvidedUserDto.class)
            .block();
    }

    //PATH URL is given by configuration
    @Override
    public String getPathUrl() {
        return StringUtils.EMPTY;
    }
}
