/**
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 *
 * contact@programmevitam.fr
 *
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */
package fr.gouv.vitamui.iam.server.customer.domain;

import fr.gouv.vitamui.commons.mongo.IdDocument;
import fr.gouv.vitamui.iam.common.enums.OtpEnum;
import fr.gouv.vitamui.iam.server.common.domain.Address;
import fr.gouv.vitamui.iam.server.common.domain.MongoDbCollections;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.data.annotation.TypeAlias;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * A customer.
 *
 *
 */
@Document(collection = MongoDbCollections.CUSTOMERS)
@TypeAlias(MongoDbCollections.CUSTOMERS)
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class Customer extends IdDocument {

    @NotNull
    @Size(min = 1, max = 12)
    private String identifier;

    @NotNull
    @Size(min = 4, max = 25)
    @Indexed(name = "idx_customer_code", unique = true, background = true)
    private String code;

    @NotNull
    @Size(max = 100)
    @Indexed(name = "idx_customer_name", background = true)
    private String name;

    @NotNull
    @Size(max = 250)
    private String companyName;

    private boolean enabled;

    @NotNull
    private String language;

    @NotNull
    private Integer passwordRevocationDelay;

    @NotNull
    private OtpEnum otp;

    @NotNull
    @Size(min = 1)
    private List<String> emailDomains;

    @NotNull
    private String defaultEmailDomain;

    @NotNull
    private Address address;

    private String internalCode;

    private boolean readonly = false;

    private boolean subrogeable = false;

    @NotNull
    private GraphicIdentity graphicIdentity = new GraphicIdentity();

    Map<String, String> portalTitles = new HashMap<>();

    Map<String, String> portalMessages = new HashMap<>();

    @Getter
    private boolean gdprAlert = false;

    private int gdprAlertDelay;
}
