/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitamUIAccessContractCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitamUIAccessContractCommonService.class);
    private final AdminExternalClient adminExternalClient;

    public VitamUIAccessContractCommonService(AdminExternalClient adminExternalClient) {
        this.adminExternalClient = adminExternalClient;
    }

    public RequestResponse<AccessContractModel> patchAccessContract(VitamContext vitamContext, String id, JsonNode jsonNode) throws InvalidParseOperationException, AccessExternalClientException {
        LOGGER.debug("patch: {}, {}", (Object)id, (Object)jsonNode);
        LOGGER.debug("Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.updateAccessContract(vitamContext, id, jsonNode);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }
}

