/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.FileRulesModel;
import fr.gouv.vitam.common.model.administration.RuleMeasurementEnum;
import fr.gouv.vitam.common.model.administration.RuleType;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.exception.UnavailableServiceException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.rest.dto.RuleDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.RuleNodeResponseDto;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.RuleCSVDto;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;

public class VitamRuleCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitamRuleCommonService.class);
    private final AdminExternalClient adminExternalClient;
    private final AccessExternalClient accessExternalClient;
    private ObjectMapper objectMapper;

    public VitamRuleCommonService(AdminExternalClient adminExternalClient, ObjectMapper objectMapper, AccessExternalClient accessExternalClient) {
        this.adminExternalClient = adminExternalClient;
        this.objectMapper = objectMapper;
        this.accessExternalClient = accessExternalClient;
    }

    public RequestResponse<FileRulesModel> findRules(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        RequestResponse response = this.adminExternalClient.findRules(vitamContext, select);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    public RequestResponse<FileRulesModel> findRuleById(VitamContext vitamContext, String ruleId) throws VitamClientException {
        RequestResponse response = this.adminExternalClient.findRuleById(vitamContext, ruleId);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    private void patchFields(FileRulesModel ruleToPatch, FileRulesModel fieldsToApply) {
        String ruleDescription;
        RuleMeasurementEnum ruleMeasurement;
        String ruleDuration;
        String ruleValue;
        LOGGER.debug("Patching rule {} with fields {}", (Object)ruleToPatch, (Object)fieldsToApply);
        RuleType ruleType = fieldsToApply.getRuleType();
        if (ruleType != null) {
            ruleToPatch.setRuleType(ruleType);
        }
        if ((ruleValue = fieldsToApply.getRuleValue()) != null) {
            ruleToPatch.setRuleValue(ruleValue);
        }
        if ((ruleDuration = fieldsToApply.getRuleDuration()) != null) {
            ruleToPatch.setRuleDuration(ruleDuration);
        }
        if ((ruleMeasurement = fieldsToApply.getRuleMeasurement()) != null) {
            ruleToPatch.setRuleMeasurement(ruleMeasurement);
        }
        if ((ruleDescription = fieldsToApply.getRuleDescription()) != null) {
            ruleToPatch.setRuleDescription(ruleDescription);
        }
    }

    public boolean patchRule(VitamContext vitamContext, String ruleId, FileRulesModel patchRule) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException, JAXBException {
        RequestResponse<FileRulesModel> requestResponse = this.findRules(vitamContext, (JsonNode)new Select().getFinalSelect());
        List actualRules = ((RuleNodeResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), RuleNodeResponseDto.class)).getResults();
        LOGGER.debug("inputPatchRule {}", (Object)patchRule);
        LOGGER.debug("Actual rules before patching : {}", (Object)actualRules);
        actualRules.stream().filter(rule -> ruleId.equals(rule.getRuleId())).forEach(rule -> {
            LOGGER.debug("Rule before patching {}", rule);
            this.patchFields((FileRulesModel)rule, patchRule);
            LOGGER.debug("Rule after patching {}", rule);
        });
        LOGGER.debug("Actual rules after patching : {}", (Object)actualRules);
        RequestResponse response = this.importRules(vitamContext, actualRules);
        return this.checkImportRulesResponse(response);
    }

    public boolean deleteRule(VitamContext vitamContext, String ruleId) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException, JAXBException {
        RequestResponse<FileRulesModel> requestResponse = this.findRules(vitamContext, (JsonNode)new Select().getFinalSelect());
        List actualRules = ((RuleNodeResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), RuleNodeResponseDto.class)).getResults();
        List<FileRulesModel> newRulesList = actualRules.stream().filter(rule -> !ruleId.equals(rule.getRuleId())).collect(Collectors.toList());
        RequestResponse response = this.importRules(vitamContext, newRulesList);
        return this.checkImportRulesResponse(response);
    }

    public boolean createRule(VitamContext vitamContext, FileRulesModel newRule) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException, JAXBException {
        RequestResponse<FileRulesModel> requestResponse = this.findRules(vitamContext, (JsonNode)new Select().getFinalSelect());
        List actualRules = ((RuleNodeResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), RuleNodeResponseDto.class)).getResults();
        LOGGER.debug("Before Add List: {}", (Object)actualRules);
        actualRules.add(newRule);
        LOGGER.debug("After Add List: {}", (Object)actualRules);
        RequestResponse response = this.importRules(vitamContext, actualRules);
        return this.checkImportRulesResponse(response);
    }

    private RequestResponse importRules(VitamContext vitamContext, List<FileRulesModel> rulesModels) throws InvalidParseOperationException, AccessExternalClientException, IOException, JAXBException {
        try (ByteArrayInputStream byteArrayInputStream = this.serializeRules(rulesModels);){
            RequestResponse requestResponse;
            block12: {
                ByteArrayInputStream debugStream = this.serializeRules(rulesModels);
                try {
                    requestResponse = this.adminExternalClient.createRules(vitamContext, (InputStream)byteArrayInputStream, "Rules.csv");
                    if (debugStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (debugStream != null) {
                        try {
                            debugStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                debugStream.close();
            }
            return requestResponse;
        }
    }

    private ByteArrayInputStream serializeRules(List<FileRulesModel> ruleDtos) throws IOException {
        List<RuleCSVDto> listOfRules = this.convertDtosToCsvDtos(ruleDtos);
        LOGGER.debug("The json for creation rules, sent to Vitam {}", listOfRules);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            CsvMapper csvMapper = (CsvMapper)((CsvMapper.Builder)CsvMapper.builder().disable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).build();
            CsvSchema schema = csvMapper.schemaFor(RuleCSVDto.class).withColumnSeparator(',').withHeader();
            ObjectWriter writer = csvMapper.writer((FormatSchema)schema);
            writer.writeValue((OutputStream)byteArrayOutputStream, listOfRules);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    private RuleCSVDto convertDtoToCsvDto(FileRulesModel rule) {
        RuleCSVDto csvDto = new RuleCSVDto();
        csvDto.setRuleId(rule.getRuleId());
        if (rule.getRuleType() != null) {
            csvDto.setRuleType(rule.getRuleType().name());
        }
        csvDto.setRuleValue(rule.getRuleValue());
        csvDto.setRuleDescription(rule.getRuleDescription());
        csvDto.setRuleDuration(rule.getRuleDuration());
        if (rule.getRuleMeasurement() != null) {
            csvDto.setRuleMeasurement(rule.getRuleMeasurement().getType());
        }
        return csvDto;
    }

    private List<RuleCSVDto> convertDtosToCsvDtos(List<FileRulesModel> rules) {
        return rules.stream().map(this::convertDtoToCsvDto).collect(Collectors.toList());
    }

    public boolean checkExistenceOfRuleInVitam(RuleDto ruleDto, VitamContext vitamContext) {
        if (ruleDto != null && ruleDto.getRuleId() != null) {
            try {
                ObjectNode select = new Select().getFinalSelect();
                RequestResponse<FileRulesModel> response = this.findRules(vitamContext, (JsonNode)select);
                if (response.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
                    LOGGER.error("Can't create rule for the tenant : UNAUTHORIZED");
                    throw new PreconditionFailedException("Can't create rule for the tenant : UNAUTHORIZED");
                }
                if (response.getStatus() != HttpStatus.OK.value()) {
                    LOGGER.error("Can't create rule for this tenant, Vitam response code : " + response.getStatus());
                    throw new UnavailableServiceException("Can't create rule for this tenant, Vitam response code : " + response.getStatus());
                }
                this.verifyRuleExistence(ruleDto, response);
            }
            catch (VitamClientException exception) {
                LOGGER.error("Can't create rules for this tenant, error while calling Vitam : " + String.valueOf((Object)exception));
                throw new UnavailableServiceException("Can't create rules for this tenant, error while calling Vitam : " + String.valueOf((Object)exception));
            }
            return true;
        }
        throw new BadRequestException("The body is not found");
    }

    private void verifyRuleExistence(RuleDto checkRule, RequestResponse<FileRulesModel> existingRules) {
        try {
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            RuleNodeResponseDto existingRulesDto = (RuleNodeResponseDto)this.objectMapper.treeToValue((TreeNode)existingRules.toJsonNode(), RuleNodeResponseDto.class);
            if (checkRule.getRuleType() == null) {
                if (existingRulesDto.getResults().stream().noneMatch(existingRule -> existingRule.getRuleId().equals(checkRule.getRuleId()))) {
                    LOGGER.error("Can't find the requested rule with id {} and category {}, this rule does not exist in VITAM", (Object)checkRule.getRuleId(), (Object)checkRule.getRuleType());
                    throw new ConflictException("Can't find the requested rule  with id and category, this rule does not exist in VITAM");
                }
            } else if (existingRulesDto.getResults().stream().noneMatch(existingRule -> existingRule.getRuleId().equals(checkRule.getRuleId()) && existingRule.getRuleType().name().equals(checkRule.getRuleType()))) {
                LOGGER.error("Can't find the requested rule with identifier, this rule does not exist in VITAM");
                throw new ConflictException("Can't find the requested rule with identifier %s, this rule does not exist in VITAM".formatted(checkRule.getRuleId()), checkRule.getRuleId());
            }
        }
        catch (JsonProcessingException exception) {
            LOGGER.error("Can't find the requested rule, Error while parsing Vitam response : ", (Throwable)exception);
            throw new UnexpectedDataException("Can't create rule, Error while parsing Vitam response : " + String.valueOf((Object)exception));
        }
    }

    public Response export(VitamContext context) throws InvalidParseOperationException, InvalidCreateOperationException, VitamClientException {
        JsonNode query = VitamQueryHelper.getLastOperationQuery("STP_IMPORT_RULES.OK");
        RequestResponse lastImportOperationResponse = this.accessExternalClient.selectOperations(context, query);
        LogbookOperationsCommonResponseDto lastImportOperation = (LogbookOperationsCommonResponseDto)VitamRestUtils.responseMapping((JsonNode)lastImportOperationResponse.toJsonNode(), LogbookOperationsCommonResponseDto.class);
        if (lastImportOperation.getHits().getTotal() == 0) {
            throw new VitamClientException("Can't get a result while selecting last rule import");
        }
        return this.adminExternalClient.downloadRulesCsvAsStream(context, ((LogbookOperationDto)lastImportOperation.getResults().get(0)).getEvId());
    }

    public RequestResponse<?> importRules(VitamContext vitamContext, String fileName, MultipartFile file) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException {
        LOGGER.debug("Import rule file {}", (Object)fileName);
        RequestResponse response = this.adminExternalClient.createRules(vitamContext, file.getInputStream(), fileName);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    private boolean checkImportRulesResponse(RequestResponse response) {
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[]{HttpStatus.OK.value(), HttpStatus.CREATED.value(), HttpStatus.ACCEPTED.value(), HttpStatus.BAD_REQUEST.value()});
        return response.getStatus() == HttpStatus.OK.value() || response.getStatus() == HttpStatus.CREATED.value() || response.getStatus() == HttpStatus.ACCEPTED.value();
    }
}

