/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.FileFormatModel;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.exception.UnavailableServiceException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.referential.common.dto.FileFormatResponseDto;
import fr.gouv.vitamui.referential.common.dto.xml.fileformat.FileFormat;
import fr.gouv.vitamui.referential.common.dto.xml.fileformat.FileFormatCollection;
import fr.gouv.vitamui.referential.common.dto.xml.fileformat.FileFormatXMLRootDto;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;

public class VitamFileFormatCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitamFileFormatCommonService.class);
    private final AdminExternalClient adminExternalClient;
    private final AccessExternalClient accessExternalClient;
    private ObjectMapper objectMapper;

    public VitamFileFormatCommonService(AdminExternalClient adminExternalClient, ObjectMapper objectMapper, AccessExternalClient accessExternalClient) {
        this.adminExternalClient = adminExternalClient;
        this.objectMapper = objectMapper;
        this.accessExternalClient = accessExternalClient;
    }

    public RequestResponse<FileFormatModel> findFileFormats(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        LOGGER.info("File Formats EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.findFormats(vitamContext, select);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    public RequestResponse<FileFormatModel> findFileFormatById(VitamContext vitamContext, String formatId) throws VitamClientException {
        LOGGER.info("File Format EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        try {
            Select select = new Select();
            select.setQuery((Query)QueryHelper.eq((String)"PUID", (String)formatId));
            RequestResponse response = this.adminExternalClient.findFormats(vitamContext, (JsonNode)select.getFinalSelect());
            VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
            return response;
        }
        catch (InvalidCreateOperationException icoe) {
            throw new VitamClientException((Throwable)icoe);
        }
    }

    private void patchFields(FileFormatModel fileFormatToPatch, FileFormatModel fieldsToApply) {
        if (fieldsToApply.getName() != null) {
            fileFormatToPatch.setName(fieldsToApply.getName());
        }
        if (fieldsToApply.getMimeType() != null) {
            fileFormatToPatch.setMimeType(fieldsToApply.getMimeType());
        }
        if (fieldsToApply.getVersion() != null) {
            fileFormatToPatch.setVersion(fieldsToApply.getVersion());
        }
        if (fieldsToApply.getExtensions() != null) {
            fileFormatToPatch.setExtensions(fieldsToApply.getExtensions());
        }
        if (fieldsToApply.getHasPriorityOverFileFormatIDs() != null) {
            fileFormatToPatch.setHasPriorityOverFileFormatIDs(fieldsToApply.getHasPriorityOverFileFormatIDs());
        }
    }

    public RequestResponse<?> patchFileFormat(VitamContext vitamContext, String id, FileFormatModel patchFileFormat) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException, JAXBException {
        RequestResponse<FileFormatModel> requestResponse = this.findFileFormats(vitamContext, (JsonNode)new Select().getFinalSelect());
        List actualFileFormats = ((FileFormatResponseDto)((Object)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatResponseDto.class))).getResults();
        actualFileFormats.stream().filter(fileFormat -> id.equals(fileFormat.getPuid())).forEach(fileFormat -> this.patchFields((FileFormatModel)fileFormat, patchFileFormat));
        return this.importFileFormats(vitamContext, actualFileFormats);
    }

    public RequestResponse<?> deleteFileFormat(VitamContext vitamContext, String id) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException, JAXBException {
        LOGGER.debug("Delete File Format EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse<FileFormatModel> requestResponse = this.findFileFormats(vitamContext, (JsonNode)new Select().getFinalSelect());
        List actualFileFormats = ((FileFormatResponseDto)((Object)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatResponseDto.class))).getResults();
        return this.importFileFormats(vitamContext, actualFileFormats.stream().filter(fileFormat -> !id.equals(fileFormat.getPuid())).collect(Collectors.toList()));
    }

    public RequestResponse<?> create(VitamContext vitamContext, FileFormatModel newFileFormat) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException, JAXBException {
        LOGGER.debug("Create File Format EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse<FileFormatModel> requestResponse = this.findFileFormats(vitamContext, (JsonNode)new Select().getFinalSelect());
        List actualFileFormats = ((FileFormatResponseDto)((Object)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatResponseDto.class))).getResults();
        LOGGER.debug("Before Add List: {}", (Object)actualFileFormats);
        actualFileFormats.add(newFileFormat);
        LOGGER.debug("After Add List: {}", (Object)actualFileFormats);
        return this.importFileFormats(vitamContext, actualFileFormats);
    }

    public RequestResponse<?> importFileFormats(VitamContext vitamContext, String fileName, MultipartFile file) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException {
        LOGGER.debug("Import file format file {}", (Object)fileName);
        return this.adminExternalClient.createFormats(vitamContext, file.getInputStream(), fileName);
    }

    private RequestResponse<?> importFileFormats(VitamContext vitamContext, List<FileFormatModel> fileFormatModels) throws InvalidParseOperationException, AccessExternalClientException, IOException, JAXBException {
        try (ByteArrayInputStream byteArrayInputStream = this.serializeFileFormats(fileFormatModels);){
            RequestResponse requestResponse = this.adminExternalClient.createFormats(vitamContext, (InputStream)byteArrayInputStream, "FileFormats.json");
            return requestResponse;
        }
    }

    private ByteArrayInputStream serializeFileFormats(List<FileFormatModel> fileFormatDtos) throws IOException, JAXBException {
        FileFormatXMLRootDto fileFormatXMLDto = this.convertDtosToXmlDto(fileFormatDtos);
        LOGGER.debug("The dto for creation fileFormats, sent to Vitam {}", (Object)fileFormatXMLDto);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{fileFormatXMLDto.getClass()});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)fileFormatXMLDto, (OutputStream)byteArrayOutputStream);
            LOGGER.debug("XML FileFormat: {}", (Object)byteArrayOutputStream.toString());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    private FileFormatXMLRootDto convertDtosToXmlDto(List<FileFormatModel> inputFileFormats) {
        HashMap<String, Integer> puidToId = new HashMap<String, Integer>();
        HashMap<String, List> hasPriorityOverFileFormat = new HashMap<String, List>();
        ArrayList<FileFormat> fileFormats = new ArrayList<FileFormat>();
        Integer formatIdentifier = 0;
        for (FileFormatModel inputFileFormat : inputFileFormats) {
            FileFormat fileFormat = new FileFormat();
            fileFormat.setId(formatIdentifier);
            fileFormat.setName(inputFileFormat.getName());
            fileFormat.setPuid(inputFileFormat.getPuid());
            fileFormat.setExtension(inputFileFormat.getExtensions());
            fileFormat.setMimeType(inputFileFormat.getMimeType());
            fileFormat.setVersion(inputFileFormat.getVersion());
            List priorityOverFileFormat = inputFileFormat.getHasPriorityOverFileFormatIDs();
            if (priorityOverFileFormat != null && !priorityOverFileFormat.isEmpty()) {
                hasPriorityOverFileFormat.put(inputFileFormat.getPuid(), priorityOverFileFormat);
            } else {
                hasPriorityOverFileFormat.put(inputFileFormat.getPuid(), new ArrayList());
            }
            puidToId.put(inputFileFormat.getPuid(), formatIdentifier);
            Integer n = formatIdentifier;
            formatIdentifier = formatIdentifier + 1;
            fileFormats.add(fileFormat);
        }
        for (FileFormat fileFormat : fileFormats) {
            ArrayList<Integer> priorityIds = new ArrayList<Integer>();
            for (String priorityOverFormatId : (List)hasPriorityOverFileFormat.get(fileFormat.getPuid())) {
                priorityIds.add((Integer)puidToId.get(priorityOverFormatId));
            }
            fileFormat.setHasPriorityOverFileFormatIDs(priorityIds);
        }
        FileFormatXMLRootDto root = new FileFormatXMLRootDto();
        root.setVersion(109);
        root.setCreatedDate(new Date());
        FileFormatCollection fileCollection = new FileFormatCollection();
        fileCollection.setFileFormats(fileFormats);
        root.setFileFormatCollection(fileCollection);
        return root;
    }

    public boolean checkAbilityToCreateFileFormatInVitam(List<FileFormatModel> fileFormats, VitamContext vitamContext) {
        if (fileFormats != null && !fileFormats.isEmpty()) {
            try {
                ObjectNode select = new Select().getFinalSelect();
                RequestResponse<FileFormatModel> response = this.findFileFormats(vitamContext, (JsonNode)select);
                if (response.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
                    throw new PreconditionFailedException("Can't create file format for the tenant : UNAUTHORIZED");
                }
                if (response.getStatus() != HttpStatus.OK.value()) {
                    throw new UnavailableServiceException("Can't create file format for this tenant, Vitam response code : " + response.getStatus());
                }
                this.verifyFileFormatExistence(fileFormats, response);
            }
            catch (VitamClientException e) {
                throw new UnavailableServiceException("Can't create access contracts for this tenant, error while calling Vitam : " + e.getMessage());
            }
            return true;
        }
        throw new BadRequestException("The body is not found");
    }

    private void verifyFileFormatExistence(List<FileFormatModel> checkFileFormats, RequestResponse<FileFormatModel> vitamFileFormats) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            FileFormatResponseDto accessContractResponseDto = (FileFormatResponseDto)((Object)objectMapper.treeToValue((TreeNode)vitamFileFormats.toJsonNode(), FileFormatResponseDto.class));
            List formatsNames = checkFileFormats.stream().map(ac -> ac.getName()).collect(Collectors.toList());
            if (accessContractResponseDto.getResults().stream().anyMatch(ac -> formatsNames.contains(ac.getName()))) {
                throw new ConflictException("Can't create file format, a format with the same name already exist in Vitam");
            }
            List formatsPuids = checkFileFormats.stream().map(ac -> ac.getPuid()).collect(Collectors.toList());
            if (accessContractResponseDto.getResults().stream().anyMatch(ac -> formatsPuids.contains(ac.getPuid()))) {
                throw new ConflictException("Can't create file format, a format with the same puid already exist in Vitam");
            }
        }
        catch (JsonProcessingException e) {
            throw new UnexpectedDataException("Can't create access contracts, Error while parsing Vitam response : " + e.getMessage());
        }
    }
}

