/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.exception.UnavailableServiceException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyCommonService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.AgencyCSVDto;
import fr.gouv.vitamui.referential.common.dto.AgencyResponseDto;
import fr.gouv.vitamui.referential.common.utils.AgencyConverter;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;

public class VitamAgencyCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitamAgencyCommonService.class);
    private final AdminExternalClient adminExternalClient;
    private final AccessExternalClient accessExternalClient;
    private final AgencyCommonService agencyCommonService;
    private ObjectMapper objectMapper;

    public VitamAgencyCommonService(AdminExternalClient adminExternalClient, AgencyCommonService agencyCommonService, ObjectMapper objectMapper, AccessExternalClient accessExternalClient) {
        this.adminExternalClient = adminExternalClient;
        this.agencyCommonService = agencyCommonService;
        this.objectMapper = objectMapper;
        this.accessExternalClient = accessExternalClient;
    }

    private void patchFields(AgenciesModel agencyToPatch, AgenciesModel fieldsToApply) {
        VitamUIUtils.copyProperties((Object)fieldsToApply, (Object)agencyToPatch);
    }

    public Response export(VitamContext context) throws InvalidParseOperationException, InvalidCreateOperationException, VitamClientException {
        JsonNode query = VitamQueryHelper.getLastOperationQuery("IMPORT_AGENCIES.OK");
        RequestResponse lastImportOperationResponse = this.accessExternalClient.selectOperations(context, query);
        LogbookOperationsCommonResponseDto lastImportOperation = (LogbookOperationsCommonResponseDto)VitamRestUtils.responseMapping((JsonNode)lastImportOperationResponse.toJsonNode(), LogbookOperationsCommonResponseDto.class);
        if (lastImportOperation.getHits().getTotal() == 0) {
            throw new VitamClientException("Can't get a result while selecting lase agency import");
        }
        LOGGER.info("Export Agencies EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        return this.adminExternalClient.downloadAgenciesCsvAsStream(context, ((LogbookOperationDto)lastImportOperation.getResults().get(0)).getEvId());
    }

    public RequestResponse<?> importAgencies(VitamContext vitamContext, String fileName, MultipartFile file) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException {
        LOGGER.debug("Import agency file {}", (Object)fileName);
        return this.importAgencies(vitamContext, file.getInputStream(), fileName);
    }

    public RequestResponse<?> patchAgency(VitamContext vitamContext, String id, AgenciesModel patchAgency) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException {
        LOGGER.info("Patch Agency EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse requestResponse = this.agencyCommonService.findAgencies(vitamContext, (JsonNode)new Select().getFinalSelect());
        List actualAgencies = ((AgencyResponseDto)((Object)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class))).getResults();
        actualAgencies.stream().filter(agency -> id.equals(agency.getId())).forEach(agency -> this.patchFields((AgenciesModel)agency, patchAgency));
        return this.importAgencies(vitamContext, actualAgencies);
    }

    public boolean deleteAgency(VitamContext vitamContext, String id) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException {
        LOGGER.info("Delete Agency EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse requestResponse = this.agencyCommonService.findAgencies(vitamContext, (JsonNode)new Select().getFinalSelect());
        List actualAgencies = ((AgencyResponseDto)((Object)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class))).getResults();
        RequestResponse r = this.importAgencies(vitamContext, actualAgencies.stream().filter(agency -> !id.equals(agency.getId())).collect(Collectors.toList()));
        return r.isOk();
    }

    public RequestResponse<?> create(VitamContext vitamContext, AgenciesModel newAgency) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException {
        LOGGER.info("Create Agency EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse requestResponse = this.agencyCommonService.findAgencies(vitamContext, (JsonNode)new Select().getFinalSelect());
        List actualAgencies = ((AgencyResponseDto)((Object)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class))).getResults();
        actualAgencies.add(newAgency);
        return this.importAgencies(vitamContext, actualAgencies);
    }

    private RequestResponse importAgencies(VitamContext vitamContext, List<AgenciesModel> agencyModels) throws InvalidParseOperationException, AccessExternalClientException, IOException {
        LOGGER.info("Import Agencies EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        LOGGER.debug("Reimport agencyies {}", agencyModels);
        try (ByteArrayInputStream byteArrayInputStream = this.serializeAgencies(agencyModels);){
            RequestResponse<?> requestResponse = this.importAgencies(vitamContext, byteArrayInputStream, "Agencies.json");
            return requestResponse;
        }
    }

    private RequestResponse<?> importAgencies(VitamContext vitamContext, InputStream agencies, String fileName) throws InvalidParseOperationException, AccessExternalClientException {
        LOGGER.info("Import Agencies EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.createAgencies(vitamContext, agencies, fileName);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    private ByteArrayInputStream serializeAgencies(List<AgenciesModel> agenciesModels) throws IOException {
        List<AgencyCSVDto> listOfAgencies = AgencyConverter.convertDtosToCsvDtos(agenciesModels);
        LOGGER.debug("The json for creation agencies, sent to Vitam {}", listOfAgencies);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            CsvMapper csvMapper = (CsvMapper)((CsvMapper.Builder)CsvMapper.builder().disable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).build();
            CsvSchema schema = csvMapper.schemaFor(AgencyCSVDto.class).withColumnSeparator(',').withArrayElementSeparator("|").withHeader();
            ObjectWriter writer = csvMapper.writer((FormatSchema)schema);
            writer.writeValue((OutputStream)byteArrayOutputStream, listOfAgencies);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    public Integer checkAbilityToCreateAgencyInVitam(List<AgenciesModel> agencies, String applicationSessionId) {
        if (agencies == null || agencies.isEmpty()) {
            throw new BadRequestException("The body is not found");
        }
        Integer tenantIdentifier = agencies.stream().findFirst().map(AgenciesModel::getTenant).orElse(null);
        if (tenantIdentifier == null) {
            throw new BadRequestException("The tenant identifier must be present in the request body");
        }
        boolean sameTenant = agencies.stream().allMatch(ac -> tenantIdentifier.equals(ac.getTenant()));
        if (!sameTenant) {
            throw new BadRequestException("All the agencies contracts must have the same tenant identifier");
        }
        try {
            VitamContext vitamContext = new VitamContext(tenantIdentifier).setApplicationSessionId(applicationSessionId);
            ObjectNode select = new Select().getFinalSelect();
            RequestResponse response = this.agencyCommonService.findAgencies(vitamContext, (JsonNode)select);
            if (response.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
                throw new PreconditionFailedException("Can't create agencies for the tenant : " + tenantIdentifier + " not found in Vitam");
            }
            if (response.getStatus() != HttpStatus.OK.value()) {
                throw new UnavailableServiceException("Can't create agencies for this tenant, Vitam response code : " + response.getStatus());
            }
            this.verifyAgencyExistence(agencies, (RequestResponse<AgenciesModel>)response);
        }
        catch (VitamClientException e) {
            throw new UnavailableServiceException("Can't create agencies for this tenant, error while calling Vitam : " + e.getMessage());
        }
        return tenantIdentifier;
    }

    private void verifyAgencyExistence(List<AgenciesModel> agenciesModels, RequestResponse<AgenciesModel> response) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            AgencyResponseDto agencyResponseDto = (AgencyResponseDto)((Object)objectMapper.treeToValue((TreeNode)response.toJsonNode(), AgencyResponseDto.class));
            List<String> agenciesNames = agenciesModels.stream().map(AgenciesModel::getName).toList();
            boolean alreadyCreated = agencyResponseDto.getResults().stream().anyMatch(ac -> agenciesNames.contains(ac.getName()));
            if (alreadyCreated) {
                throw new ConflictException("Can't create agency, a contract with the same name already exist in Vitam");
            }
            List<String> agenciesIdentifiers = agenciesModels.stream().map(AgenciesModel::getIdentifier).toList();
            alreadyCreated = agencyResponseDto.getResults().stream().anyMatch(ac -> agenciesIdentifiers.contains(ac.getIdentifier()));
            if (alreadyCreated) {
                throw new ConflictException("Can't create agency, a contract with the same id already exist in Vitam");
            }
        }
        catch (JsonProcessingException e) {
            throw new UnexpectedDataException("Can't create agency, Error while parsing Vitam response : " + e.getMessage());
        }
    }
}

