/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AbstractContractModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.exception.UnavailableServiceException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.referential.common.dto.IngestContractResponseDto;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class IngestContractCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IngestContractCommonService.class);
    private final AdminExternalClient adminExternalClient;

    public IngestContractCommonService(AdminExternalClient adminExternalClient) {
        this.adminExternalClient = adminExternalClient;
    }

    public RequestResponse patchIngestContract(VitamContext vitamContext, String id, ObjectNode jsonNode) throws InvalidParseOperationException, AccessExternalClientException {
        LOGGER.debug("patch: {}, {}", (Object)id, (Object)jsonNode);
        LOGGER.info("Patch Ingest Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        return this.adminExternalClient.updateIngestContract(vitamContext, id, (JsonNode)jsonNode);
    }

    public RequestResponse<IngestContractModel> findIngestContractById(VitamContext vitamContext, String contractId) throws VitamClientException {
        RequestResponse jsonResponse = this.adminExternalClient.findIngestContractById(vitamContext, contractId);
        VitamRestUtils.checkResponse((RequestResponse)jsonResponse, (Integer[])new Integer[0]);
        return jsonResponse;
    }

    public RequestResponse<IngestContractModel> findIngestContracts(VitamContext vitamContext, JsonNode query) throws VitamClientException {
        RequestResponse jsonResponse = this.adminExternalClient.findIngestContracts(vitamContext, query);
        VitamRestUtils.checkResponse((RequestResponse)jsonResponse, (Integer[])new Integer[0]);
        return jsonResponse;
    }

    private List<IngestContractModel> convertIngestContractsToModelOfCreation(List<IngestContractModel> ingestContractModels) {
        ArrayList<IngestContractModel> listOfAC = new ArrayList<IngestContractModel>();
        for (IngestContractModel acModel : ingestContractModels) {
            IngestContractModel ac = new IngestContractModel();
            acModel.setTenant(null);
            LOGGER.debug("inputIC: {}", (Object)acModel);
            LOGGER.debug("input checkParentID: {}", (Object)acModel.getCheckParentId());
            VitamUIUtils.copyProperties((Object)acModel, (Object)ac);
            ac.setMasterMandatory(acModel.isMasterMandatory());
            ac.setFormatUnidentifiedAuthorized(acModel.isFormatUnidentifiedAuthorized());
            ac.setEveryFormatType(acModel.isEveryFormatType());
            ac.setEveryDataObjectVersion(acModel.isEveryDataObjectVersion());
            ac.setComputeInheritedRulesAtIngest(acModel.isComputeInheritedRulesAtIngest());
            if (acModel.getActivationdate() != null) {
                ac.setActivationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)acModel.getActivationdate()));
            }
            if (acModel.getDeactivationdate() != null) {
                ac.setDeactivationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)acModel.getDeactivationdate()));
            }
            LOGGER.debug("outputIC: {}", (Object)ac);
            LOGGER.debug("output checkParentID: {}", (Object)ac.getCheckParentId());
            listOfAC.add(ac);
        }
        return listOfAC;
    }

    private ByteArrayInputStream serializeIngestContracts(List<IngestContractModel> ingestContractModels) throws IOException {
        List<IngestContractModel> listOfAC = this.convertIngestContractsToModelOfCreation(ingestContractModels);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = (JsonNode)mapper.convertValue(listOfAC, JsonNode.class);
        LOGGER.debug("The json for creation ingest contract, sent to Vitam {}", (Object)node);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            mapper.writeValue((OutputStream)byteArrayOutputStream, (Object)node);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    public RequestResponse<?> createIngestContracts(VitamContext vitamContext, List<IngestContractModel> ingestContracts) throws InvalidParseOperationException, AccessExternalClientException, IOException {
        try (ByteArrayInputStream byteArrayInputStream = this.serializeIngestContracts(ingestContracts);){
            LOGGER.info("Create Ingest Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse jsonResponse = this.adminExternalClient.createIngestContracts(vitamContext, (InputStream)byteArrayInputStream);
            VitamRestUtils.checkResponse((RequestResponse)jsonResponse, (Integer[])new Integer[0]);
            RequestResponse requestResponse = jsonResponse;
            return requestResponse;
        }
    }

    public Integer checkAbilityToCreateIngestContractInVitam(List<IngestContractModel> ingestContracts, String applicationSessionId) {
        if (ingestContracts != null && !ingestContracts.isEmpty()) {
            Integer tenantIdentifier;
            Optional ingestContract = ingestContracts.stream().findFirst();
            Integer n = tenantIdentifier = ingestContract.isPresent() ? ((IngestContractModel)ingestContract.get()).getTenant() : null;
            if (tenantIdentifier != null) {
                boolean sameTenant = ingestContracts.stream().allMatch(ac -> tenantIdentifier.equals(ac.getTenant()));
                if (!sameTenant) {
                    String msg = "All the ingest contracts must have the same tenant identifier";
                    LOGGER.error("All the ingest contracts must have the same tenant identifier");
                    throw new BadRequestException("All the ingest contracts must have the same tenant identifier");
                }
            } else {
                String msg = "The tenant identifier must be present in the request body";
                LOGGER.error("The tenant identifier must be present in the request body");
                throw new BadRequestException("The tenant identifier must be present in the request body");
            }
            try {
                VitamContext vitamContext = new VitamContext(tenantIdentifier).setApplicationSessionId(applicationSessionId);
                ObjectNode select = new Select().getFinalSelect();
                RequestResponse<IngestContractModel> response = this.findIngestContracts(vitamContext, (JsonNode)select);
                if (response.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
                    String msg = "Can't create ingest contracts for the tenant : " + tenantIdentifier + " not found in Vitam";
                    LOGGER.error(msg);
                    throw new PreconditionFailedException(msg);
                }
                if (response.getStatus() != HttpStatus.OK.value()) {
                    String msg = "Can't create ingest contracts for this tenant, Vitam response code : " + response.getStatus();
                    LOGGER.error(msg);
                    throw new UnavailableServiceException(msg);
                }
                this.verifyIngestContractExistence(ingestContracts, response);
            }
            catch (VitamClientException e) {
                String msg = "Can't create ingest contracts for this tenant, error while calling Vitam : " + e.getMessage();
                LOGGER.error(msg);
                throw new UnavailableServiceException(msg);
            }
            return tenantIdentifier;
        }
        String msg = "The body is not found";
        LOGGER.error("The body is not found");
        throw new BadRequestException("The body is not found");
    }

    private void verifyIngestContractExistence(List<IngestContractModel> ingestContracts, RequestResponse<IngestContractModel> response) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            IngestContractResponseDto ingestContractResponseDto = (IngestContractResponseDto)((Object)objectMapper.treeToValue((TreeNode)response.toJsonNode(), IngestContractResponseDto.class));
            List ingestContractsNames = ingestContracts.stream().map(AbstractContractModel::getName).filter(Objects::nonNull).map(String::strip).collect(Collectors.toList());
            boolean alreadyCreated = ingestContractResponseDto.getResults().stream().anyMatch(ac -> ingestContractsNames.contains(ac.getName()));
            if (alreadyCreated) {
                String msg = "Can't create ingest contract, a contract with the same name already exist in Vitam";
                LOGGER.error("Can't create ingest contract, a contract with the same name already exist in Vitam");
                throw new ConflictException("Can't create ingest contract, a contract with the same name already exist in Vitam");
            }
            List ingestContractsIdentifiers = ingestContracts.stream().map(AbstractContractModel::getIdentifier).filter(Objects::nonNull).map(String::strip).collect(Collectors.toList());
            alreadyCreated = ingestContractResponseDto.getResults().stream().anyMatch(ac -> ingestContractsIdentifiers.contains(ac.getIdentifier()));
            if (alreadyCreated) {
                String msg = "Can't create ingest contract, a contract with the same identifier already exist in Vitam";
                LOGGER.error("Can't create ingest contract, a contract with the same identifier already exist in Vitam");
                throw new ConflictException("Can't create ingest contract, a contract with the same identifier already exist in Vitam");
            }
        }
        catch (JsonProcessingException e) {
            String msg = "Can't create ingest contracts, Error while parsing Vitam response : " + e.getMessage();
            LOGGER.error(msg);
            throw new UnexpectedDataException(msg);
        }
    }
}

