/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.schema.SchemaInputModel;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImportSchemaCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportSchemaCommonService.class);
    private final AdminExternalClient adminExternalClient;

    public ImportSchemaCommonService(AdminExternalClient adminExternalClient) {
        this.adminExternalClient = adminExternalClient;
    }

    public RequestResponse<Void> importUnitSchema(VitamContext vitamContext, List<SchemaInputModel> importSchema) throws InvalidParseOperationException, AccessExternalClientException, IOException {
        try (ByteArrayInputStream byteArrayInputStream = this.serializeImportSchema(importSchema);){
            LOGGER.info("Import Unit Schema : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse jsonResponse = this.adminExternalClient.importUnitExternalSchema(vitamContext, (InputStream)byteArrayInputStream);
            VitamRestUtils.checkResponse((RequestResponse)jsonResponse, (Integer[])new Integer[0]);
            RequestResponse requestResponse = jsonResponse;
            return requestResponse;
        }
    }

    ByteArrayInputStream serializeImportSchema(List<SchemaInputModel> schemaInputModel) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode node = (JsonNode)objectMapper.convertValue(schemaInputModel, JsonNode.class);
        LOGGER.debug("The json for import schema, sent to Vitam {}", (Object)node);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            objectMapper.writeValue((OutputStream)byteArrayOutputStream, (Object)node);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }
}

