/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.model;

import java.util.Arrays;
import java.util.Objects;

public enum EffectiveCardinality {
    ZERO("0"),
    ONE("0-1"),
    MANY("0-N"),
    ONE_REQUIRED("1-1"),
    MANY_REQUIRED("1-N");

    private final String cardinality;

    private EffectiveCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    public String getValue() {
        return this.cardinality;
    }

    public boolean isMandatory() {
        return this.cardinality.contains("1");
    }

    public boolean isMultiple() {
        return this.cardinality.contains("N");
    }

    public static EffectiveCardinality of(String cardinality) {
        return Arrays.stream(EffectiveCardinality.values()).filter(c -> Objects.equals(c.getValue(), cardinality)).findFirst().orElseThrow();
    }
}

