/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.gateway.filters;

import fr.gouv.vitamui.commons.api.exception.UnAuthorizedException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Order(value=1)
@Component
public class ApiGatewaySecurityFilter
implements GlobalFilter {
    @Value(value="${authn.client-certificate-header-name}")
    private String clientCertificateHeaderName;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest req = exchange.getRequest();
        String encodedCert = ApiGatewaySecurityFilter.extractCertificate((ServerHttpRequest)req);
        ServerHttpRequest request = exchange.getRequest().mutate().headers(httpHeaders -> {
            httpHeaders.set("X-Origin", "EXTERNAL");
            httpHeaders.set(this.clientCertificateHeaderName, encodedCert);
        }).build();
        return chain.filter(exchange.mutate().request(request).build());
    }

    private static String extractCertificate(ServerHttpRequest req) {
        X509Certificate[] certs;
        SslInfo sslInfo = req.getSslInfo();
        if (sslInfo != null && (certs = sslInfo.getPeerCertificates()) != null && certs.length > 0) {
            X509Certificate certificate = certs[0];
            try {
                certificate.checkValidity();
                return new String(Base64.encodeBase64((byte[])certificate.getEncoded()));
            }
            catch (CertificateEncodingException | CertificateExpiredException | CertificateNotYetValidException e) {
                throw new UnAuthorizedException("Certificate is invalid " + String.valueOf(certificate), (Throwable)e);
            }
        }
        throw new UnAuthorizedException("No certificate found");
    }
}

