/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.gateway.config;

import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.stereotype.Component;
import reactor.netty.http.server.HttpRequestDecoderSpec;

@Component
public class NettyServerCustomizer
implements WebServerFactoryCustomizer<NettyReactiveWebServerFactory> {
    private final int maxHttpHeaderSize;

    public NettyServerCustomizer(ServerProperties serverProperties) {
        this.maxHttpHeaderSize = Math.toIntExact(serverProperties.getMaxHttpRequestHeaderSize().toBytes());
    }

    public void customize(NettyReactiveWebServerFactory factory) {
        factory.addServerCustomizers(new org.springframework.boot.web.embedded.netty.NettyServerCustomizer[]{server -> server.httpRequestDecoder(reqDecorator -> (HttpRequestDecoderSpec)((HttpRequestDecoderSpec)reqDecorator.maxInitialLineLength(this.maxHttpHeaderSize)).maxHeaderSize(this.maxHttpHeaderSize))});
    }
}

