/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.service;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitamui.iam.openapiclient.ExternalParametersApi;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExternalParametersService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalParametersService.class);
    public static final String PARAM_BULK_OPERATIONS_THRESHOLD_NAME = "PARAM_BULK_OPERATIONS_THRESHOLD";
    public static final String PARAM_ACCESS_CONTRACT_NAME = "PARAM_ACCESS_CONTRACT";
    private final ExternalParametersApi externalParametersApi;
    private final SecurityService securityService;

    public ExternalParametersService(ExternalParametersApi externalParametersApi, SecurityService securityService) {
        this.externalParametersApi = externalParametersApi;
        this.securityService = securityService;
    }

    public String retrieveAccessContractFromExternalParam() {
        Map myExternalParameter = this.externalParametersApi.getMyExternalParameters();
        if (myExternalParameter == null || CollectionUtils.isEmpty(myExternalParameter.entrySet())) {
            throw new IllegalArgumentException("No external profile defined for access contract defined");
        }
        Map.Entry parameterAccessContract = myExternalParameter.entrySet().stream().filter(entry -> PARAM_ACCESS_CONTRACT_NAME.equals(entry.getKey())).findFirst().orElse(null);
        if (Objects.isNull(parameterAccessContract) || Objects.isNull(parameterAccessContract.getValue())) {
            throw new IllegalArgumentException("No access contract defined");
        }
        return (String)parameterAccessContract.getValue();
    }

    public VitamContext buildVitamContextFromExternalParam() {
        return new VitamContext(this.securityService.getTenantIdentifier()).setAccessContract(this.retrieveAccessContractFromExternalParam()).setApplicationSessionId(this.securityService.getApplicationId());
    }

    public Optional<Long> retrieveProfilThreshold() {
        Map.Entry parameterThreshold;
        Optional<Long> thresholdOpt = Optional.empty();
        Map myExternalParameter = this.externalParametersApi.getMyExternalParameters();
        if (CollectionUtils.isNotEmpty(myExternalParameter.entrySet()) && (parameterThreshold = (Map.Entry)myExternalParameter.entrySet().stream().filter(entry -> PARAM_BULK_OPERATIONS_THRESHOLD_NAME.equals(entry.getKey())).findFirst().orElse(null)) != null && parameterThreshold.getValue() != null) {
            try {
                Long thresholdValue = Long.valueOf((String)parameterThreshold.getValue());
                thresholdOpt = Optional.of(thresholdValue);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("external parameter of bulk threshold contains wrong integer value {}, it will not be used ", parameterThreshold.getValue());
                throw new IllegalArgumentException("external parameter of bulk threshold contains wrong integer value " + (String)parameterThreshold.getValue() + ", it will not be used ");
            }
        }
        return thresholdOpt;
    }
}

