/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.securityprofile;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.api.AdminCollections;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.VitamUIException;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.SecurityProfileDto;
import fr.gouv.vitamui.referential.common.dto.SecurityProfileResponseDto;
import fr.gouv.vitamui.referential.common.service.VitamSecurityProfileCommonService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import fr.gouv.vitamui.referential.server.service.securityprofile.SecurityProfileConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SecurityProfileService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityProfileService.class);
    private VitamSecurityProfileCommonService vitamSecurityProfileCommonService;
    private ObjectMapper objectMapper;
    private SecurityProfileConverter converter;
    private LogbookService logbookService;

    public SecurityProfileService(VitamSecurityProfileCommonService vitamSecurityProfileCommonService, ObjectMapper objectMapper, SecurityProfileConverter converter, LogbookService logbookService, SecurityService securityService) {
        super(securityService);
        this.vitamSecurityProfileCommonService = vitamSecurityProfileCommonService;
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.logbookService = logbookService;
    }

    public SecurityProfileDto getOne(VitamContext vitamSecurityProfile, String identifier) {
        try {
            LOGGER.info("Security Profile EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamSecurityProfileCommonService.findSecurityProfileById(vitamSecurityProfile, identifier);
            SecurityProfileResponseDto securityProfileResponseDto = (SecurityProfileResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), SecurityProfileResponseDto.class);
            if (securityProfileResponseDto.getResults().size() == 0) {
                return null;
            }
            return this.converter.convertVitamToDto((SecurityProfileModel)securityProfileResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Security Profile", e);
        }
    }

    public List<SecurityProfileDto> getAll(VitamContext vitamSecurityProfile) {
        try {
            LOGGER.info("All Security Profiles EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamSecurityProfileCommonService.findSecurityProfiles(vitamSecurityProfile, (JsonNode)new Select().getFinalSelect());
            SecurityProfileResponseDto securityProfileResponseDto = (SecurityProfileResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), SecurityProfileResponseDto.class);
            return this.converter.convertVitamsToDtos(securityProfileResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Security Profiles", e);
        }
    }

    public PaginatedValuesDto<SecurityProfileDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamSecurityProfile, Optional<String> criteria) {
        Map vitamCriteria = new HashMap();
        JsonNode query = null;
        LOGGER.info("All Security Profiles EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Can't create dsl query to get paginated security profiles", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        SecurityProfileResponseDto results = this.findAll(vitamSecurityProfile, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<SecurityProfileDto> valuesDto = this.converter.convertVitamsToDtos(results.getResults());
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    public SecurityProfileResponseDto findAll(VitamContext vitamSecurityProfile, JsonNode query) {
        try {
            LOGGER.info("All Security Profiles EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamSecurityProfileCommonService.findSecurityProfiles(vitamSecurityProfile, query);
            return (SecurityProfileResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), SecurityProfileResponseDto.class);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Can't find security profiles", e);
        }
    }

    public Boolean check(VitamContext vitamSecurityProfile, SecurityProfileDto securityProfileDto) {
        ArrayList<SecurityProfileDto> securityProfileDtoList = new ArrayList<SecurityProfileDto>();
        securityProfileDtoList.add(securityProfileDto);
        LOGGER.info("Security Profile Check EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
        try {
            return !this.vitamSecurityProfileCommonService.checkAbilityToCreateSecurityProfileInVitam(this.converter.convertDtosToVitams(securityProfileDtoList), vitamSecurityProfile);
        }
        catch (ConflictException e) {
            return true;
        }
        catch (VitamUIException e) {
            throw new InternalServerException("Unable to check security profiles", (Throwable)e);
        }
    }

    public SecurityProfileDto create(VitamContext vitamSecurityProfile, SecurityProfileDto securityProfileDto) {
        try {
            LOGGER.info("Create Security Profiles EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamSecurityProfileCommonService.createSecurityProfile(vitamSecurityProfile, this.converter.convertDtoToVitam(securityProfileDto));
            SecurityProfileModel securityProfileVitamDto = (SecurityProfileModel)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), SecurityProfileModel.class);
            return this.converter.convertVitamToDto(securityProfileVitamDto);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            throw new InternalServerException("Can't create security profile", e);
        }
    }

    private JsonNode convertMapPartialDtoToUpperCaseVitamFields(Map<String, Object> partialDto) {
        ObjectNode propertiesToUpdate = JsonHandler.createObjectNode();
        if (partialDto.get("fullAccess") != null) {
            propertiesToUpdate.put("FullAccess", ((Boolean)partialDto.get("fullAccess")).booleanValue());
        }
        if (partialDto.get("permissions") != null) {
            ArrayNode array = JsonHandler.createArrayNode();
            for (String perm : (List)partialDto.get("permissions")) {
                array.add(perm);
            }
            propertiesToUpdate.set("Permissions", (JsonNode)array);
        }
        return propertiesToUpdate;
    }

    public SecurityProfileDto patch(VitamContext vitamSecurityProfile, Map<String, Object> partialDto) {
        String id = (String)partialDto.get("identifier");
        if (id == null) {
            throw new BadRequestException("id must be one the the update criteria");
        }
        LOGGER.info("Patch Security Profiles EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
        JsonNode fieldsUpdated = this.convertMapPartialDtoToUpperCaseVitamFields(partialDto);
        ObjectNode action = JsonHandler.createObjectNode();
        action.set("$set", fieldsUpdated);
        ArrayNode actions = JsonHandler.createArrayNode();
        actions.add((JsonNode)action);
        ObjectNode query = JsonHandler.createObjectNode();
        query.set("$action", (JsonNode)actions);
        try {
            RequestResponse requestResponse = this.vitamSecurityProfileCommonService.patchSecurityProfile(vitamSecurityProfile, id, (JsonNode)query);
            SecurityProfileModel securityProfileVitamDto = (SecurityProfileModel)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), SecurityProfileModel.class);
            return this.converter.convertVitamToDto(securityProfileVitamDto);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Can't patch security profile", e);
        }
    }

    public boolean delete(VitamContext context, String id) {
        try {
            LOGGER.info("Delete Security Profile EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamSecurityProfileCommonService.deleteSecurityProfile(context, id);
            return requestResponse.isOk();
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            throw new InternalServerException("Unable to delete agency", e);
        }
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamSecurityProfile, String identifier) throws VitamClientException {
        LOGGER.debug("findHistoryById for identifier" + identifier);
        LOGGER.info(" Security Profile History EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
        return this.logbookService.findEventsByIdentifierAndCollectionNames(identifier, AdminCollections.ACCESS_CONTRACTS.getName(), vitamSecurityProfile).toJsonNode();
    }

    public SecurityProfileDto getOne(String id) {
        LOGGER.debug("Fetching Security Profile for ID: {}", (Object)id);
        VitamContext vitamContext = this.buildVitamContext();
        return this.getOne(vitamContext, id);
    }

    public List<SecurityProfileDto> getAll(Optional<String> criteria) {
        LOGGER.debug("Fetching all Security Profiles with criteria: {}", criteria);
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAll(vitamContext);
    }

    public PaginatedValuesDto<SecurityProfileDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        LOGGER.debug("Fetching paginated Security Profiles");
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    public SecurityProfileDto create(SecurityProfileDto securityProfileDto) {
        LOGGER.debug("Creating Security Profile: {}", (Object)securityProfileDto);
        VitamContext vitamContext = this.buildVitamContext();
        return this.create(vitamContext, securityProfileDto);
    }

    public SecurityProfileDto patch(Map<String, Object> securityProfileDto) {
        LOGGER.debug("Patching Security Profile: {}", securityProfileDto);
        VitamContext vitamContext = this.buildVitamContext();
        return this.patch(vitamContext, securityProfileDto);
    }

    public boolean check(SecurityProfileDto securityProfileDto) {
        LOGGER.debug("Checking Security Profile existence: {}", (Object)securityProfileDto);
        VitamContext vitamContext = this.buildVitamContext();
        return this.check(vitamContext, securityProfileDto);
    }

    public boolean delete(String id) {
        LOGGER.debug("Deleting Security Profile for ID: {}", (Object)id);
        VitamContext vitamContext = this.buildVitamContext();
        return this.delete(vitamContext, id);
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws VitamClientException {
        VitamContext vitamContext = this.buildVitamContext();
        JsonNode history = this.findHistoryByIdentifier(vitamContext, id);
        try {
            return (LogbookOperationsCommonResponseDto)this.objectMapper.treeToValue((TreeNode)history, LogbookOperationsCommonResponseDto.class);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error parsing history data", (Throwable)e);
        }
    }
}

