/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.schema;

import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitamui.commons.api.dtos.ErrorImportFile;
import fr.gouv.vitamui.commons.api.enums.ErrorImportFileMessage;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.iam.openapiclient.ApplicationsApi;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dto.ImportSchemaDto;
import fr.gouv.vitamui.referential.common.dto.SchemaDto;
import fr.gouv.vitamui.referential.common.model.Collection;
import fr.gouv.vitamui.referential.common.service.ImportSchemaCommonService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import fr.gouv.vitamui.referential.server.service.schema.CombinedSchemaModelToSchemaElementDtoConverter;
import fr.gouv.vitamui.referential.server.service.schema.ImportSchemaCSVUtils;
import fr.gouv.vitamui.referential.server.service.schema.ImportSchemaConverter;
import fr.gouv.vitamui.referential.server.service.schema.SchemaLoadingException;
import fr.gouv.vitamui.referential.server.service.schema.SchemaModelToSchemaElementDtoConverter;
import fr.gouv.vitamui.referential.server.service.utils.ImportCSVUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SchemaService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaService.class);
    private static final String IMPORT_UNIT_SCHEMA = "IMPORT_UNIT_SCHEMA";
    private final ImportSchemaCommonService importSchemaCommonService;
    private final ImportSchemaConverter converter;
    private final ApplicationsApi applicationsApi;
    private final AdminExternalClient adminExternalClient;

    public SchemaService(AdminExternalClient adminExternalClient, SecurityService securityService, ImportSchemaCommonService importSchemaCommonService, ImportSchemaConverter converter, ApplicationsApi applicationsApi) {
        super(securityService);
        this.adminExternalClient = adminExternalClient;
        this.importSchemaCommonService = importSchemaCommonService;
        this.converter = converter;
        this.applicationsApi = applicationsApi;
    }

    public Optional<SchemaDto> getSchema(Collection collection) {
        try {
            RequestResponse<SchemaResponse> payload = this.getSchemaModels(collection).orElseThrow();
            List schemaModels = ((RequestResponseOK)payload).getResults();
            SchemaModelToSchemaElementDtoConverter converter = new SchemaModelToSchemaElementDtoConverter();
            SchemaDto schemaDto = new SchemaDto();
            schemaDto.addAll(schemaModels.stream().map(converter::convert).toList());
            return Optional.of(schemaDto);
        }
        catch (VitamClientException e) {
            throw new SchemaLoadingException(e);
        }
    }

    public List<SchemaDto> getSchemas(Set<Collection> collections) {
        return collections.stream().map(this::getSchema).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public String deleteSchemas(List<String> paths) throws AccessExternalClientException, InvalidParseOperationException {
        RequestResponse requestResponse = this.adminExternalClient.deleteUnitExternalSchemas(this.buildVitamContext(), paths);
        return requestResponse.getHeaderString("X-Request-Id");
    }

    public SchemaDto getArchiveUnitProfileSchema(String archiveUnitProfileId) throws VitamClientException {
        VitamContext vitamContext = this.buildVitamContext();
        RequestResponse payload = this.adminExternalClient.getArchiveUnitProfileSchema(vitamContext, archiveUnitProfileId);
        List schemaModels = ((RequestResponseOK)payload).getResults();
        CombinedSchemaModelToSchemaElementDtoConverter converter = new CombinedSchemaModelToSchemaElementDtoConverter();
        SchemaDto schemaDto = new SchemaDto();
        schemaDto.addAll(schemaModels.stream().map(converter::convert).toList());
        return schemaDto;
    }

    private Optional<RequestResponse<SchemaResponse>> getSchemaModels(Collection collection) throws VitamClientException {
        VitamContext vitamContext = this.buildVitamContext();
        if (Objects.equals(collection, Collection.ARCHIVE_UNIT)) {
            return Optional.of(this.adminExternalClient.getUnitSchema(vitamContext));
        }
        if (Objects.equals(collection, Collection.OBJECT_GROUP)) {
            return Optional.of(this.adminExternalClient.getObjectGroupSchema(vitamContext));
        }
        return Optional.empty();
    }

    public ResponseEntity<Void> importUnitSchema(MultipartFile file) {
        RequestResponse result;
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (file.getOriginalFilename() == null) {
            throw new IllegalArgumentException("Filename cannot be null");
        }
        Boolean isIdentifierMandatory = this.applicationsApi.isApplicationExternalIdentifierEnabled(IMPORT_UNIT_SCHEMA);
        if (isIdentifierMandatory == null) {
            throw new InternalServerException("The result of the API call should not be null");
        }
        ImportSchemaCSVUtils.checkImportFile(file);
        LOGGER.debug("Schema file {} has been validated before parsing it", (Object)file.getOriginalFilename());
        List<ImportSchemaDto> importSchemaDtos = this.convertCsvFileToImportDto(file);
        LOGGER.debug("Schema file {} has been parsed in schema List", (Object)file.getOriginalFilename());
        VitamContext vitamContext = this.buildVitamContext();
        try {
            result = this.importSchemaCommonService.importUnitSchema(vitamContext, this.converter.convertDtosToVitams(importSchemaDtos));
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Can't create schema", e);
        }
        if (HttpStatus.OK.value() == result.getHttpCode()) {
            LOGGER.debug("Schemas file {} has been successfully import to VITAM", (Object)file.getOriginalFilename());
            return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
        }
        throw new BadRequestException("The CSV file has been rejected by vitam", null, List.of(ImportCSVUtils.errorToJson(ErrorImportFile.builder().error(ErrorImportFileMessage.REJECT_BY_VITAM_CHECK_LOGBOOK_OPERATION_APP).build())));
    }

    private List<ImportSchemaDto> convertCsvFileToImportDto(MultipartFile file) {
        List list;
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(file.getInputStream()), StandardCharsets.UTF_8);
        try {
            CsvToBean csvToBean = new CsvToBeanBuilder((Reader)reader).withType(ImportSchemaDto.class).withIgnoreLeadingWhiteSpace(true).withFieldAsNull(CSVReaderNullFieldIndicator.BOTH).withSeparator(';').build();
            list = csvToBean.parse();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException e) {
                throw new BadRequestException("Unable to read schema CSV file ", (Throwable)e);
            }
        }
        ((Reader)reader).close();
        return list;
    }
}

