/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.rule;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.FileRulesModel;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.VitamUIException;
import fr.gouv.vitamui.commons.rest.dto.RuleDto;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.config.converter.RuleConverter;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.RuleNodeResponseDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.service.VitamRuleCommonService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RuleService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleService.class);
    private ObjectMapper objectMapper;
    private RuleConverter converter;
    private LogbookService logbookService;
    private VitamRuleCommonService ruleService;

    public RuleService(ObjectMapper objectMapper, RuleConverter converter, LogbookService logbookService, VitamRuleCommonService ruleService, SecurityService securityService) {
        super(securityService);
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.logbookService = logbookService;
        this.ruleService = ruleService;
    }

    public RuleDto getOne(VitamContext vitamContext, String identifier) {
        try {
            RequestResponse requestResponse = this.ruleService.findRuleById(vitamContext, identifier);
            RuleNodeResponseDto ruleResponseDto = (RuleNodeResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), RuleNodeResponseDto.class);
            if (ruleResponseDto.getResults().isEmpty()) {
                return null;
            }
            return this.converter.convertVitamToDto((FileRulesModel)ruleResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException exception) {
            LOGGER.error("Unable to get rule", exception);
            throw new InternalServerException("Unable to get rule", exception);
        }
    }

    public List<RuleDto> getAll(VitamContext vitamContext) {
        LOGGER.debug("Get ALL Rules !");
        try {
            RequestResponse requestResponse = this.ruleService.findRules(vitamContext, (JsonNode)new Select().getFinalSelect());
            LOGGER.debug("Response: {}", (Object)requestResponse);
            RuleNodeResponseDto ruleResponseDto = (RuleNodeResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), RuleNodeResponseDto.class);
            return this.converter.convertVitamsToDtos(ruleResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException exception) {
            LOGGER.error("Unable to find management rules", exception);
            throw new InternalServerException("Unable to find management rules", exception);
        }
    }

    public PaginatedValuesDto<RuleDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        Map vitamCriteria = new HashMap();
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            LOGGER.error("Unable to find management rules with pagination", ioe);
            throw new InternalServerException("Unable to find management rules with pagination", ioe);
        }
        catch (IOException e) {
            LOGGER.error("Can't parse criteria as Vitam query", (Throwable)e);
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        RuleNodeResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List valuesDto = this.converter.convertVitamsToDtos(results.getResults());
        LOGGER.debug("Formats in page: {}", (Object)valuesDto);
        return new PaginatedValuesDto((Collection)valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    private RuleNodeResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            RequestResponse requestResponse = this.ruleService.findRules(vitamContext, query);
            RuleNodeResponseDto ruleResponseDto = (RuleNodeResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), RuleNodeResponseDto.class);
            LOGGER.debug("Formats: {}", (Object)ruleResponseDto);
            return ruleResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            LOGGER.error("Unable to find rules", e);
            throw new InternalServerException("Unable to find rules", e);
        }
    }

    public Boolean check(VitamContext vitamContext, RuleDto ruleDto) {
        try {
            return this.ruleService.checkExistenceOfRuleInVitam(ruleDto, vitamContext);
        }
        catch (ConflictException e) {
            return false;
        }
        catch (VitamUIException exception) {
            LOGGER.error("Unable to check rule", (Throwable)exception);
            throw new InternalServerException("Unable to check rule", (Throwable)exception);
        }
    }

    public Boolean create(VitamContext vitamContext, RuleDto ruleDto) {
        LOGGER.debug("Try to create Rule {} {}", (Object)ruleDto, (Object)vitamContext);
        try {
            return this.ruleService.createRule(vitamContext, this.converter.convertDtoToVitam(ruleDto));
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | JAXBException | IOException e) {
            LOGGER.error("Unable to create rule", e);
            throw new InternalServerException("Unable to create rule", e);
        }
    }

    public Boolean patch(VitamContext vitamContext, Map<String, Object> partialDto) {
        LOGGER.debug("Try to patch rule {} {}", partialDto, (Object)vitamContext);
        String ruleId = (String)partialDto.get("id");
        RuleDto rule = this.getOne(vitamContext, ruleId);
        LOGGER.debug("Before update rule Dto : {}", (Object)rule);
        partialDto.forEach((key, value) -> {
            if (!"id".equals(key)) {
                try {
                    BeanUtilsBean.getInstance().copyProperty((Object)rule, key, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        });
        LOGGER.debug("Updated rule Dto {} : ", (Object)rule);
        FileRulesModel ruleVitam = this.converter.convertDtoToVitam(rule);
        LOGGER.debug("Converted rule Vitam DTO : {}", (Object)ruleVitam);
        try {
            return this.ruleService.patchRule(vitamContext, ruleId, ruleVitam);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | JAXBException | IOException exception) {
            LOGGER.error("Unable to patch rule", exception);
            throw new InternalServerException("Unable to patch rule", exception);
        }
    }

    public Boolean delete(VitamContext context, String ruleId) {
        LOGGER.debug("Try to delete rule {} {}", (Object)ruleId, (Object)context);
        try {
            return this.ruleService.deleteRule(context, ruleId);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | JAXBException | IOException exception) {
            LOGGER.error("Unable to delete rule", exception);
            throw new InternalServerException("Unable to delete rule", exception);
        }
    }

    public Response export(VitamContext context) {
        try {
            return this.ruleService.export(context);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | VitamClientException e) {
            LOGGER.error("Unable to export rules", e);
            throw new InternalServerException("Unable to export rules", e);
        }
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String identifier) throws VitamClientException {
        try {
            return this.logbookService.selectOperations(VitamQueryHelper.buildOperationQuery((String)identifier), vitamContext).toJsonNode();
        }
        catch (InvalidCreateOperationException exception) {
            LOGGER.error("Unable to fetch history", (Throwable)exception);
            throw new InternalServerException("Unable to fetch history", (Throwable)exception);
        }
    }

    public JsonNode importRules(String fileName, MultipartFile file) {
        VitamContext vitamContext = this.buildVitamContext();
        try {
            return this.ruleService.importRules(vitamContext, fileName, file).toJsonNode();
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException exception) {
            LOGGER.error("Unable to import rule file " + fileName + " : ", exception);
            throw new InternalServerException("Unable to import rule file " + fileName + " : ", exception);
        }
    }

    public RuleDto getOne(String identifier) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getOne(vitamContext, identifier);
    }

    public Collection<RuleDto> getAll() {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAll(vitamContext);
    }

    public PaginatedValuesDto<RuleDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAllPaginated(pageNumber, size, orderBy, direction, vitamContext, criteria);
    }

    public Boolean createRule(RuleDto ruleDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.create(vitamContext, ruleDto);
    }

    public Boolean patchRule(Map<String, Object> partialDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.patch(vitamContext, partialDto);
    }

    public Boolean deleteRule(String ruleId) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.delete(vitamContext, ruleId);
    }

    public Boolean check(RuleDto ruleDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.check(vitamContext, ruleDto);
    }

    public ResponseEntity<Resource> export() {
        VitamContext vitamContext = this.buildVitamContext();
        Response response = this.export(vitamContext);
        Object entity = response.getEntity();
        if (entity instanceof InputStream) {
            InputStream stream = (InputStream)entity;
            InputStreamResource resource = new InputStreamResource(stream);
            return new ResponseEntity((Object)resource, (HttpStatusCode)HttpStatus.OK);
        }
        return null;
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws VitamClientException {
        VitamContext vitamContext = this.buildVitamContext();
        JsonNode history = this.findHistoryByIdentifier(vitamContext, id);
        try {
            return (LogbookOperationsCommonResponseDto)this.objectMapper.treeToValue((TreeNode)history, LogbookOperationsCommonResponseDto.class);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error parsing history data", (Throwable)e);
        }
    }
}

