/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.probativevalue;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.QualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.utils.PdfFileGenerator;
import fr.gouv.vitamui.commons.utils.SecurePathUtils;
import fr.gouv.vitamui.commons.utils.SecureZipUtils;
import fr.gouv.vitamui.commons.vitam.api.access.UnitCommonService;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import fr.gouv.vitamui.referential.common.export.probativevalue.dto.ItemWithLabelDto;
import fr.gouv.vitamui.referential.common.export.probativevalue.dto.ProbativeOperationDto;
import fr.gouv.vitamui.referential.common.export.probativevalue.dto.ProbativeReportDto;
import fr.gouv.vitamui.referential.common.export.probativevalue.dto.ReportEntryDto;
import fr.gouv.vitamui.referential.common.service.VitamBatchReportCommonService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ProbativeValueService {
    private static final String TEMPLATE_PROBATIVEVALUEREPORT_ODT = "templates/probativevaluereport.ftl.odt";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProbativeValueService.class);
    private final VitamBatchReportCommonService vitamBatchReportCommonService;
    private final UnitCommonService unitCommonService;

    ProbativeValueService(VitamBatchReportCommonService vitamBatchReportCommonService, UnitCommonService unitCommonService) {
        this.vitamBatchReportCommonService = vitamBatchReportCommonService;
        this.unitCommonService = unitCommonService;
    }

    public void exportReport(VitamContext vitamContext, String operationId, String workspaceOperationPath, OutputStream outputStream) {
        LOGGER.info("Export Probative Values EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        this.checkWorkspacePath(workspaceOperationPath);
        this.getProbativeValueReportJson(vitamContext, operationId, workspaceOperationPath);
        this.generatePDF(vitamContext, operationId, workspaceOperationPath);
        this.generateZip(operationId, workspaceOperationPath, outputStream);
    }

    private void getProbativeValueReportJson(VitamContext vitamContext, String operationId, String workspaceOperationPath) {
        try (InputStream reportStream = this.vitamBatchReportCommonService.downloadBatchReport(vitamContext, operationId);){
            File file = new File(workspaceOperationPath, operationId + ".json");
            FileUtils.copyInputStreamToFile((InputStream)reportStream, (File)file);
        }
        catch (VitamClientException e) {
            LOGGER.error("Error while getting probative value report from Vitam", (Object)e.getMessage());
            throw new InternalServerException("Unable to get Probative Value Report from VITAM", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Error on probative value report", (Object)e.getMessage());
            throw new InternalServerException("Unable to create JSON from Probative Value Report", (Throwable)e);
        }
    }

    private void generatePDF(VitamContext vitamContext, String operationId, String workspaceOperationPath) {
        try {
            File jsonReport = new File(workspaceOperationPath, operationId + ".json");
            ProbativeReportDto report = (ProbativeReportDto)JsonHandler.getFromFile((File)jsonReport, ProbativeReportDto.class);
            this.reportEntriesConsolidation(vitamContext, report);
            File pdffile = new File(workspaceOperationPath, operationId + ".pdf");
            try (InputStream odtTemplate = this.getClass().getClassLoader().getResourceAsStream(TEMPLATE_PROBATIVEVALUEREPORT_ODT);
                 FileOutputStream pdfOutputStream = new FileOutputStream(pdffile);){
                HashMap<String, ProbativeReportDto> dataMap = new HashMap<String, ProbativeReportDto>();
                dataMap.put("report", report);
                PdfFileGenerator.createPdf((InputStream)odtTemplate, (OutputStream)pdfOutputStream, dataMap);
            }
            catch (Exception e) {
                LOGGER.error("Unable to create PDF from Probative Value Report template ODT", (Object)e.getMessage());
                throw new InternalServerException("Unable to create PDF from Probative Value Report template ODT", (Throwable)e);
            }
        }
        catch (InvalidParseOperationException | VitamClientException exc) {
            LOGGER.error("Unable to create PDF from Probative Value Report Json value", (Object)exc.getMessage());
            throw new InternalServerException("Unable to create PDF from Probative Value Report Json value", exc);
        }
    }

    private void generateZip(String operationId, String workspaceOperationPath, OutputStream outputStream) {
        try {
            ArrayList<Path> filesPaths = new ArrayList<Path>();
            filesPaths.add(Path.of(SecurePathUtils.buildFilePath((String)workspaceOperationPath, (String)(operationId + ".json")), new String[0]));
            filesPaths.add(Path.of(SecurePathUtils.buildFilePath((String)workspaceOperationPath, (String)(operationId + ".pdf")), new String[0]));
            SecureZipUtils.zipFiles(filesPaths, (OutputStream)outputStream);
        }
        catch (Exception e) {
            LOGGER.error("Unable to generate ZIP", (Object)e.getMessage());
            throw new InternalServerException("Unable to generate ZIP: %s".formatted(e.getMessage()), (Throwable)e);
        }
    }

    private void reportEntriesConsolidation(VitamContext vitamContext, ProbativeReportDto report) throws VitamClientException, InvalidParseOperationException {
        for (ReportEntryDto reportEntry : report.getReportEntries()) {
            Optional<VersionsModel> qualifierVersionObject;
            ObjectGroupResponse objectGroupResponse;
            Optional<QualifiersModel> qualifierObject;
            String usage = StringUtils.substringBefore((String)reportEntry.getUsageVersion(), (String)"_");
            String version = StringUtils.substringAfter((String)reportEntry.getUsageVersion(), (String)"_");
            VitamUISearchResponseDto unitResponse = this.unitCommonService.getByIdIn((Collection)reportEntry.getUnitIds(), vitamContext);
            for (String unitId : reportEntry.getUnitIds()) {
                Optional<ResultsDto> resultUnit = unitResponse.getResults().stream().filter(result -> result.getId().equals(unitId)).findFirst();
                ItemWithLabelDto unitWithLabel = new ItemWithLabelDto();
                unitWithLabel.setItem(unitId);
                if (resultUnit.isPresent()) {
                    unitWithLabel.setLabel(resultUnit.get().getTitle());
                }
                if (reportEntry.getUnitIdWithLabels() == null) {
                    reportEntry.setUnitIdWithLabels(new ArrayList());
                }
                reportEntry.getUnitIdWithLabels().add(unitWithLabel);
            }
            RequestResponse got = this.unitCommonService.findObjectMetadataById((String)reportEntry.getUnitIds().get(0), vitamContext);
            if (got.isOk() && (qualifierObject = (objectGroupResponse = (ObjectGroupResponse)JsonHandler.getFromJsonNode((JsonNode)got.toJsonNode().get("$results"), ObjectGroupResponse.class)).getQualifiers().stream().filter(item -> usage.equals(item.getQualifier())).findFirst()).isPresent() && (qualifierVersionObject = qualifierObject.get().getVersions().stream().filter(item -> version.equals(String.valueOf(item.getVersion()))).findFirst()).isPresent()) {
                reportEntry.setObjectLabel(qualifierVersionObject.get().getFileInfoModel().getFilename());
            }
            for (ProbativeOperationDto operation : reportEntry.getOperations()) {
                if (operation.getRightsStatementIdentifier() == null) continue;
                if (operation.getRightsStatementIdentifier().has("ArchivalAgreement")) {
                    operation.setArchivalAgreement(operation.getRightsStatementIdentifier().get("ArchivalAgreement").asText());
                }
                if (operation.getRightsStatementIdentifier().has("Profil")) {
                    operation.setProfil(operation.getRightsStatementIdentifier().get("Profil").asText());
                }
                if (!operation.getRightsStatementIdentifier().has("AccessContract")) continue;
                operation.setAccessContract(operation.getRightsStatementIdentifier().get("AccessContract").asText());
            }
        }
    }

    private void checkWorkspacePath(String workspaceOperationPath) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)workspaceOperationPath), (String)"No operation workspace path has been set");
        Path workspaceOperation = Path.of(workspaceOperationPath, new String[0]);
        if (!Files.exists(workspaceOperation, new LinkOption[0])) {
            String message = "The following operation workspace does not exists: %s".formatted(workspaceOperation.toString());
            throw new InternalServerException(message);
        }
        if (!Files.isDirectory(workspaceOperation, new LinkOption[0])) {
            String message = "The following operation workspace is not a directory: %s".formatted(workspaceOperation.toString());
            throw new InternalServerException(message);
        }
    }
}

