/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.externalreferential;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dto.ExternalAgencyDto;
import fr.gouv.vitamui.referential.common.dto.ExternalIngestContractDto;
import fr.gouv.vitamui.referential.common.dto.ExternalProfileDto;
import fr.gouv.vitamui.referential.common.dto.ExternalReferentialConfigDto;
import fr.gouv.vitamui.referential.server.service.externalreferential.ExternalArchivingSystemConfigurationManager;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExternalReferentialService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalReferentialService.class);
    private final SecurityService securityService;
    private final ExternalArchivingSystemConfigurationManager configurationManager;

    public ExternalReferentialService(SecurityService securityService, ExternalArchivingSystemConfigurationManager configurationManager) {
        this.securityService = securityService;
        this.configurationManager = configurationManager;
    }

    public Collection<ExternalReferentialConfigDto> listExternalReferentialConfig() {
        int tenantIdentifier = this.securityService.getTenantIdentifier();
        return this.configurationManager.listExternalReferentialConfig(tenantIdentifier);
    }

    public List<ExternalAgencyDto> listAgencies(String archivingSystemId, Integer targetTenantIdentifier) {
        List<ExternalAgencyDto> list;
        block8: {
            this.configurationManager.validateExternalReferential(this.securityService.getTenantIdentifier(), archivingSystemId, targetTenantIdentifier);
            VitamContext vitamContext = this.buildVitamContext(targetTenantIdentifier);
            LOGGER.info("List agencies from external archiving system '{}' - EvIdAppSession : {} ", (Object)archivingSystemId, (Object)vitamContext.getApplicationSessionId());
            AdminExternalClient adminExternalClient = this.getAdminExternalClient(archivingSystemId);
            try {
                Select select = new Select();
                select.addUsedProjection(new String[]{"Identifier", "Name", "Description"});
                select.addOrderByAscFilter(new String[]{"Identifier"});
                RequestResponse response = adminExternalClient.findAgencies(vitamContext, (JsonNode)select.getFinalSelect());
                VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
                list = ((RequestResponseOK)response).getResults().stream().map(p -> new ExternalAgencyDto().setIdentifier(p.getIdentifier()).setName(p.getName()).setDescription(p.getDescription())).toList();
                if (adminExternalClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (adminExternalClient != null) {
                        try {
                            adminExternalClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | VitamClientException e) {
                    throw new InternalServerException("Unable to find ingest contracts from external archiving system '" + archivingSystemId + "'", e);
                }
            }
            adminExternalClient.close();
        }
        return list;
    }

    public List<ExternalIngestContractDto> listIngestContracts(String archivingSystemId, Integer targetTenantIdentifier) {
        List<ExternalIngestContractDto> list;
        block8: {
            this.configurationManager.validateExternalReferential(this.securityService.getTenantIdentifier(), archivingSystemId, targetTenantIdentifier);
            VitamContext vitamContext = this.buildVitamContext(targetTenantIdentifier);
            LOGGER.info("List ingest contracts from external archiving system '{}' - EvIdAppSession : {} ", (Object)archivingSystemId, (Object)vitamContext.getApplicationSessionId());
            AdminExternalClient adminExternalClient = this.getAdminExternalClient(archivingSystemId);
            try {
                Select select = new Select();
                select.addUsedProjection(new String[]{"Identifier", "Name", "Description"});
                select.addOrderByAscFilter(new String[]{"Identifier"});
                RequestResponse response = adminExternalClient.findIngestContracts(vitamContext, (JsonNode)select.getFinalSelect());
                VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
                list = ((RequestResponseOK)response).getResults().stream().map(p -> new ExternalIngestContractDto().setIdentifier(p.getIdentifier()).setName(p.getName()).setDescription(p.getDescription())).toList();
                if (adminExternalClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (adminExternalClient != null) {
                        try {
                            adminExternalClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | VitamClientException e) {
                    throw new InternalServerException("Unable to find ingest contracts from external archiving system '" + archivingSystemId + "'", e);
                }
            }
            adminExternalClient.close();
        }
        return list;
    }

    public List<ExternalProfileDto> listArchiveProfiles(String externalSystemId, Integer targetTenantIdentifier) {
        List<ExternalProfileDto> list;
        block8: {
            this.configurationManager.validateExternalReferential(this.securityService.getTenantIdentifier(), externalSystemId, targetTenantIdentifier);
            VitamContext vitamContext = this.buildVitamContext(targetTenantIdentifier);
            LOGGER.info("List profiles from external archiving system '{}' - EvIdAppSession : {} ", (Object)externalSystemId, (Object)vitamContext.getApplicationSessionId());
            AdminExternalClient adminExternalClient = this.getAdminExternalClient(externalSystemId);
            try {
                Select select = new Select();
                select.addUsedProjection(new String[]{"Identifier", "Name", "Description"});
                select.addOrderByAscFilter(new String[]{"Identifier"});
                RequestResponse response = adminExternalClient.findProfiles(vitamContext, (JsonNode)select.getFinalSelect());
                VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
                list = ((RequestResponseOK)response).getResults().stream().map(p -> new ExternalProfileDto().setIdentifier(p.getIdentifier()).setName(p.getName()).setDescription(p.getDescription())).toList();
                if (adminExternalClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (adminExternalClient != null) {
                        try {
                            adminExternalClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | VitamClientException e) {
                    throw new InternalServerException("Unable to list profiles from external archiving system '" + externalSystemId + "'", e);
                }
            }
            adminExternalClient.close();
        }
        return list;
    }

    private AdminExternalClient getAdminExternalClient(String archivingSystemId) {
        return this.configurationManager.getClient(archivingSystemId);
    }

    private VitamContext buildVitamContext(Integer tenantIdentifier) {
        return new VitamContext(tenantIdentifier).setApplicationSessionId(this.securityService.getApplicationId());
    }
}

