/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.context;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.api.AdminCollections;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.VitamUIException;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.ContextDto;
import fr.gouv.vitamui.referential.common.dto.ContextResponseDto;
import fr.gouv.vitamui.referential.common.dto.PermissionDto;
import fr.gouv.vitamui.referential.common.service.VitamContextCommonService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import fr.gouv.vitamui.referential.server.service.context.ContextConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ContextService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextService.class);
    private VitamContextCommonService vitamContextCommonService;
    private ObjectMapper objectMapper;
    private ContextConverter converter;
    private LogbookService logbookService;

    public ContextService(VitamContextCommonService vitamContextCommonService, ObjectMapper objectMapper, ContextConverter converter, LogbookService logbookService, SecurityService securityService) {
        super(securityService);
        this.vitamContextCommonService = vitamContextCommonService;
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.logbookService = logbookService;
    }

    public ContextDto getOne(VitamContext vitamContext, String identifier) {
        try {
            LOGGER.debug("Context EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamContextCommonService.findContextById(vitamContext, identifier);
            ContextResponseDto contextResponseDto = (ContextResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ContextResponseDto.class);
            if (contextResponseDto.getResults().size() == 0) {
                return null;
            }
            return this.converter.convertVitamToDto((ContextModel)contextResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Context", e);
        }
    }

    public List<ContextDto> getAll(VitamContext vitamContext) {
        try {
            LOGGER.debug("All Contexts EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamContextCommonService.findContexts(vitamContext, (JsonNode)new Select().getFinalSelect());
            ContextResponseDto contextResponseDto = (ContextResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ContextResponseDto.class);
            return this.converter.convertVitamsToDtos(contextResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Contexts", e);
        }
    }

    public PaginatedValuesDto<ContextDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        LOGGER.debug("All Contexts EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        Map vitamCriteria = new HashMap();
        JsonNode query = null;
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Can't create dsl query to get paginated contexts", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        LOGGER.debug("Query: {}", (Object)query);
        ContextResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        LOGGER.debug("Contexts: {}", (Object)results.getResults());
        List<ContextDto> valuesDto = this.converter.convertVitamsToDtos(results.getResults());
        LOGGER.debug("Contexts: {}", valuesDto);
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    public ContextResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.debug("All Contexts EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamContextCommonService.findContexts(vitamContext, query);
            LOGGER.debug("Response: {}", (Object)requestResponse);
            LOGGER.debug("Response DTO: {}", this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ContextResponseDto.class));
            return (ContextResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ContextResponseDto.class);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Can't find contexts", e);
        }
    }

    public Boolean check(VitamContext vitamContext, ContextDto contextDto) {
        ArrayList<ContextDto> contextDtoList = new ArrayList<ContextDto>();
        contextDtoList.add(contextDto);
        LOGGER.debug("Context Check EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        try {
            return !this.vitamContextCommonService.checkAbilityToCreateContextInVitam(this.converter.convertDtosToVitams(contextDtoList), vitamContext);
        }
        catch (ConflictException e) {
            return true;
        }
        catch (VitamUIException e) {
            throw new InternalServerException("Unable to check context", (Throwable)e);
        }
    }

    public ContextDto create(VitamContext vitamContext, ContextDto contextDto) {
        try {
            LOGGER.debug("Create Context EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamContextCommonService.createContext(vitamContext, contextDto);
            if (!requestResponse.isOk()) {
                throw new InternalServerException(requestResponse.toJsonNode().get("message").textValue());
            }
            return contextDto;
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Can't create context", e);
        }
    }

    private ObjectNode convertPartialDtoToUpperCaseVitamFields(ContextDto partialDto) throws InvalidParseOperationException {
        ObjectNode propertiesToUpdate = JsonHandler.createObjectNode();
        if (partialDto.getStatus() != null) {
            propertiesToUpdate.put("Status", partialDto.getStatus());
        }
        if (partialDto.getCreationDate() != null) {
            propertiesToUpdate.put("CreationDate", partialDto.getCreationDate());
        }
        if (partialDto.getLastUpdate() != null) {
            propertiesToUpdate.put("LastUpdate", partialDto.getLastUpdate());
        }
        if (partialDto.getActivationDate() != null) {
            propertiesToUpdate.put("ActivationDate", partialDto.getActivationDate());
        }
        if (partialDto.getDeactivationDate() != null) {
            propertiesToUpdate.put("DeactivationDate", partialDto.getDeactivationDate());
        }
        if (partialDto.getEnableControl() != null) {
            propertiesToUpdate.put("EnableControl", partialDto.getEnableControl());
        }
        if (partialDto.getSecurityProfile() != null) {
            propertiesToUpdate.put("SecurityProfile", partialDto.getSecurityProfile());
        }
        if (partialDto.getPermissions() != null) {
            ArrayNode array = JsonHandler.createArrayNode();
            for (PermissionDto value : partialDto.getPermissions()) {
                JsonNode node = JsonHandler.toJsonNode((Object)value);
                ObjectNode permission = JsonHandler.createObjectNode();
                permission.set("tenant", (JsonNode)new IntNode(Integer.valueOf(node.get("tenant").textValue()).intValue()));
                permission.set("AccessContracts", node.get("accessContracts"));
                permission.set("IngestContracts", node.get("ingestContracts"));
                array.add((JsonNode)permission);
            }
            propertiesToUpdate.set("Permissions", (JsonNode)array);
        }
        return propertiesToUpdate;
    }

    public ContextDto patch(VitamContext vitamContext, ContextDto partialDto) {
        String id = partialDto.getIdentifier();
        if (id == null) {
            throw new BadRequestException("id must be one the the update criteria");
        }
        try {
            LOGGER.debug("Patch Context EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            ObjectNode fieldsUpdated = this.convertPartialDtoToUpperCaseVitamFields(partialDto);
            ObjectNode action = JsonHandler.createObjectNode();
            action.set("$set", (JsonNode)fieldsUpdated);
            ArrayNode actions = JsonHandler.createArrayNode();
            actions.add((JsonNode)action);
            ObjectNode query = JsonHandler.createObjectNode();
            query.set("$action", (JsonNode)actions);
            RequestResponse requestResponse = this.vitamContextCommonService.patchContext(vitamContext, id, (JsonNode)query);
            ContextModel contextVitamDto = (ContextModel)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ContextModel.class);
            return this.converter.convertVitamToDto(contextVitamDto);
        }
        catch (JsonProcessingException | AccessExternalClientException | InvalidParseOperationException e) {
            throw new InternalServerException("Can't patch the context", e);
        }
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String identifier) throws VitamClientException {
        LOGGER.debug("findHistoryById for identifier" + identifier);
        LOGGER.debug("Find Context History EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        return this.logbookService.findEventsByIdentifierAndCollectionNames(identifier, AdminCollections.ACCESS_CONTRACTS.getName(), vitamContext).toJsonNode();
    }

    public ContextDto getOne(String identifier) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getOne(vitamContext, identifier);
    }

    public List<ContextDto> getAll() {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAll(vitamContext);
    }

    public PaginatedValuesDto<ContextDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAllPaginated(pageNumber, size, orderBy, direction, vitamContext, criteria);
    }

    public ContextDto create(ContextDto contextDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.create(vitamContext, contextDto);
    }

    public Boolean check(ContextDto contextDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.check(vitamContext, contextDto);
    }

    public ContextDto patch(ContextDto partialDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.patch(vitamContext, partialDto);
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String identifier) throws VitamClientException {
        VitamContext vitamContext = this.buildVitamContext();
        JsonNode body = this.findHistoryByIdentifier(vitamContext, identifier);
        try {
            return (LogbookOperationsCommonResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsCommonResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }
}

