/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.archivalprofileunit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.VitamUIException;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.ArchivalProfileUnitDto;
import fr.gouv.vitamui.referential.common.dto.ArchivalProfileUnitResponseDto;
import fr.gouv.vitamui.referential.common.service.VitamArchivalProfileUnitCommonService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import fr.gouv.vitamui.referential.server.service.archivalprofileunit.ArchivalProfileUnitConverter;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ArchivalProfileUnitService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchivalProfileUnitService.class);
    private ObjectMapper objectMapper;
    private ArchivalProfileUnitConverter converter;
    private LogbookService logbookService;
    private VitamArchivalProfileUnitCommonService vitamArchivalProfileUnitCommonService;

    public ArchivalProfileUnitService(ObjectMapper objectMapper, ArchivalProfileUnitConverter converter, LogbookService logbookService, VitamArchivalProfileUnitCommonService vitamArchivalProfileUnitCommonService, SecurityService securityService) {
        super(securityService);
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.logbookService = logbookService;
        this.vitamArchivalProfileUnitCommonService = vitamArchivalProfileUnitCommonService;
    }

    public ArchivalProfileUnitDto getOne(VitamContext vitamContext, String identifier) {
        try {
            LOGGER.info("Archival Unit Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamArchivalProfileUnitCommonService.findArchivalProfileById(vitamContext, identifier);
            ArchivalProfileUnitResponseDto archivalProfileUnitResponseDto = (ArchivalProfileUnitResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ArchivalProfileUnitResponseDto.class);
            if (archivalProfileUnitResponseDto.getResults().size() == 0) {
                return null;
            }
            return this.converter.convertVitamToDto((ArchiveUnitProfileModel)archivalProfileUnitResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Archival Unit Profile", e);
        }
    }

    public ArchivalProfileUnitDto getOne(String identifier) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getOne(vitamContext, identifier);
    }

    public List<ArchivalProfileUnitDto> getAll(VitamContext vitamContext, Optional<String> criteria) {
        LOGGER.debug("Get ALL Archival Unit Profiles !");
        Map vitamCriteria = new HashMap();
        try {
            LOGGER.info("All Archival Profiles EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            JsonNode query = VitamQueryHelper.createQueryDSL(vitamCriteria);
            RequestResponse requestResponse = this.vitamArchivalProfileUnitCommonService.findArchivalProfiles(vitamContext, query);
            LOGGER.debug("Response: {}", (Object)requestResponse);
            ArchivalProfileUnitResponseDto archivalProfileUnitResponseDto = (ArchivalProfileUnitResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ArchivalProfileUnitResponseDto.class);
            return this.converter.convertVitamsToDtos(archivalProfileUnitResponseDto.getResults());
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new InternalServerException("Unable to find archival profiles with criteria", e);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find archival unit Profiles", e);
        }
    }

    public List<ArchivalProfileUnitDto> getAll(Optional<String> criteria) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAll(vitamContext, criteria);
    }

    public PaginatedValuesDto<ArchivalProfileUnitDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        LOGGER.info("All Archival Unit Profiles EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        Map vitamCriteria = new HashMap();
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find archival unit Profiles with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        ArchivalProfileUnitResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<ArchivalProfileUnitDto> valuesDto = this.converter.convertVitamsToDtos(results.getResults());
        LOGGER.debug("Archival Unit Profiles in page: {}", valuesDto);
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    public PaginatedValuesDto<ArchivalProfileUnitDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAllPaginated(pageNumber, size, orderBy, direction, vitamContext, criteria);
    }

    private ArchivalProfileUnitResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.info("All Archival Unit Profiles EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamArchivalProfileUnitCommonService.findArchivalProfiles(vitamContext, query);
            ArchivalProfileUnitResponseDto archivalProfileUnitResponseDto = (ArchivalProfileUnitResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ArchivalProfileUnitResponseDto.class);
            LOGGER.debug("Archival Unit Profiles: {}", (Object)archivalProfileUnitResponseDto);
            return archivalProfileUnitResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find archival unit Profiles", e);
        }
    }

    public Boolean check(VitamContext vitamContext, ArchivalProfileUnitDto archivalProfileUnitDto) {
        ArrayList<ArchivalProfileUnitDto> archivalProfileUnitDtoList = new ArrayList<ArchivalProfileUnitDto>();
        archivalProfileUnitDtoList.add(archivalProfileUnitDto);
        LOGGER.info("Archival Unit Profile Check EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        try {
            return !this.vitamArchivalProfileUnitCommonService.checkAbilityToCreateArchivalProfileInVitam(this.converter.convertDtosToVitams(archivalProfileUnitDtoList), vitamContext);
        }
        catch (ConflictException e) {
            return true;
        }
        catch (VitamUIException e) {
            throw new InternalServerException("Unable to check archival unit Profile", (Throwable)e);
        }
    }

    public boolean check(ArchivalProfileUnitDto archivalProfileUnitDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.check(vitamContext, archivalProfileUnitDto);
    }

    public ArchivalProfileUnitDto update(ArchivalProfileUnitDto dto, VitamContext vitamContext) throws InvalidParseOperationException, AccessExternalClientException {
        RequestResponse requestResponse;
        String id = dto.getIdentifier();
        if (id == null) {
            throw new BadRequestException("id must be one the update criteria");
        }
        LOGGER.info("Update Archival Unit Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        JsonNode fieldsUpdated = this.convertMapDtoToUpperCaseVitamFields(dto);
        ObjectNode action = JsonHandler.createObjectNode();
        action.set("$set", fieldsUpdated);
        ArrayNode actions = JsonHandler.createArrayNode();
        actions.add((JsonNode)action);
        ObjectNode query = JsonHandler.createObjectNode();
        query.set("$action", (JsonNode)actions);
        String intentionErrorMessage = "Can't update archive unit profile";
        try {
            requestResponse = this.vitamArchivalProfileUnitCommonService.updateArchiveUnitProfile(vitamContext, id, (JsonNode)query);
        }
        catch (VitamException e) {
            throw new InternalServerException("Can't update archive unit profile", (Throwable)e);
        }
        this.tryToThrowErrors(requestResponse, "Can't update archive unit profile");
        try {
            ArchiveUnitProfileModel archivalUnitProfileVitamDto = (ArchiveUnitProfileModel)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ArchiveUnitProfileModel.class);
            return this.converter.convertVitamToDto(archivalUnitProfileVitamDto);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Can't update archive unit profile", (Throwable)e);
        }
    }

    public ArchivalProfileUnitDto update(ArchivalProfileUnitDto dto) throws AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamContext = this.buildVitamContext();
        return this.update(dto, vitamContext);
    }

    private JsonNode convertMapDtoToUpperCaseVitamFields(ArchivalProfileUnitDto dto) {
        ObjectNode propertiesToUpdate = JsonHandler.createObjectNode();
        if (dto.getName() != null) {
            propertiesToUpdate.put("Name", dto.getName());
        }
        if (dto.getDescription() != null) {
            propertiesToUpdate.put("Description", dto.getDescription());
        }
        if (dto.getStatus() != null) {
            propertiesToUpdate.put("Status", dto.getStatus().toString());
        }
        if (dto.getCreationDate() != null) {
            propertiesToUpdate.put("CreationDate", dto.getCreationDate());
        }
        if (dto.getLastUpdate() != null) {
            propertiesToUpdate.put("LastUpdate", dto.getLastUpdate());
        }
        if (dto.getActivationDate() != null) {
            propertiesToUpdate.put("ActivationDate", dto.getActivationDate());
        }
        if (dto.getDeactivationDate() != null) {
            propertiesToUpdate.put("DeactivationDate", dto.getDeactivationDate());
        }
        if (dto.getControlSchema() != null) {
            propertiesToUpdate.put("ControlSchema", dto.getControlSchema());
        }
        if (dto.getSedaVersion() != null) {
            propertiesToUpdate.put("SedaVersion", dto.getSedaVersion().getVersion());
        }
        return propertiesToUpdate;
    }

    public ArchivalProfileUnitDto create(VitamContext context, ArchivalProfileUnitDto archivalProfileUnitDto) {
        ArchiveUnitProfileModel archivalProfileVitamDto;
        RequestResponse requestResponse;
        LOGGER.debug("Try to create archival unit profile {} {}", (Object)archivalProfileUnitDto, (Object)context);
        LOGGER.info("Create Archival Unit Profile EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        ArchiveUnitProfileModel archiveUnitProfileModel = this.converter.convertDtoToVitam(archivalProfileUnitDto);
        String intentionErrorMessage = "Can't create archive unit profile";
        try {
            requestResponse = this.vitamArchivalProfileUnitCommonService.create(context, archiveUnitProfileModel);
        }
        catch (VitamException e) {
            throw new InternalServerException("Can't create archive unit profile", (Throwable)e);
        }
        catch (JAXBException | IOException e) {
            throw new RuntimeException(e);
        }
        this.tryToThrowErrors(requestResponse, "Can't create archive unit profile");
        JsonNode firstNode = requestResponse.toJsonNode().get("$results").get(0);
        try {
            archivalProfileVitamDto = (ArchiveUnitProfileModel)this.objectMapper.treeToValue((TreeNode)firstNode, ArchiveUnitProfileModel.class);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Can't create archive unit profile", (Throwable)e);
        }
        return this.converter.convertVitamToDto(archivalProfileVitamDto);
    }

    public ArchivalProfileUnitDto create(ArchivalProfileUnitDto archivalProfileUnitDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.create(vitamContext, archivalProfileUnitDto);
    }

    public ResponseEntity<JsonNode> importProfile(VitamContext vitamContext, String fileName, MultipartFile file) {
        try {
            RequestResponse response = this.vitamArchivalProfileUnitCommonService.importArchivalUnitProfileByFile(vitamContext, fileName, file);
            if (response.isOk()) {
                return ResponseEntity.ok((Object)response.toJsonNode());
            }
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            LOGGER.error("Unable to import archival unit profile by file {}: {}", (Object)fileName, (Object)e.getMessage());
            throw new InternalServerException("Unable to import archival unit profile by file " + fileName + " : ", e);
        }
    }

    public ResponseEntity<JsonNode> importArchivalUnitProfiles(String fileName, MultipartFile file) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.importProfile(vitamContext, fileName, file);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name", "identifier");
    }

    private void tryToThrowErrors(RequestResponse<?> requestResponse, String intention) {
        boolean isValid;
        boolean bl = isValid = requestResponse.getStatus() < 400;
        if (isValid) {
            return;
        }
        VitamError error = (VitamError)requestResponse;
        LOGGER.error("intention: {}, code: {}, message: {},  description: {}", new Object[]{intention, error.getCode(), error.getMessage(), error.getDescription()});
        throw new InternalServerException(intention, error.getMessage(), List.of(requestResponse.getHeaderString("X-Request-Id")));
    }
}

