/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.agency;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.VitamUIException;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyCommonService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.AgencyDto;
import fr.gouv.vitamui.referential.common.dto.AgencyResponseDto;
import fr.gouv.vitamui.referential.common.service.VitamAgencyCommonService;
import fr.gouv.vitamui.referential.common.utils.AgencyConverter;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import fr.gouv.vitamui.referential.server.service.utils.ExportCSVUtils;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AgencyService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyService.class);
    private AgencyCommonService agencyCommonService;
    private ObjectMapper objectMapper;
    private LogbookService logbookService;
    private VitamAgencyCommonService vitamAgencyCommonService;

    public AgencyService(AgencyCommonService agencyCommonService, ObjectMapper objectMapper, LogbookService logbookService, VitamAgencyCommonService vitamAgencyCommonService, SecurityService securityService) {
        super(securityService);
        this.agencyCommonService = agencyCommonService;
        this.objectMapper = objectMapper;
        this.logbookService = logbookService;
        this.vitamAgencyCommonService = vitamAgencyCommonService;
    }

    public AgencyDto getOne(VitamContext vitamContext, String identifier) {
        try {
            RequestResponse requestResponse = this.agencyCommonService.findAgencyById(vitamContext, identifier);
            AgencyResponseDto agencyResponseDto = (AgencyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class);
            if (agencyResponseDto.getResults().isEmpty()) {
                return null;
            }
            return AgencyConverter.convertVitamToDto((AgenciesModel)((AgenciesModel)agencyResponseDto.getResults().get(0)));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Agency", e);
        }
    }

    public AgencyDto getOne(String id) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getOne(vitamContext, id);
    }

    public List<AgencyDto> getAll(VitamContext vitamContext) {
        try {
            RequestResponse requestResponse = this.agencyCommonService.findAgencies(vitamContext, (JsonNode)new Select().getFinalSelect());
            AgencyResponseDto agencyResponseDto = (AgencyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class);
            return AgencyConverter.convertVitamsToDtos((List)agencyResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find agencies", e);
        }
    }

    public List<AgencyDto> getAll(Optional<String> criteria) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAll(vitamContext);
    }

    public PaginatedValuesDto<AgencyDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        if (vitamContext != null) {
            LOGGER.info("All Agencies EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        }
        Map vitamCriteria = new HashMap();
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find agencies with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        AgencyResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List valuesDto = AgencyConverter.convertVitamsToDtos((List)results.getResults());
        return new PaginatedValuesDto((Collection)valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    public PaginatedValuesDto<AgencyDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    private AgencyResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            RequestResponse requestResponse = this.agencyCommonService.findAgencies(vitamContext, query);
            return (AgencyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find agencies", e);
        }
    }

    public Boolean check(VitamContext vitamContext, AgencyDto agencyDto) {
        try {
            Integer agencyCheckedTenant = this.vitamAgencyCommonService.checkAbilityToCreateAgencyInVitam(AgencyConverter.convertDtosToVitams(Collections.singletonList(agencyDto)), vitamContext.getApplicationSessionId());
            return !vitamContext.getTenantId().equals(agencyCheckedTenant);
        }
        catch (ConflictException e) {
            return true;
        }
        catch (VitamUIException e) {
            throw new InternalServerException("Unable to check agency", (Throwable)e);
        }
    }

    public boolean check(AgencyDto agencyDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.check(vitamContext, agencyDto);
    }

    public AgencyDto create(VitamContext vitamContext, AgencyDto agencyDto) {
        try {
            RequestResponse requestResponse = this.vitamAgencyCommonService.create(vitamContext, AgencyConverter.convertDtoToVitam((AgencyDto)agencyDto));
            AgenciesModel agencyModelDto = (AgenciesModel)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgenciesModel.class);
            return AgencyConverter.convertVitamToDto((AgenciesModel)agencyModelDto);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            throw new InternalServerException("Unable to create agency", e);
        }
    }

    public AgencyDto create(AgencyDto agencyDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.create(vitamContext, agencyDto);
    }

    public AgencyDto patch(VitamContext vitamContext, AgencyDto agencyDto) {
        AgenciesModel agencyModelDto = AgencyConverter.convertDtoToVitam((AgencyDto)agencyDto);
        try {
            this.vitamAgencyCommonService.patchAgency(vitamContext, agencyDto.getId(), agencyModelDto);
            return agencyDto;
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            throw new InternalServerException("Unable to patch agency", e);
        }
    }

    public AgencyDto patch(Map<String, Object> partialDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.patch(vitamContext, (AgencyDto)this.objectMapper.convertValue(partialDto, AgencyDto.class));
    }

    public boolean delete(String id) {
        VitamContext vitamContext = this.buildVitamContext();
        try {
            return this.vitamAgencyCommonService.deleteAgency(vitamContext, id);
        }
        catch (BadRequestException e) {
            return false;
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            throw new InternalServerException("Unable to delete agency", e);
        }
    }

    public Response export(VitamContext context) {
        try {
            return this.vitamAgencyCommonService.export(context);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | VitamClientException e) {
            throw new InternalServerException("Unable to export agencies", e);
        }
    }

    public ResponseEntity<Resource> export() {
        VitamContext vitamContext = this.buildVitamContext();
        Response response = this.export(vitamContext);
        Object entity = response.getEntity();
        if (entity instanceof InputStream) {
            InputStream stream = (InputStream)entity;
            SequenceInputStream mergedBomCsvInputStream = new SequenceInputStream(new ByteArrayInputStream(ExportCSVUtils.BOM), stream);
            InputStreamResource resource = new InputStreamResource((InputStream)mergedBomCsvInputStream);
            return new ResponseEntity((Object)resource, (HttpStatusCode)HttpStatus.OK);
        }
        return null;
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String id) throws VitamClientException {
        try {
            return this.logbookService.selectOperations(VitamQueryHelper.buildOperationQuery((String)id), vitamContext).toJsonNode();
        }
        catch (InvalidCreateOperationException e) {
            throw new InternalServerException("Unable to fetch history", (Throwable)e);
        }
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws VitamClientException {
        VitamContext vitamContext = this.buildVitamContext();
        JsonNode body = this.findHistoryByIdentifier(vitamContext, id);
        try {
            return (LogbookOperationsCommonResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsCommonResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public JsonNode importAgencies(String fileName, MultipartFile file) {
        VitamContext vitamContext = this.buildVitamContext();
        try {
            return this.vitamAgencyCommonService.importAgencies(vitamContext, fileName, file).toJsonNode();
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            LOGGER.error("Unable to import agency file {}: {}", (Object)fileName, (Object)e.getMessage());
            throw new InternalServerException("Unable to import agency file " + fileName + " : ", e);
        }
    }
}

