/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.accessionregister;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.facet.FacetHelper;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.commons.api.domain.AccessionRegisterSearchDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessRegisterVitamQueryHelper {
    private static final DateTimeFormatter INPUT_DTF = DateTimeFormatter.ofPattern("dd/MM/yyyy").withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter OUTPUT_DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
    private static final String ACQUISITION_INFORMATION = "AcquisitionInformation";
    private static final String NON_RENSEIGNE = "Non renseign\u00e9";
    private static final String AUTRES = "Autres";
    private static final Collection<String> NON_RENSEIGNE_ET_AUTRES = List.of("Non renseign\u00e9", "Autres");
    private static final Collection<String> ACQUISITION_INFORMATIONS_AVAILABLE = List.of("Versement", "Protocole", "Achat", "Copie", "Dation", "D\u00e9p\u00f4t", "D\u00e9volution", "Don", "Legs", "R\u00e9int\u00e9gration", "Non renseign\u00e9", "Autres");
    private static final String OPI = "Opi";
    private static final String ORIGINATING_AGENCY = "OriginatingAgency";
    private static final String STATUS = "Status";
    private static final String ARCHIVAL_AGREEMENT = "ArchivalAgreement";
    private static final String ELIMINATION = "ELIMINATION";
    private static final String ARCHIVAL_PROFILE = "ArchivalProfile";
    private static final String TRANSFER_REPLY = "TRANSFER_REPLY";
    private static final String EVENTS_OPTYPE = "Events.OpType";
    private static final String END_DATE = "EndDate";
    private static final String ALL = "all";
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessRegisterVitamQueryHelper.class);
    public static final String FACETS_TOTAL_OBJECTS = "FACETS_TOTAL_OBJECTS";
    public static final String FACETS_TOTAL_UNITS = "FACETS_TOTAL_UNITS";
    public static final String FACETS_TOTAL_OBJECT_SIZE = "FACETS_TOTAL_OBJECT_SIZE";
    public static final String FACETS_TOTAL_OBJECT_GROUPS = "FACETS_TOTAL_OBJECT_GROUPS";
    public static final String TOTAL_OBJECTS_INGESTED_PATH = "TotalObjects.ingested";
    public static final String TOTAL_UNITS_INGESTED_PATH = "TotalUnits.ingested";
    public static final String TOTAL_OBJECT_GROUPS_INGESTED_PATH = "TotalObjectGroups.ingested";
    public static final String OBJECT_SIZE_INGESTED_PATH = "ObjectSize.ingested";

    public static JsonNode createQueryDSL(AccessionRegisterSearchDto criteria) throws InvalidCreateOperationException, InvalidParseOperationException {
        return AccessRegisterVitamQueryHelper.createQueryDSL(criteria, null, null, criteria.getOrderBy(), criteria.getDirection());
    }

    public static JsonNode createQueryDSL(AccessionRegisterSearchDto criteria, Integer pageNumber, Integer size, String orderBy, DirectionDto direction) throws InvalidCreateOperationException, InvalidParseOperationException {
        Select select = new Select();
        BooleanQuery orQuery = QueryHelper.or();
        BooleanQuery andQuery = QueryHelper.and();
        if (Objects.nonNull(pageNumber) && Objects.nonNull(size)) {
            select.setLimitFilter((long)pageNumber.intValue() * (long)size.intValue(), (long)size.intValue());
        }
        AccessRegisterVitamQueryHelper.addOrderToQuery(select, orderBy, direction);
        AccessRegisterVitamQueryHelper.addFiltersToQuery(andQuery, criteria.getFilters());
        AccessRegisterVitamQueryHelper.addEndDateToQuery(andQuery, criteria.getEndDateInterval());
        AccessRegisterVitamQueryHelper.addEventsToQuery(andQuery, criteria.getElimination(), ELIMINATION);
        AccessRegisterVitamQueryHelper.addEventsToQuery(andQuery, criteria.getTransferReply(), TRANSFER_REPLY);
        AccessRegisterVitamQueryHelper.addOpiToQuery(orQuery, criteria.getOpi());
        AccessRegisterVitamQueryHelper.addOriginatingAgencyToQuery(orQuery, criteria.getOriginatingAgency());
        AccessRegisterVitamQueryHelper.addFieldInToQuery(orQuery, ORIGINATING_AGENCY, criteria.getOriginatingAgencies());
        AccessRegisterVitamQueryHelper.addFieldInToQuery(orQuery, ARCHIVAL_AGREEMENT, criteria.getArchivalAgreements());
        AccessRegisterVitamQueryHelper.addFieldInToQuery(orQuery, ARCHIVAL_PROFILE, criteria.getArchivalProfiles());
        AccessRegisterVitamQueryHelper.setAcquisitionInformationsToQuery(orQuery, criteria.getAcquisitionInformations());
        AccessRegisterVitamQueryHelper.setQuery(select, andQuery, orQuery);
        AccessRegisterVitamQueryHelper.fillAccessionRegisterFacets(select);
        ObjectNode finalSelect = select.getFinalSelect();
        LOGGER.debug("Final query Details: {}", (Object)finalSelect.toPrettyString());
        return finalSelect;
    }

    private static void fillAccessionRegisterFacets(Select select) throws InvalidCreateOperationException {
        select.addFacets(new Facet[]{FacetHelper.sum((String)FACETS_TOTAL_OBJECTS, (String)TOTAL_OBJECTS_INGESTED_PATH), FacetHelper.sum((String)FACETS_TOTAL_UNITS, (String)TOTAL_UNITS_INGESTED_PATH), FacetHelper.sum((String)FACETS_TOTAL_OBJECT_GROUPS, (String)TOTAL_OBJECT_GROUPS_INGESTED_PATH), FacetHelper.sum((String)FACETS_TOTAL_OBJECT_SIZE, (String)OBJECT_SIZE_INGESTED_PATH)});
    }

    private static void addFieldInToQuery(BooleanQuery query, String field, List<String> list) throws InvalidCreateOperationException {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        query.add(new Query[]{QueryHelper.in((String)field, (String[])list.toArray(new String[0]))});
    }

    private static void addOriginatingAgencyToQuery(BooleanQuery orQuery, String originatingAgency) throws InvalidCreateOperationException {
        if (Objects.isNull(originatingAgency)) {
            return;
        }
        orQuery.add(new Query[]{QueryHelper.wildcard((String)ORIGINATING_AGENCY, (String)("*" + originatingAgency + "*"))});
    }

    private static void addOpiToQuery(BooleanQuery orQuery, String opi) throws InvalidCreateOperationException {
        if (Objects.isNull(opi)) {
            return;
        }
        orQuery.add(new Query[]{QueryHelper.wildcard((String)OPI, (String)("*" + opi + "*"))});
    }

    private static void addFiltersToQuery(BooleanQuery andQuery, Map<String, List<String>> filters) throws InvalidCreateOperationException {
        if (MapUtils.isEmpty(filters)) {
            return;
        }
        List<String> statusFilters = filters.get(STATUS);
        if (CollectionUtils.isNotEmpty(statusFilters)) {
            andQuery.add(new Query[]{QueryHelper.in((String)STATUS, (String[])((String[])statusFilters.toArray(String[]::new)))});
        }
    }

    private static void setQuery(Select select, BooleanQuery andQuery, BooleanQuery orQuery) throws InvalidCreateOperationException {
        if (CollectionUtils.isNotEmpty((Collection)andQuery.getQueries())) {
            if (CollectionUtils.isNotEmpty((Collection)orQuery.getQueries())) {
                andQuery.add(new Query[]{orQuery});
            }
            select.setQuery((Query)andQuery);
        } else if (CollectionUtils.isNotEmpty((Collection)orQuery.getQueries())) {
            select.setQuery((Query)orQuery);
        }
    }

    private static void addOrderToQuery(Select select, String orderBy, DirectionDto direction) throws InvalidParseOperationException {
        if (Objects.isNull(orderBy)) {
            return;
        }
        if (DirectionDto.DESC.equals((Object)direction)) {
            select.addOrderByDescFilter(new String[]{orderBy});
        } else {
            select.addOrderByAscFilter(new String[]{orderBy});
        }
    }

    private static void addEventsToQuery(BooleanQuery query, String value, String searchKeyUpperCase) throws InvalidCreateOperationException {
        if (Objects.isNull(value) || value.equals(ALL)) {
            return;
        }
        if (Boolean.parseBoolean(value)) {
            query.add(new Query[]{QueryHelper.eq((String)EVENTS_OPTYPE, (String)searchKeyUpperCase)});
        } else {
            query.add(new Query[]{QueryHelper.ne((String)EVENTS_OPTYPE, (String)searchKeyUpperCase)});
        }
    }

    private static void setAcquisitionInformationsToQuery(BooleanQuery query, List<String> acquisitionInformationsList) throws InvalidCreateOperationException {
        if (CollectionUtils.isEmpty(acquisitionInformationsList)) {
            return;
        }
        ArrayList<String> acquisitionInformationsAvailable = new ArrayList<String>(ACQUISITION_INFORMATIONS_AVAILABLE);
        acquisitionInformationsAvailable.removeAll(acquisitionInformationsList);
        if (acquisitionInformationsAvailable.isEmpty()) {
            return;
        }
        if (acquisitionInformationsList.contains(NON_RENSEIGNE)) {
            query.add(new Query[]{QueryHelper.not().add(new Query[]{QueryHelper.exists((String)ACQUISITION_INFORMATION)})});
        }
        if (acquisitionInformationsList.contains(AUTRES)) {
            ArrayList<String> othersAcquisitionInformations = new ArrayList<String>(ACQUISITION_INFORMATIONS_AVAILABLE);
            othersAcquisitionInformations.removeAll(NON_RENSEIGNE_ET_AUTRES);
            query.add(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.exists((String)ACQUISITION_INFORMATION)}).add(new Query[]{QueryHelper.nin((String)ACQUISITION_INFORMATION, (String[])((String[])othersAcquisitionInformations.toArray(String[]::new)))})});
        }
        acquisitionInformationsList.removeAll(NON_RENSEIGNE_ET_AUTRES);
        if (!acquisitionInformationsList.isEmpty()) {
            query.add(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.exists((String)ACQUISITION_INFORMATION)}).add(new Query[]{QueryHelper.in((String)ACQUISITION_INFORMATION, (String[])((String[])acquisitionInformationsList.toArray(String[]::new)))})});
        }
    }

    private static void addEndDateToQuery(BooleanQuery query, AccessionRegisterSearchDto.EndDateInterval endDateInterval) {
        if (Objects.isNull(endDateInterval)) {
            return;
        }
        try {
            String dateMinStr = endDateInterval.getEndDateMin();
            String dateMaxStr = endDateInterval.getEndDateMax();
            if (Objects.nonNull(dateMinStr) && Objects.isNull(dateMaxStr)) {
                query.add(new Query[]{QueryHelper.eq((String)END_DATE, (String)LocalDate.parse(dateMinStr, INPUT_DTF).format(OUTPUT_DTF))});
            }
            if (Objects.isNull(dateMinStr) && Objects.nonNull(dateMaxStr)) {
                query.add(new Query[]{QueryHelper.eq((String)END_DATE, (String)LocalDate.parse(dateMaxStr, INPUT_DTF).format(OUTPUT_DTF))});
            }
            if (Objects.nonNull(dateMinStr) && Objects.nonNull(dateMaxStr)) {
                query.add(new Query[]{QueryHelper.range((String)END_DATE, (String)LocalDate.parse(dateMinStr, INPUT_DTF).format(OUTPUT_DTF), (boolean)true, (String)LocalDate.parse(dateMaxStr, INPUT_DTF).format(OUTPUT_DTF), (boolean)true)});
            }
        }
        catch (InvalidCreateOperationException e) {
            LOGGER.error("Can not find binding for EndDate key: \n {}", (Throwable)e);
        }
    }

    @Generated
    private AccessRegisterVitamQueryHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

