/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.accesscontract;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.converter.AccessContractConverter;
import fr.gouv.vitamui.commons.api.domain.AccessContractDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.ErrorImportFile;
import fr.gouv.vitamui.commons.api.enums.ErrorImportFileMessage;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractCommonService;
import fr.gouv.vitamui.commons.vitam.api.dto.AccessContractResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.openapiclient.ApplicationsApi;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.service.VitamUIAccessContractCommonService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import fr.gouv.vitamui.referential.server.service.accesscontract.AccessContractCSVDto;
import fr.gouv.vitamui.referential.server.service.accesscontract.AccessContractCSVUtils;
import fr.gouv.vitamui.referential.server.service.accesscontract.ExportAccessContracts;
import fr.gouv.vitamui.referential.server.service.utils.ExportCSVUtils;
import fr.gouv.vitamui.referential.server.service.utils.ImportCSVUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AccessContractService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessContractService.class);
    private static final String ACCESS_CONTRACT = "ACCESS_CONTRACT";
    private final AccessContractCommonService accessContractCommonService;
    private final VitamUIAccessContractCommonService vitamUIAccessContractCommonService;
    private final ObjectMapper objectMapper;
    private final LogbookService logbookService;
    private final ApplicationsApi applicationsApi;
    private final SecurityService securityService;

    public AccessContractService(AccessContractCommonService accessContractCommonService, VitamUIAccessContractCommonService vitamUIAccessContractCommonService, ObjectMapper objectMapper, LogbookService logbookService, ApplicationsApi applicationsApi, SecurityService securityService) {
        super(securityService);
        this.accessContractCommonService = accessContractCommonService;
        this.vitamUIAccessContractCommonService = vitamUIAccessContractCommonService;
        this.objectMapper = objectMapper;
        this.logbookService = logbookService;
        this.applicationsApi = applicationsApi;
        this.securityService = securityService;
    }

    public AccessContractDto getOne(String id) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getOne(vitamContext, id);
    }

    public AccessContractDto getOne(VitamContext vitamContext, String identifier) {
        try {
            LOGGER.debug("Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.accessContractCommonService.findAccessContractById(vitamContext, identifier);
            AccessContractResponseDto accessContractResponseDto = (AccessContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessContractResponseDto.class);
            if (accessContractResponseDto.getResults().isEmpty()) {
                return null;
            }
            return AccessContractConverter.convertVitamToDto((AccessContractModel)((AccessContractModel)accessContractResponseDto.getResults().get(0)));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Access Contract", e);
        }
    }

    public List<AccessContractDto> getAll() {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAll(vitamContext);
    }

    public List<AccessContractDto> getAll(VitamContext vitamContext) {
        try {
            LOGGER.debug("List of Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.accessContractCommonService.findAccessContracts(vitamContext, (JsonNode)new Select().getFinalSelect());
            AccessContractResponseDto accessContractResponseDto = (AccessContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessContractResponseDto.class);
            return AccessContractConverter.convertVitamsToDtos((List)accessContractResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Access Contracts", e);
        }
    }

    public PaginatedValuesDto<AccessContractDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    public PaginatedValuesDto<AccessContractDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        Map vitamCriteria = new HashMap();
        try {
            LOGGER.debug("List of Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            JsonNode query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
            LOGGER.debug("jsonQuery: {}", (Object)query);
            AccessContractResponseDto results = this.findAll(vitamContext, query);
            boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
            List valuesDto = AccessContractConverter.convertVitamsToDtos((List)results.getResults());
            return new PaginatedValuesDto((Collection)valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Can't create dsl query to get paginated access contracts", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
    }

    public AccessContractResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.debug("List of Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.accessContractCommonService.findAccessContracts(vitamContext, query);
            return (AccessContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessContractResponseDto.class);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Can't find access contracts", e);
        }
    }

    public boolean check(AccessContractDto accessContractDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.check(vitamContext, accessContractDto);
    }

    public Boolean check(VitamContext vitamContext, AccessContractDto accessContractDto) {
        try {
            LOGGER.debug("Access Contract Check EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            this.accessContractCommonService.checkAbilityToCreateAccessContractInVitam(vitamContext, AccessContractConverter.convertDtosToVitams(Collections.singletonList(accessContractDto)));
            return false;
        }
        catch (ConflictException e) {
            return true;
        }
    }

    public AccessContractDto create(AccessContractDto accessContractDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.create(vitamContext, accessContractDto);
    }

    public AccessContractDto create(VitamContext vitamContext, AccessContractDto accessContractDto) {
        RequestResponse requestResponse;
        LOGGER.debug("Creating Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        try {
            accessContractDto.setId(null);
            requestResponse = this.accessContractCommonService.createAccessContracts(vitamContext, AccessContractConverter.convertDtosToVitams(List.of(accessContractDto)));
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Can't create access contract", e);
        }
        if (requestResponse == null || HttpStatus.OK.value() != requestResponse.getHttpCode()) {
            throw new BadRequestException("Could not create access contract in vitam");
        }
        return accessContractDto;
    }

    public AccessContractDto patch(Map<String, Object> partialDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.patch(vitamContext, partialDto);
    }

    public AccessContractDto patch(VitamContext vitamContext, Map<String, Object> partialDto) {
        String identifier = (String)partialDto.get("identifier");
        if (identifier == null) {
            throw new BadRequestException("identifier must be one of the update criteria");
        }
        partialDto.remove("id");
        partialDto.remove("identifier");
        try {
            LOGGER.debug("Patch Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            if (Boolean.TRUE.equals(partialDto.get("everyDataObjectVersion"))) {
                partialDto.put("dataObjectVersion", new HashSet());
            }
            ArrayNode actions = JsonHandler.createArrayNode();
            JsonNode fieldsUpdated = AccessContractConverter.convertToUpperCaseFields(partialDto);
            ObjectNode action = JsonHandler.createObjectNode();
            action.set("$set", fieldsUpdated);
            actions.add((JsonNode)action);
            ObjectNode query = JsonHandler.createObjectNode();
            query.set("$action", (JsonNode)actions);
            LOGGER.debug("Send AccessContract update request: {}", (Object)query);
            this.vitamUIAccessContractCommonService.patchAccessContract(vitamContext, identifier, (JsonNode)query);
            return this.getOne(vitamContext, identifier);
        }
        catch (AccessExternalClientException | InvalidParseOperationException e) {
            throw new InternalServerException("Can't patch access contract", e);
        }
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws VitamClientException {
        VitamContext vitamContext = this.buildVitamContext();
        JsonNode body = this.findHistoryByIdentifier(vitamContext, id);
        try {
            return (LogbookOperationsCommonResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsCommonResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String id) throws VitamClientException {
        LOGGER.debug("Find History Access Contract By ID {}, EvIdAppSession : {}", (Object)id, (Object)vitamContext.getApplicationSessionId());
        try {
            return this.logbookService.selectOperations(VitamQueryHelper.buildOperationQuery((String)id), vitamContext).toJsonNode();
        }
        catch (InvalidCreateOperationException e) {
            throw new InternalServerException("Unable to fetch history", (Throwable)e);
        }
    }

    public ResponseEntity<Void> importAccessContracts(MultipartFile file) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.importAccessContracts(vitamContext, file);
    }

    public ResponseEntity<Void> importAccessContracts(VitamContext context, MultipartFile file) {
        RequestResponse result;
        Boolean isIdentifierMandatory = this.applicationsApi.isApplicationExternalIdentifierEnabled(ACCESS_CONTRACT);
        if (isIdentifierMandatory == null) {
            throw new InternalServerException("The result of the API call should not be null");
        }
        AccessContractCSVUtils.checkImportFile(file, isIdentifierMandatory);
        LOGGER.debug("access contracts file {} has been validated before parsing it", (Object)file.getOriginalFilename());
        List<AccessContractCSVDto> accessContractCSVDtos = this.convertCsvFileToAccessContractsDto(file);
        LOGGER.debug("access contracts file {} has been parsed in accessContract List", (Object)file.getOriginalFilename());
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
        String accessContractCSVDtosJson = gson.toJson(accessContractCSVDtos);
        LOGGER.debug("access contracts file {} has been parsed in JSON String", (Object)file.getOriginalFilename());
        try {
            result = this.accessContractCommonService.createAccessContracts(context, (InputStream)new ByteArrayInputStream(accessContractCSVDtosJson.getBytes()));
            LOGGER.debug("access contracts file {} has been send to VITAM", (Object)file.getOriginalFilename());
        }
        catch (AccessExternalClientException | InvalidParseOperationException e) {
            throw new InternalServerException("Unable to import access contracts file " + file.getOriginalFilename() + " : ", e);
        }
        if (HttpStatus.OK.value() == result.getHttpCode()) {
            LOGGER.debug("access contracts file {} has been successfully import to VITAM", (Object)file.getOriginalFilename());
            return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
        }
        throw new BadRequestException("The CSV file has been rejected by vitam", null, List.of(ImportCSVUtils.errorToJson(ErrorImportFile.builder().error(ErrorImportFileMessage.REJECT_BY_VITAM_CHECK_LOGBOOK_OPERATION_APP).build())));
    }

    private List<AccessContractCSVDto> convertCsvFileToAccessContractsDto(MultipartFile file) {
        List list;
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(file.getInputStream()), StandardCharsets.UTF_8);
        try {
            CsvToBean csvToBean = new CsvToBeanBuilder((Reader)reader).withType(AccessContractCSVDto.class).withIgnoreLeadingWhiteSpace(true).withFieldAsNull(CSVReaderNullFieldIndicator.BOTH).withSeparator(';').build();
            list = csvToBean.parse();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException e) {
                throw new BadRequestException("Unable to read access contracts CSV file " + file.getOriginalFilename(), (Throwable)e);
            }
        }
        ((Reader)reader).close();
        return list;
    }

    public ResponseEntity<Resource> exportAccessContracts() {
        VitamContext vitamContext = this.buildVitamContext();
        return new ResponseEntity((Object)this.exportAccessContracts(vitamContext), (HttpStatusCode)HttpStatus.OK);
    }

    public Resource exportAccessContracts(VitamContext vitamContext) {
        List<AccessContractDto> accessContracts = this.getAll(vitamContext);
        ExportAccessContracts exporter = new ExportAccessContracts();
        ArrayList<String[]> csvLines = new ArrayList<String[]>();
        csvLines.add(exporter.getHeaders().toArray(new String[exporter.getSize()]));
        SimpleDateFormat dateFormat = new SimpleDateFormat(exporter.getPatternDate());
        accessContracts.forEach(accessContract -> {
            try {
                csvLines.add(this.buildAccessContractExportValues((AccessContractDto)accessContract, exporter.getArrayJoinStr(), dateFormat));
            }
            catch (ParseException e) {
                throw new BadRequestException("Unable to parse access contract to a csv line", (Throwable)e);
            }
        });
        return ExportCSVUtils.generateCSVFile(csvLines, exporter.getSeparator());
    }

    private String[] buildAccessContractExportValues(AccessContractDto accessContract, String arrayJoinStr, DateFormat df) throws ParseException {
        String originatingAgencies = accessContract.getOriginatingAgencies() == null ? null : String.join((CharSequence)arrayJoinStr, accessContract.getOriginatingAgencies());
        String dataObjectVersions = accessContract.getDataObjectVersion() == null ? null : String.join((CharSequence)arrayJoinStr, accessContract.getDataObjectVersion());
        String rootUnits = accessContract.getRootUnits() == null ? null : String.join((CharSequence)arrayJoinStr, accessContract.getRootUnits());
        String excludedRootUnits = accessContract.getExcludedRootUnits() == null ? null : String.join((CharSequence)arrayJoinStr, accessContract.getExcludedRootUnits());
        String ruleCategoryToFilter = StringUtils.join((Iterable)accessContract.getRuleCategoryToFilter(), (String)arrayJoinStr);
        String ruleCategoryToFilterForTheOtherOriginatingAgencies = StringUtils.join((Iterable)accessContract.getRuleCategoryToFilterForTheOtherOriginatingAgencies(), (String)arrayJoinStr);
        String creationDate = accessContract.getCreationDate() == null ? null : df.format(LocalDateUtil.getDate((String)accessContract.getCreationDate()));
        String lastUpdateDate = accessContract.getLastUpdate() == null ? null : df.format(LocalDateUtil.getDate((String)accessContract.getLastUpdate()));
        String activationDate = accessContract.getActivationDate() == null ? null : df.format(LocalDateUtil.getDate((String)accessContract.getActivationDate()));
        String deactivationDate = accessContract.getDeactivationDate() == null ? null : df.format(LocalDateUtil.getDate((String)accessContract.getDeactivationDate()));
        String doNotFilterFilingSchemes = accessContract.getDoNotFilterFilingSchemes() == null ? "false" : accessContract.getDoNotFilterFilingSchemes().toString();
        return new String[]{accessContract.getIdentifier(), accessContract.getName(), accessContract.getDescription(), accessContract.getStatus().name(), accessContract.getWritingPermission().toString(), accessContract.getEveryOriginatingAgency().toString(), originatingAgencies, accessContract.getEveryDataObjectVersion().toString(), dataObjectVersions, rootUnits, excludedRootUnits, accessContract.getAccessLog().name(), ruleCategoryToFilter, accessContract.getWritingRestrictedDesc().toString(), ruleCategoryToFilterForTheOtherOriginatingAgencies, doNotFilterFilingSchemes, creationDate, lastUpdateDate, activationDate, deactivationDate};
    }
}

