/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalNotFoundException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.referential.common.dto.ProfileDto;
import fr.gouv.vitamui.referential.server.service.profile.ProfileService;
import jakarta.validation.Valid;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/profile"})
public class ProfileController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileController.class);
    @Autowired
    private ProfileService profileService;

    @GetMapping
    @Secured(value={"ROLE_GET_ARCHIVE_PROFILES"})
    public Collection<ProfileDto> getAll(@RequestParam Optional<String> criteria) {
        LOGGER.debug("get all profile criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        return this.profileService.getAll(criteria);
    }

    @Secured(value={"ROLE_GET_ARCHIVE_PROFILES"})
    @GetMapping(value={"/paginated"}, params={"page", "size"})
    public PaginatedValuesDto<ProfileDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.profileService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_ARCHIVE_PROFILES"})
    @GetMapping(path={"/{identifier:.+}"})
    public ProfileDto getOne(@PathVariable(value="identifier") String identifier) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{identifier});
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("get profile identifier={}");
        return this.profileService.getOne(identifier);
    }

    @GetMapping(value={"/download/{id}"})
    public ResponseEntity<Resource> download(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException, AccessExternalNotFoundException, AccessExternalClientException {
        ParameterChecker.checkParameter((String)"Event Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("download profile with id :{}", (Object)id);
        return this.profileService.download(id);
    }

    @Secured(value={"ROLE_CREATE_ARCHIVE_PROFILES"})
    @PutMapping(value={"/updateProfileFile/{id}"})
    public ResponseEntity<JsonNode> importProfileFile(@PathVariable(value="id") String id, @RequestParam MultipartFile file) throws IOException, InvalidParseOperationException, PreconditionFailedException, AccessExternalClientException {
        ParameterChecker.checkParameter((String)"profileFile stream is a mandatory parameter: ", (Object[])new Object[]{file});
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
        LOGGER.debug("Update {}  profile file with id :{}", (Object)id);
        LOGGER.debug("Import profile file {}", (Object)file);
        return this.profileService.updateProfileFile(id, file);
    }

    @Secured(value={"ROLE_CREATE_ARCHIVE_PROFILES"})
    @PutMapping(value={"/{id}"})
    public ResponseEntity<JsonNode> update(@PathVariable(value="id") String id, @Valid @RequestBody ProfileDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)id);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"Unable to update profile : the DTO id must match the path id");
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        return this.profileService.updateProfile(dto);
    }

    @Secured(value={"ROLE_UPDATE_ARCHIVE_PROFILES"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public ProfileDto create(@Valid @RequestBody ProfileDto profileDto) throws InvalidParseOperationException, PreconditionFailedException, VitamClientException {
        ApiUtils.checkValidity((Object)profileDto);
        SanityChecker.sanitizeCriteria((Object)profileDto);
        LOGGER.debug("Create {}", (Object)profileDto);
        return this.profileService.create(profileDto);
    }

    @Secured(value={"ROLE_DELETE_ARCHIVE_PROFILES"})
    @PostMapping(value={"/import"})
    public ResponseEntity<JsonNode> importArchivalProfiles(@RequestParam String fileName, @RequestParam MultipartFile file) {
        ParameterChecker.checkParameter((String)"The fileName is mandatory parameter :", (String[])new String[]{fileName});
        SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
        LOGGER.debug("Import file archivalProfile {}", (Object)fileName);
        return this.profileService.importProfiles(fileName, file);
    }

    @Secured(value={"ROLE_GET_ARCHIVE_PROFILES"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> check(@RequestBody ProfileDto profileDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)profileDto);
        boolean exist = this.profileService.check(profileDto);
        LOGGER.debug("check exist accessContract={}", (Object)profileDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_CREATE_ARCHIVE_PROFILES"})
    public ProfileDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        return this.profileService.patch(partialDto);
    }

    @Generated
    public ProfileService getProfileService() {
        return this.profileService;
    }

    @Generated
    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }
}

