/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.vitam.api.dto.CancelOperationRequestDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ProcessDetailDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUIProcessDetailResponseDto;
import fr.gouv.vitamui.referential.server.service.logbookmanagement.LogbookManagementOperationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/referential/v1/logbook-management-operation"})
@RestController
public class LogbookManagementOperationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogbookManagementOperationController.class);
    private final LogbookManagementOperationService logbookManagementOperationService;

    public LogbookManagementOperationController(LogbookManagementOperationService logbookManagementOperationService) {
        this.logbookManagementOperationService = logbookManagementOperationService;
    }

    @PostMapping(value={"/operations"})
    @Secured(value={"ROLE_GET_ALL_LOGBOOK_OPERATION"})
    public VitamUIProcessDetailResponseDto searchOperationsDetails(@RequestBody ProcessQuery processQuery) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)processQuery);
        LOGGER.debug("All Operations details by Criteria={}", (Object)processQuery);
        VitamUIProcessDetailResponseDto operationResponseDto = new VitamUIProcessDetailResponseDto();
        ProcessDetailDto processDetailDto = this.logbookManagementOperationService.searchOperationsDetails(processQuery);
        if (processDetailDto != null) {
            operationResponseDto = processDetailDto.getOperations();
        }
        return operationResponseDto;
    }

    @PostMapping(value={"/operations/cancel/{id}"})
    @Secured(value={"ROLE_UPDATE_LOGBOOK_OPERATION"})
    public VitamUIProcessDetailResponseDto cancelOperationProcessExecution(@PathVariable(value="id") String operationId, @RequestBody CancelOperationRequestDto request) throws InvalidParseOperationException, PreconditionFailedException {
        ProcessDetailDto processDetailDto;
        SanityChecker.checkSecureParameter((String[])new String[]{operationId});
        LOGGER.debug("Cancel the operation with id={}", (Object)operationId);
        ParameterChecker.checkParameter((String)"operationId is mandatory : ", (String[])new String[]{operationId});
        VitamUIProcessDetailResponseDto operationResponseDto = new VitamUIProcessDetailResponseDto();
        if (!request.isStepCancellable()) {
            LOGGER.warn("Forced cancellation of operation {} with the following reason: {}", (Object)operationId, (Object)request.getReason());
        }
        if ((processDetailDto = this.logbookManagementOperationService.cancelOperationProcessExecution(operationId)) != null) {
            operationResponseDto = processDetailDto.getOperations();
        }
        return operationResponseDto;
    }

    @PostMapping(value={"/operations/update/{id}"})
    @Secured(value={"ROLE_UPDATE_LOGBOOK_OPERATION"})
    public VitamUIProcessDetailResponseDto updateOperationActionProcess(@PathVariable(value="id") String operationId, @RequestBody String actionId) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{operationId, actionId});
        LOGGER.debug("Update the operation id={} with actionId={}", (Object)operationId, (Object)actionId);
        VitamUIProcessDetailResponseDto operationResponseDto = new VitamUIProcessDetailResponseDto();
        ProcessDetailDto processDetailDto = this.logbookManagementOperationService.updateOperationActionProcess(actionId, operationId);
        if (processDetailDto != null) {
            operationResponseDto = processDetailDto.getOperations();
        }
        return operationResponseDto;
    }
}

