/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.referential.common.dto.ExternalAgencyDto;
import fr.gouv.vitamui.referential.common.dto.ExternalIngestContractDto;
import fr.gouv.vitamui.referential.common.dto.ExternalProfileDto;
import fr.gouv.vitamui.referential.common.dto.ExternalReferentialConfigDto;
import fr.gouv.vitamui.referential.server.service.externalreferential.ExternalReferentialService;
import java.util.Collection;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referential/v1/external-referential/"})
public class ExternalReferentialController {
    private final ExternalReferentialService externalReferentialService;

    @Autowired
    public ExternalReferentialController(ExternalReferentialService externalReferentialService) {
        this.externalReferentialService = externalReferentialService;
    }

    @GetMapping(value={"/config"})
    @Secured(value={"ROLE_GET_EXTERNAL_REFERENTIAL_CONFIG"})
    public Collection<ExternalReferentialConfigDto> listExternalReferentialConfig() {
        return this.externalReferentialService.listExternalReferentialConfig();
    }

    @GetMapping(value={"/agencies"}, params={"archivingSystemId", "tenantIdentifier"})
    @Secured(value={"ROLE_GET_EXTERNAL_REFERENTIAL_AGENCIES"})
    public Collection<ExternalAgencyDto> listAgencies(@RequestParam(value="archivingSystemId") String archivingSystemId, @RequestParam(value="tenantIdentifier") Integer tenantIdentifier) {
        ParameterChecker.checkParameter((String)"archivingSystemId is mandatory: ", (String[])new String[]{archivingSystemId});
        ParameterChecker.checkParameter((String)"tenantIdentifier is mandatory: ", (Object[])new Object[]{tenantIdentifier});
        return this.externalReferentialService.listAgencies(archivingSystemId, tenantIdentifier);
    }

    @GetMapping(value={"/ingestcontracts"}, params={"archivingSystemId", "tenantIdentifier"})
    @Secured(value={"ROLE_GET_EXTERNAL_REFERENTIAL_INGEST_CONTRACTS"})
    public Collection<ExternalIngestContractDto> listIngestContracts(@RequestParam(value="archivingSystemId") String archivingSystemId, @RequestParam(value="tenantIdentifier") Integer tenantIdentifier) {
        ParameterChecker.checkParameter((String)"archivingSystemId is mandatory: ", (String[])new String[]{archivingSystemId});
        ParameterChecker.checkParameter((String)"tenantIdentifier is mandatory: ", (Object[])new Object[]{tenantIdentifier});
        return this.externalReferentialService.listIngestContracts(archivingSystemId, tenantIdentifier);
    }

    @GetMapping(value={"/profiles"}, params={"archivingSystemId", "tenantIdentifier"})
    @Secured(value={"ROLE_GET_EXTERNAL_REFERENTIAL_ARCHIVE_PROFILES"})
    public Collection<ExternalProfileDto> listProfiles(@RequestParam(value="archivingSystemId") String archivingSystemId, @RequestParam(value="tenantIdentifier") Integer tenantIdentifier) {
        ParameterChecker.checkParameter((String)"archivingSystemId is mandatory: ", (String[])new String[]{archivingSystemId});
        ParameterChecker.checkParameter((String)"tenantIdentifier is mandatory: ", (Object[])new Object[]{tenantIdentifier});
        return this.externalReferentialService.listArchiveProfiles(archivingSystemId, tenantIdentifier);
    }

    @Generated
    public ExternalReferentialService getExternalReferentialService() {
        return this.externalReferentialService;
    }
}

