/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.referential.common.dto.ContextDto;
import fr.gouv.vitamui.referential.server.service.context.ContextService;
import jakarta.validation.Valid;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referential/v1/context"})
public class ContextController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextController.class);
    @Autowired
    private ContextService contextService;

    @GetMapping
    @Secured(value={"ROLE_GET_CONTEXTS"})
    public Collection<ContextDto> getAll(Optional<String> criteria) {
        LOGGER.debug("get all context criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        return this.contextService.getAll();
    }

    @Secured(value={"ROLE_GET_CONTEXTS"})
    @GetMapping(value={"/paginated"}, params={"page", "size"})
    public PaginatedValuesDto<ContextDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        SanityChecker.sanitizeCriteria(criteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.contextService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_CONTEXTS"})
    @GetMapping(path={"/{identifier:.+}"})
    public ContextDto getOne(@PathVariable(value="identifier") String identifier) {
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("get context identifier={}");
        return this.contextService.getOne(identifier);
    }

    @Secured(value={"ROLE_GET_CONTEXTS"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> check(@Valid @RequestBody ContextDto contextDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        LOGGER.debug("check exist context = {}", (Object)contextDto);
        SanityChecker.sanitizeCriteria((Object)contextDto);
        ApiUtils.checkValidity((Object)contextDto);
        boolean exist = this.contextService.check(contextDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Secured(value={"ROLE_CREATE_CONTEXTS"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public ContextDto create(@Valid @RequestBody ContextDto contextDto) {
        SanityChecker.sanitizeCriteria((Object)contextDto);
        LOGGER.debug("Create {}", (Object)contextDto);
        return this.contextService.create(contextDto);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_CONTEXTS"})
    public ContextDto patch(@PathVariable(value="id") String id, @RequestBody ContextDto partialDto) {
        SanityChecker.sanitizeCriteria((Object)partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, (Object)partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)partialDto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return this.contextService.patch(partialDto);
    }

    @Secured(value={"ROLE_GET_CONTEXTS"})
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws VitamClientException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for context with id :{}", (Object)id);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        return this.contextService.findHistoryById(id);
    }

    @Generated
    public ContextService getContextService() {
        return this.contextService;
    }

    @Generated
    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }
}

