/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitamui.commons.api.application.AbstractContextConfiguration;
import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.vitam.api.access.UnitCommonService;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyCommonService;
import fr.gouv.vitamui.commons.vitam.api.administration.VitamOperationCommonService;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAccessConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAdministrationConfig;
import fr.gouv.vitamui.iam.openapiclient.ApplicationsApi;
import fr.gouv.vitamui.iam.openapiclient.ExternalParametersApi;
import fr.gouv.vitamui.iam.openapiclient.IamApiClientsFactory;
import fr.gouv.vitamui.iam.openapiclient.UsersApi;
import fr.gouv.vitamui.iam.security.provider.ApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.InternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.service.IamClientUserAuthenticationService;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import fr.gouv.vitamui.referential.common.service.AccessionRegisterCommonService;
import fr.gouv.vitamui.referential.common.service.ImportSchemaCommonService;
import fr.gouv.vitamui.referential.common.service.IngestContractCommonService;
import fr.gouv.vitamui.referential.common.service.OntologyCommonService;
import fr.gouv.vitamui.referential.common.service.OperationCommonService;
import fr.gouv.vitamui.referential.common.service.VitamAgencyCommonService;
import fr.gouv.vitamui.referential.common.service.VitamArchivalProfileUnitCommonService;
import fr.gouv.vitamui.referential.common.service.VitamBatchReportCommonService;
import fr.gouv.vitamui.referential.common.service.VitamContextCommonService;
import fr.gouv.vitamui.referential.common.service.VitamFileFormatCommonService;
import fr.gouv.vitamui.referential.common.service.VitamRuleCommonService;
import fr.gouv.vitamui.referential.common.service.VitamSecurityProfileCommonService;
import fr.gouv.vitamui.referential.common.service.VitamUIAccessContractCommonService;
import fr.gouv.vitamui.referential.common.service.VitamUIManagementContractCommonService;
import fr.gouv.vitamui.referential.server.config.ApiReferentialApplicationProperties;
import fr.gouv.vitamui.referential.server.config.ConverterConfig;
import fr.gouv.vitamui.referential.server.security.WebSecurityConfig;
import fr.gouv.vitamui.security.openapiclient.ContextsApi;
import fr.gouv.vitamui.security.openapiclient.SecurityApiClientsFactory;
import jakarta.servlet.Filter;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.MultipartFilter;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

@Configuration
@Import(value={RestExceptionHandler.class, HttpMessageConvertersAutoConfiguration.class, WebSecurityConfig.class, VitamAccessConfig.class, VitamAdministrationConfig.class, ConverterConfig.class})
public class ApiReferentialServerConfig
extends AbstractContextConfiguration {
    @Bean
    public MultipartResolver multipartResolver() {
        return new StandardServletMultipartResolver();
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        MultipartFilter multipartFilter = new MultipartFilter();
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)multipartFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.addInitParameter("multipartResolverBeanName", "commonsMultipartResolver");
        return filterRegistrationBean;
    }

    @Bean
    public SecurityApiClientsFactory securityApiClientsFactory(ApiReferentialApplicationProperties apiReferentialApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new SecurityApiClientsFactory(apiReferentialApplicationProperties.getSecurityClient(), restTemplateBuilder);
    }

    @Bean
    public ContextsApi contextsApi(SecurityApiClientsFactory securityApiClientsFactory) {
        return securityApiClientsFactory.getContextsApi();
    }

    @Bean
    public SecurityService securityService() {
        return new SecurityService();
    }

    @Bean
    public VitamUIAccessContractCommonService vitamUIAccessContractCommonService(AdminExternalClient adminExternalClient) {
        return new VitamUIAccessContractCommonService(adminExternalClient);
    }

    @Bean
    public AccessionRegisterCommonService accessionRegisterCommonService(AdminExternalClient adminExternalClient) {
        return new AccessionRegisterCommonService(adminExternalClient);
    }

    @Bean
    public VitamAgencyCommonService vitamAgencyCommonService(AdminExternalClient adminClient, AgencyCommonService agencyCommonService, ObjectMapper objectMapper, AccessExternalClient accessClient) {
        return new VitamAgencyCommonService(adminClient, agencyCommonService, objectMapper, accessClient);
    }

    @Bean
    public VitamArchivalProfileUnitCommonService vitamArchivalProfileUnitCommonService(AdminExternalClient adminClient, ObjectMapper objectMapper, AccessExternalClient accessClient) {
        return new VitamArchivalProfileUnitCommonService(adminClient, objectMapper, accessClient);
    }

    @Bean
    public VitamContextCommonService vitamContextCommonService(AdminExternalClient adminClient, ObjectMapper objectMapper) {
        return new VitamContextCommonService(adminClient, objectMapper);
    }

    @Bean
    public VitamFileFormatCommonService vitamFileFormatCommonService(AdminExternalClient adminClient, ObjectMapper objectMapper, AccessExternalClient accessClient) {
        return new VitamFileFormatCommonService(adminClient, objectMapper, accessClient);
    }

    @Bean
    public VitamUIManagementContractCommonService vitamUIManagementContractCommonService(AdminExternalClient adminClient) {
        return new VitamUIManagementContractCommonService(adminClient);
    }

    @Bean
    public OntologyCommonService ontologyCommonService(AdminExternalClient adminExternalClient) {
        return new OntologyCommonService(adminExternalClient);
    }

    @Bean
    public OperationCommonService operationCommonService(AdminExternalClient adminExternalClient) {
        return new OperationCommonService(adminExternalClient);
    }

    @Bean
    public VitamRuleCommonService vitamRuleCommonService(AdminExternalClient adminClient, ObjectMapper objectMapper, AccessExternalClient accessClient) {
        return new VitamRuleCommonService(adminClient, objectMapper, accessClient);
    }

    @Bean
    public VitamSecurityProfileCommonService vitamSecurityProfileCommonService(AdminExternalClient adminClient, ObjectMapper objectMapper) {
        return new VitamSecurityProfileCommonService(adminClient, objectMapper);
    }

    @Bean
    public IngestContractCommonService ingestContractCommonService(AdminExternalClient adminExternalClient) {
        return new IngestContractCommonService(adminExternalClient);
    }

    @Bean
    public VitamBatchReportCommonService vitamBatchReportCommonService(AdminExternalClient adminExternalClient) {
        return new VitamBatchReportCommonService(adminExternalClient);
    }

    @Bean
    public IamApiClientsFactory iamApiClientsFactory(ApiReferentialApplicationProperties apiReferentialApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new IamApiClientsFactory(apiReferentialApplicationProperties.getIamClient(), restTemplateBuilder);
    }

    @Bean
    public ApplicationsApi applicationsApi(IamApiClientsFactory iamApiClientsFactory) {
        return iamApiClientsFactory.getApplicationsApi();
    }

    @Bean
    public UnitCommonService unitCommonService(AccessExternalClient client) {
        return new UnitCommonService(client);
    }

    @Bean
    public VitamOperationCommonService vitamOperationCommonService(AdminExternalClient adminExternalClient) {
        return new VitamOperationCommonService(adminExternalClient);
    }

    @Bean
    public ExternalParametersApi externalParametersApi(IamApiClientsFactory iamApiClientsFactory) {
        return iamApiClientsFactory.getExternalParametersApi();
    }

    @Bean
    public UsersApi usersApi(IamApiClientsFactory iamApiClientsFactory) {
        return iamApiClientsFactory.getUsersApi();
    }

    @Bean
    public UserAuthenticationService authentificationService(UsersApi usersApi) {
        return new IamClientUserAuthenticationService(usersApi);
    }

    @Bean
    public ApiAuthenticationProvider apiAuthenticationProvider(UserAuthenticationService userAuthenticationService, ContextsApi contextsApi) {
        return new ApiAuthenticationProvider(new InternalApiAuthenticationProvider(userAuthenticationService), new ExternalApiAuthenticationProvider(contextsApi, userAuthenticationService));
    }

    @Bean
    public ImportSchemaCommonService importSchemaCommonService(AdminExternalClient adminExternalClient) {
        return new ImportSchemaCommonService(adminExternalClient);
    }
}

