/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.client;

import fr.gouv.vitamui.commons.rest.client.BaseCrudRestClient;
import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import java.util.List;
import java.util.Objects;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

public class IdentityProviderRestClient
extends BaseCrudRestClient<IdentityProviderDto, HttpContext> {
    public IdentityProviderRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public String getPathUrl() {
        return "/iam/v1/providers";
    }

    protected Class<IdentityProviderDto> getDtoClass() {
        return IdentityProviderDto.class;
    }

    protected ParameterizedTypeReference<List<IdentityProviderDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<IdentityProviderDto>>(){};
    }

    public IdentityProviderDto create(HttpContext context, MultipartFile keystore, MultipartFile idpMetadata, String provider) {
        MultiValueMap<String, String> headers = this.buildHeaders(context);
        headers.set((Object)"Content-Type", (Object)"multipart/form-data");
        MultipartBodyBuilder bodyBuilder = new MultipartBodyBuilder();
        if (Objects.nonNull(keystore)) {
            bodyBuilder.part("keystore", (Object)keystore.getResource());
        }
        if (Objects.nonNull(idpMetadata)) {
            bodyBuilder.part("idpMetadata", (Object)idpMetadata.getResource());
        }
        bodyBuilder.part("provider", (Object)provider);
        HttpEntity request = new HttpEntity((Object)bodyBuilder.build(), headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl(), HttpMethod.POST, request, this.getDtoClass(), new Object[0]);
        this.checkResponse(response, new Integer[]{200, 201});
        return (IdentityProviderDto)response.getBody();
    }

    protected MultiValueMap<String, String> buildHeaders(HttpContext context) {
        MultiValueMap headers = super.buildHeaders(context);
        headers.set((Object)"X-Origin", (Object)"EXTERNAL");
        return headers;
    }
}

