/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.util;

import fr.gouv.vitamui.pastis.common.dto.ElementRNG;
import java.util.Arrays;
import java.util.Optional;
import java.util.Stack;
import lombok.Generated;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class PastisSAX2Handler
extends DefaultHandler {
    private ElementRNG elementRNGRoot;
    private String sedaVersion;
    private boolean isValue;
    private final Stack<ElementRNG> stackRNG = new Stack();
    private boolean isInDocumentationTag;
    private StringBuilder documentationContent;

    @Override
    public void startElement(String nameSpace, String localName, String qName, Attributes attr) {
        if (!"grammar".equals(localName) && !"start".equals(localName)) {
            if (null != attr.getValue("name") && attr.getValue("name").equals("ArchiveTransfer")) {
                return;
            }
            if ("value".equals(localName) || "documentation".equals(localName)) {
                this.isValue = true;
            }
            ElementRNG elementRNG = new ElementRNG();
            elementRNG.setName(attr.getValue("name"));
            elementRNG.setType(localName);
            elementRNG.setDataType(attr.getValue("type"));
            if (!this.stackRNG.isEmpty()) {
                ElementRNG e = (ElementRNG)this.stackRNG.lastElement();
                elementRNG.setParent(e);
                e.getChildren().add(elementRNG);
            }
            this.stackRNG.push(elementRNG);
        }
        this.documentationContent = new StringBuilder();
        if (qName.equalsIgnoreCase("xsd:documentation")) {
            this.isInDocumentationTag = true;
        }
        if ("grammar".equals(localName)) {
            String defaultXmlNamespace = attr.getValue("xmlns");
            String sedaXmlNamespace = attr.getValue("xmlns:seda");
            String namespace = attr.getValue("ns");
            if (this.sedaVersion == null && defaultXmlNamespace != null) {
                this.sedaVersion = Arrays.stream(defaultXmlNamespace.split(":")).reduce((first, second) -> second).orElse(null);
            }
            if (this.sedaVersion == null && sedaXmlNamespace != null) {
                this.sedaVersion = Arrays.stream(sedaXmlNamespace.split(":")).reduce((first, second) -> second).orElse(null);
            }
            if (this.sedaVersion == null && namespace != null) {
                this.sedaVersion = Arrays.stream(namespace.split(":")).reduce((first, second) -> second).orElse(null);
            }
            this.sedaVersion = Optional.ofNullable(this.sedaVersion).map(v -> v.substring(1)).orElse(null);
        }
    }

    @Override
    public void endElement(String nameSpace, String localName, String qName) {
        if (qName.equalsIgnoreCase("xsd:documentation")) {
            this.isInDocumentationTag = false;
        }
        if (!this.stackRNG.isEmpty()) {
            this.stackRNG.pop();
        }
    }

    @Override
    public void startDocument() {
        this.elementRNGRoot = new ElementRNG();
        this.elementRNGRoot.setName("ArchiveTransfer");
        this.elementRNGRoot.setType("element");
        this.stackRNG.push(this.elementRNGRoot);
    }

    @Override
    public void characters(char[] caracteres, int start, int length) {
        if (this.isInDocumentationTag) {
            this.documentationContent.append(new String(caracteres, start, length));
            ((ElementRNG)this.stackRNG.lastElement()).setValue(this.documentationContent.toString());
        }
        if (this.isValue) {
            String valueContent = new String(caracteres, start, length);
            ((ElementRNG)this.stackRNG.lastElement()).setValue(valueContent);
            this.isValue = false;
        }
    }

    @Generated
    public ElementRNG getElementRNGRoot() {
        return this.elementRNGRoot;
    }

    @Generated
    public String getSedaVersion() {
        return this.sedaVersion;
    }
}

