/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.dto.PuaData;
import fr.gouv.vitamui.pastis.common.dto.pua.PuaMetadataDetails;
import fr.gouv.vitamui.pastis.common.dto.seda.SedaNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PuaPastisValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PuaPastisValidator.class);
    public static final String CARDINALITY_0_N = "0-N";
    public static final String CARDINALITY_1 = "1";
    public static final String CARDINALITY_0_1 = "0-1";
    public static final String CARDINALITY_1_N = "1-N";
    private static JSONObject profileJsonExpected;
    private static final String CONTROLSCHEMA = "controlSchema";
    private static final String DEFINITIONS = "definitions";
    private static final String PROPERTIES = "properties";
    private static final String MANAGEMENTCONTROL = "#management";
    private static final String MANAGEMENT = "Management";
    private static final String CONTENT = "Content";
    private static final String COMPLEX = "Complex";
    public static final String REQUIRED = "required";
    private static final String SCHEMA = "$schema";
    private static final String ITEMS = "items";
    private static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    private static final String TYPE = "type";
    private static final String OBJECT = "object";
    private static final String ID = "ID";
    private static final String STRING = "string";

    private JSONObject getProfileJsonExpected(boolean standalone) {
        if (profileJsonExpected == null) {
            InputStream inputStream = standalone ? this.getClass().getClassLoader().getResourceAsStream("pua_validation/valid_pua.json") : this.getClass().getClassLoader().getResourceAsStream("pua_validation/valid_pua_vitam.json");
            assert (inputStream != null);
            JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(inputStream));
            PuaPastisValidator.setProfileJsonExpected(new JSONObject(tokener));
        }
        return profileJsonExpected;
    }

    private static void setProfileJsonExpected(JSONObject jsonObject) {
        profileJsonExpected = jsonObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validatePUA(JSONObject pua, boolean standalone) throws AssertionError {
        HashSet actualFieldList;
        JSONObject profileJson = this.getProfileJsonExpected(standalone);
        if (!(standalone || (actualFieldList = new HashSet(pua.keySet())).contains("name") || actualFieldList.contains(CONTROLSCHEMA))) {
            throw new AssertionError((Object)"Notice not contains the expected keys 'name' and 'controlSchema'");
        }
        String controlSchemaString = pua.getString(CONTROLSCHEMA);
        JSONObject controlSchemaActual = new JSONObject(controlSchemaString);
        controlSchemaString = profileJson.getString(CONTROLSCHEMA);
        JSONObject controlSchemaExpected = new JSONObject(controlSchemaString);
        LOGGER.debug(" control schema actuelle {}", (Object)controlSchemaActual);
        LOGGER.debug(" control schema Expected {}", (Object)controlSchemaExpected);
        if (standalone) {
            if (controlSchemaActual.has(ADDITIONAL_PROPERTIES) && !(controlSchemaActual.get(ADDITIONAL_PROPERTIES) instanceof Boolean)) {
                throw new AssertionError((Object)"PUA additionalProperties field does not contains a boolean value");
            }
            if (controlSchemaActual.has("patternProperties")) {
                JSONObject properties;
                JSONObject patternProperties = controlSchemaActual.getJSONObject("patternProperties");
                if (!patternProperties.has(MANAGEMENTCONTROL) || !(properties = controlSchemaActual.getJSONObject(PROPERTIES)).has(MANAGEMENTCONTROL)) return;
                throw new AssertionError((Object)"Can't have both '#management' key in header and in 'properties' object");
            }
            if (!controlSchemaActual.has(PROPERTIES)) throw new AssertionError((Object)"Missing 'properties' key in controlShema");
            JSONObject properties = controlSchemaActual.getJSONObject(PROPERTIES);
            if (properties.has(MANAGEMENTCONTROL)) return;
            throw new AssertionError((Object)"Missing '#management' key in 'properties' object");
        }
        if (controlSchemaActual.has(SCHEMA)) return;
        throw new AssertionError((Object)"Missing '$schema' key in controlSchema' object");
    }

    public JSONObject getDefinitionsFromExpectedProfile() {
        JSONObject baseProfile = this.getProfileJsonExpected(true);
        String controlSchema = baseProfile.get(CONTROLSCHEMA).toString();
        LOGGER.debug(" control schema {}", (Object)controlSchema);
        JSONObject controlSchemaAsJSON = new JSONObject(controlSchema);
        return controlSchemaAsJSON.getJSONObject(DEFINITIONS);
    }

    private String getPUAMetadataType(SedaNode sedaTree, String elementName, String name, ElementProperties elementProperties) throws IOException {
        SedaNode sedaElement = this.getSedaMetadata(sedaTree, elementName, name);
        if (sedaElement != null) {
            return this.resolvePuaType(sedaElement, elementProperties);
        }
        return elementName.equals("MessageDigest") ? STRING : "undefined";
    }

    private String resolvePuaType(SedaNode sedaElement, ElementProperties element) {
        String sedaType = sedaElement.getType();
        String sedaElementType = sedaElement.getElement();
        String sedaName = sedaElement.getName();
        String sedaCardinality = sedaElement.getCardinality();
        if (sedaName.equals("Title") || sedaName.equals("Description") || sedaName.equals("algorithm")) {
            return STRING;
        }
        if (sedaName.equals("SignedObjectDigest")) {
            return OBJECT;
        }
        if (sedaElementType.equals("Simple") && !sedaElement.getType().equals("boolean") && !sedaElement.getType().equals("integer") && (sedaCardinality.equals(CARDINALITY_0_1) || sedaCardinality.equals(CARDINALITY_1))) {
            return STRING;
        }
        if (sedaElement.getElement().equals(COMPLEX) && (sedaCardinality.equals(CARDINALITY_0_1) || sedaCardinality.equals(CARDINALITY_1))) {
            return OBJECT;
        }
        if (sedaType.equals("boolean") && (sedaCardinality.equals(CARDINALITY_0_1) || sedaCardinality.equals(CARDINALITY_1))) {
            return "boolean";
        }
        if (sedaType.equals("integer") && (sedaCardinality.equals(CARDINALITY_0_1) || sedaCardinality.equals(CARDINALITY_1))) {
            return "integer";
        }
        if (sedaCardinality.equals(CARDINALITY_1_N) || sedaCardinality.equals(CARDINALITY_0_N)) {
            return "array";
        }
        if (sedaType.equals(ID)) {
            return STRING;
        }
        return "undefined";
    }

    public JSONArray getJSONObjectFromAllTree(SedaNode sedaTree, List<ElementProperties> elementsFromTree) {
        JSONArray jsonArray = this.sortedJSONArray();
        List<String> rulesToIgnore = Arrays.asList("StorageRule", "AppraisalRule", "AccessRule", "DisseminationRule", "ReuseRule", "ClassificationRule");
        List<String> managementMetadata = Arrays.asList("LogBook", "NeedAuthorization");
        for (ElementProperties el : elementsFromTree) {
            this.setMetadataName(el);
            try {
                if (el.getName().equals(MANAGEMENT) && !el.getChildren().isEmpty()) {
                    JSONObject management = this.getJSONFromManagement(sedaTree, el);
                    jsonArray.put((Object)management);
                }
                if (jsonArray.length() > 0 && jsonArray.toString().contains(el.getName())) {
                    ElementProperties element = this.getElementById(elementsFromTree, el.getParentId());
                    if (element == null || !element.getName().equals(CONTENT)) continue;
                    JSONObject notManagementMapElement = this.getJSONObjectFromElement(sedaTree, el);
                    jsonArray.put((Object)notManagementMapElement);
                    continue;
                }
                if (rulesToIgnore.contains(el.getName()) || el.getName().equals(CONTENT) || el.getName().equals(MANAGEMENT) || managementMetadata.contains(el.getName())) continue;
                JSONObject notManagementMapElement = this.getJSONObjectFromElement(sedaTree, el);
                jsonArray.put((Object)notManagementMapElement);
            }
            catch (IOException e) {
                LOGGER.debug(e.getMessage());
            }
        }
        return jsonArray;
    }

    private JSONObject getJSONFromManagement(SedaNode sedaTree, ElementProperties element) throws IOException {
        List<String> rulesMetadata = Arrays.asList("StorageRule", "AppraisalRule", "AccessRule", "DisseminationRule", "ReuseRule", "ClassificationRule");
        List<String> childrenToEncapsulate = Arrays.asList("Rule", "StartDate");
        ArrayList<String> rulesFound = new ArrayList<String>();
        JSONObject pua = this.sortedJSON();
        if (Objects.nonNull(element.getPuaData()) && Objects.nonNull(element.getPuaData().getAdditionalProperties())) {
            pua.put(ADDITIONAL_PROPERTIES, (Object)element.getPuaData().getAdditionalProperties());
        }
        if (element.getChildren().isEmpty()) {
            return this.retrieveAccumulatedJsonManagementProperties(pua);
        }
        this.retrieveAccumalatedJsonManagaementProperties(sedaTree, element, rulesMetadata, childrenToEncapsulate, rulesFound, pua);
        List<String> requiredProperties = this.getRequiredProperties(sedaTree, element);
        if (CollectionUtils.isNotEmpty(requiredProperties)) {
            pua.put(REQUIRED, requiredProperties);
        }
        return this.retrieveAccumulatedJsonManagementProperties(pua);
    }

    private void retrieveAccumalatedJsonManagaementProperties(SedaNode sedaTree, ElementProperties element, List<String> rulesMetadata, List<String> childrenToEncapsulate, List<String> rulesFound, JSONObject pua) throws IOException {
        for (ElementProperties childElement : element.getChildren()) {
            JSONObject childrenOfRule = this.sortedJSON();
            JSONObject grandChildrenOfRule = this.sortedJSON();
            JSONObject propertiesRules = this.sortedJSON();
            PuaMetadataDetails endDateDetails = new PuaMetadataDetails();
            endDateDetails.setType(STRING);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            grandChildrenOfRule.put("EndDate", (Object)new JSONObject(mapper.writeValueAsString((Object)endDateDetails)));
            PuaMetadataDetails ruleTypeMetadataDetails = new PuaMetadataDetails();
            SedaNode sedaElement = this.getSedaMetadata(sedaTree, childElement.getName(), null);
            if (this.checkSpecialCases(rulesMetadata, rulesFound, childElement, sedaElement)) {
                JSONObject jsonObjectFromElement = this.getJSONObjectFromElement(sedaTree, childElement);
                pua.accumulate(PROPERTIES, (Object)jsonObjectFromElement);
                continue;
            }
            this.getMetaDataFromSeda(childElement, ruleTypeMetadataDetails, sedaElement);
            HashMap<String, PuaMetadataDetails> ruleTypeMetadataMap = new HashMap<String, PuaMetadataDetails>();
            HashMap<String, PuaMetadataDetails> nonSpecialChildOfRule = new HashMap<String, PuaMetadataDetails>();
            ArrayList<String> requiredNonSpecialChildren = new ArrayList<String>();
            ArrayList<String> requiredChildren = new ArrayList<String>();
            if (!childElement.getChildren().isEmpty()) {
                for (ElementProperties grandChild : childElement.getChildren()) {
                    SedaNode node = this.getSedaMetadata(sedaTree, grandChild.getName(), childElement.getName());
                    if (childrenToEncapsulate.contains(grandChild.getName())) {
                        this.childrenContainsGrandChildName(grandChildrenOfRule, ruleTypeMetadataDetails, requiredChildren, grandChild, node);
                    } else {
                        PuaMetadataDetails nonSpecialChildOfRuleDetails = new PuaMetadataDetails();
                        this.getMetaDataFromSeda(grandChild, nonSpecialChildOfRuleDetails, node);
                        nonSpecialChildOfRule.put(grandChild.getName(), nonSpecialChildOfRuleDetails);
                        if (grandChild.getCardinality().equals(CARDINALITY_1)) {
                            requiredNonSpecialChildren.add(grandChild.getName());
                        }
                    }
                    ruleTypeMetadataMap.put(childElement.getName(), ruleTypeMetadataDetails);
                }
            }
            this.putChildrenIntoRules(childrenOfRule, grandChildrenOfRule, propertiesRules, requiredChildren);
            ObjectMapper mapper2 = new ObjectMapper();
            mapper2.registerModule((Module)new AfterburnerModule());
            JSONObject ruleTypeMetadata = new JSONObject(ruleTypeMetadataMap);
            ruleTypeMetadata.getJSONObject(childElement.getName()).put(PROPERTIES, (Object)propertiesRules);
            this.putRequiredNonSpecialChildren(childElement, requiredNonSpecialChildren, ruleTypeMetadata, requiredChildren);
            for (Map.Entry entry : nonSpecialChildOfRule.entrySet()) {
                PuaMetadataDetails details = (PuaMetadataDetails)entry.getValue();
                if (((String)entry.getKey()).equals("PreventInheritance") || ((String)entry.getKey()).equals("PreventRulesId")) {
                    String cardinality;
                    JSONObject inheritance = new JSONObject();
                    PuaMetadataDetails preventRulesId = new PuaMetadataDetails();
                    if (((String)entry.getKey()).equals("PreventInheritance")) {
                        preventRulesId.setType("boolean");
                    } else {
                        preventRulesId.setType("array");
                    }
                    Optional<ElementProperties> elOpt = childElement.getChildren().stream().filter(e -> e.getName().equals(entry.getKey())).findFirst();
                    if (elOpt.isPresent()) {
                        ElementProperties el = elOpt.get();
                        preventRulesId.setDescription(el.getDocumentation());
                        if (el.getCardinality().equals(CARDINALITY_0_1)) {
                            this.getMinAndMaxItems(el, preventRulesId);
                        } else if (el.getCardinality().equals(CARDINALITY_1)) {
                            this.getMinAndMaxItems(el, preventRulesId);
                        }
                        if (null != el.getPuaData()) {
                            if (null != el.getPuaData().getPattern()) {
                                preventRulesId.setPattern(el.getPuaData().getPattern());
                            }
                            if (null != el.getPuaData().getEnum()) {
                                preventRulesId.setEnums(el.getPuaData().getEnum());
                            }
                        }
                    }
                    inheritance.put(TYPE, (Object)OBJECT).put(ADDITIONAL_PROPERTIES, false).put(PROPERTIES, (Object)new JSONObject().put((String)entry.getKey(), (Object)new JSONObject(details.serialiseString())).put((String)entry.getKey(), (Object)new JSONObject(preventRulesId.serialiseString())));
                    if (!childElement.getChildren().isEmpty() && (cardinality = childElement.getChildren().stream().filter(e -> e.getName().equals("PreventInheritance")).map(ElementProperties::getCardinality).collect(Collectors.joining())).equals(CARDINALITY_1)) {
                        inheritance.accumulate(REQUIRED, Arrays.asList((String)entry.getKey()));
                    }
                    ruleTypeMetadata.getJSONObject(childElement.getName()).getJSONObject(PROPERTIES).put("Inheritance", (Object)inheritance);
                    continue;
                }
                ruleTypeMetadata.getJSONObject(childElement.getName()).getJSONObject(PROPERTIES).put((String)entry.getKey(), (Object)new JSONObject(details.serialiseString()));
            }
            pua.accumulate(PROPERTIES, (Object)ruleTypeMetadata);
            if (rulesFound.isEmpty()) continue;
            pua.put(REQUIRED, rulesFound);
        }
    }

    private boolean checkSpecialCases(List<String> rulesMetadata, List<String> rulesFound, ElementProperties childElement, SedaNode sedaElement) {
        if (!rulesMetadata.contains(childElement.getName()) || sedaElement == null) {
            return true;
        }
        if (childElement.getCardinality().equals(CARDINALITY_1) && sedaElement.getElement().equals(COMPLEX)) {
            rulesFound.add(childElement.getName());
        }
        return false;
    }

    private void putRequiredNonSpecialChildren(ElementProperties childElement, List<String> requiredNonSpecialChildren, JSONObject ruleTypeMetadata, List<String> requiredChildren) {
        if (!requiredNonSpecialChildren.isEmpty()) {
            requiredNonSpecialChildren.removeIf(e -> e.equals("PreventInheritance"));
        }
        if (!childElement.getChildren().isEmpty() && childElement.getChildren().stream().anyMatch(e -> e.getName().equals("PreventInheritance")) && ((ElementProperties)childElement.getChildren().stream().filter(e -> e.getName().equals("PreventInheritance")).collect(Collectors.toList()).get(0)).getCardinality().equals(CARDINALITY_1)) {
            requiredNonSpecialChildren.add("Inheritance");
        }
        if (!requiredChildren.isEmpty()) {
            requiredNonSpecialChildren.add("Rules");
        }
        if (!requiredNonSpecialChildren.isEmpty()) {
            ruleTypeMetadata.getJSONObject(childElement.getName()).put(REQUIRED, requiredNonSpecialChildren);
        }
    }

    private void putChildrenIntoRules(JSONObject childrenOfRule, JSONObject grandChildrenOfRule, JSONObject propertiesRules, List<String> requiredChildren) {
        if (!grandChildrenOfRule.isEmpty()) {
            JSONObject propretyOfItems = new JSONObject().put(TYPE, (Object)OBJECT);
            propretyOfItems.put(ADDITIONAL_PROPERTIES, false);
            propretyOfItems.put(PROPERTIES, (Object)grandChildrenOfRule);
            if (requiredChildren.isEmpty()) {
                childrenOfRule.put("maxItems", 1);
            } else {
                childrenOfRule.put("minItems", 1);
                childrenOfRule.put("maxItems", 1);
                propretyOfItems.put(REQUIRED, requiredChildren);
            }
            childrenOfRule.put(TYPE, (Object)"array");
            childrenOfRule.put(ITEMS, (Object)propretyOfItems);
            propertiesRules.put("Rules", (Object)childrenOfRule);
        }
    }

    private void childrenContainsGrandChildName(JSONObject grandChildrenOfRule, PuaMetadataDetails ruleTypeMetadataDetails, List<String> requiredChildren, ElementProperties grandChild, SedaNode node) throws JsonProcessingException {
        PuaMetadataDetails childOfRuleDetails = new PuaMetadataDetails();
        this.getMetaDataFromSeda(grandChild, childOfRuleDetails, node);
        if (grandChild.getCardinality().startsWith(CARDINALITY_1)) {
            requiredChildren.add(grandChild.getName());
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JSONObject childProperties = new JSONObject(mapper.writeValueAsString((Object)childOfRuleDetails));
        grandChildrenOfRule.put(grandChild.getName(), (Object)childProperties);
        ruleTypeMetadataDetails.setProperties(grandChildrenOfRule);
    }

    private JSONObject retrieveAccumulatedJsonManagementProperties(JSONObject pua) {
        JSONObject managementAsJSONObject = new JSONObject();
        if (pua.keySet().contains(PROPERTIES)) {
            JSONObject properties = pua;
            try {
                JSONArray accumulatedProperties = pua.getJSONArray(PROPERTIES);
                String propertiesAsString = accumulatedProperties.toString().substring(1, accumulatedProperties.toString().length() - 1).replaceAll("(},\\{)", ",");
                properties = new JSONObject(propertiesAsString);
                JSONObject propertiesRequiredJson = new JSONObject();
                propertiesRequiredJson.put(PROPERTIES, (Object)properties);
                if (pua.keySet().contains(REQUIRED)) {
                    propertiesRequiredJson.put(REQUIRED, (Object)pua.getJSONArray(REQUIRED));
                }
                managementAsJSONObject.put(MANAGEMENTCONTROL, (Object)propertiesRequiredJson);
            }
            catch (JSONException e) {
                LOGGER.debug(e.getMessage());
                managementAsJSONObject.put(MANAGEMENTCONTROL, (Object)pua);
            }
        } else {
            managementAsJSONObject.put(MANAGEMENTCONTROL, (Object)pua);
        }
        return managementAsJSONObject;
    }

    private SedaNode getSedaMetadata(SedaNode sedaTree, String elementName, String parentName) throws IOException {
        SedaNode result = null != parentName ? ((SedaNode)sedaTree.flattened().filter(childName -> childName.getName().equals(parentName)).findAny().orElse(null)).getChild(elementName) : (SedaNode)sedaTree.flattened().filter(e -> e.getName().equals(elementName)).findAny().orElse(null);
        return result;
    }

    public JSONObject sortedJSON() {
        JSONObject jsonObj = new JSONObject();
        try {
            Field changeMap = jsonObj.getClass().getDeclaredField("map");
            changeMap.setAccessible(true);
            changeMap.set(jsonObj, new LinkedHashMap());
            changeMap.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.debug(e.getMessage());
        }
        return jsonObj;
    }

    public ElementProperties getManagementElementProperties(ElementProperties elementProperties) {
        return elementProperties.getChildren().get(0).getChildren().stream().filter(e -> MANAGEMENT.equals(e.getName())).findFirst().orElse(null);
    }

    private JSONObject getJSONObjectFromElement(SedaNode sedaTree, ElementProperties elementProperties) throws IOException {
        List<String> requiredProperties;
        SedaNode sedaElement = this.getSedaMetadata(sedaTree, elementProperties.getName(), null);
        PuaMetadataDetails puaMetadataDetails = new PuaMetadataDetails();
        this.getMetaDataFromSeda(elementProperties, puaMetadataDetails, sedaElement);
        if (CollectionUtils.isNotEmpty(elementProperties.getChildren()) && CollectionUtils.isNotEmpty(requiredProperties = this.getRequiredProperties(sedaTree, elementProperties))) {
            puaMetadataDetails.setRequired(requiredProperties);
        }
        JSONObject json = new JSONObject();
        json.put(elementProperties.getName(), (Object)new JSONObject(puaMetadataDetails.serialiseString()));
        if (!elementProperties.getChildren().isEmpty()) {
            if (puaMetadataDetails.getType().equals("array")) {
                JSONObject items = new JSONObject();
                items.put(TYPE, (Object)OBJECT);
                items.put(ADDITIONAL_PROPERTIES, (Object)elementProperties.getPuaData().getAdditionalProperties());
                if (null != json.getJSONObject(elementProperties.getName()).opt(REQUIRED)) {
                    json.getJSONObject(elementProperties.getName()).remove(REQUIRED);
                }
                json.getJSONObject(elementProperties.getName()).put(ITEMS, (Object)items);
                json.getJSONObject(elementProperties.getName()).remove(ADDITIONAL_PROPERTIES);
                json.getJSONObject(elementProperties.getName()).getJSONObject(ITEMS).put(PROPERTIES, (Object)new JSONObject());
                if (null != puaMetadataDetails.getRequired() && !puaMetadataDetails.getRequired().isEmpty()) {
                    json.getJSONObject(elementProperties.getName()).getJSONObject(ITEMS).put(REQUIRED, puaMetadataDetails.getRequired());
                }
                this.getJSONObjectFromElement(sedaTree, elementProperties, json.getJSONObject(elementProperties.getName()).getJSONObject(ITEMS).getJSONObject(PROPERTIES));
            } else {
                json.getJSONObject(elementProperties.getName()).put(PROPERTIES, (Object)new JSONObject());
                this.getJSONObjectFromElement(sedaTree, elementProperties, json.getJSONObject(elementProperties.getName()).getJSONObject(PROPERTIES));
            }
        }
        return json;
    }

    private void getJSONObjectFromElement(SedaNode sedaTree, ElementProperties elementProperties, JSONObject json) throws IOException {
        if (!elementProperties.getChildren().isEmpty()) {
            for (ElementProperties el : elementProperties.getChildren()) {
                JSONObject items;
                List<String> requiredProperties;
                PuaMetadataDetails puaMetadataDetails = new PuaMetadataDetails();
                puaMetadataDetails.setType(this.getPUAMetadataType(sedaTree, el.getName(), elementProperties.getName(), el));
                puaMetadataDetails.setDescription(el.getDocumentation());
                if (null != el.getPuaData() && null != el.getPuaData().getEnum()) {
                    puaMetadataDetails.setEnums(el.getPuaData().getEnum());
                }
                if (null != el.getPuaData() && null != el.getPuaData().getPattern()) {
                    puaMetadataDetails.setPattern(el.getPuaData().getPattern());
                }
                if (puaMetadataDetails.getType().equals("array")) {
                    this.getMinAndMaxItems(el, puaMetadataDetails);
                }
                this.setMetadataName(el);
                if (CollectionUtils.isNotEmpty(el.getChildren()) && CollectionUtils.isNotEmpty(requiredProperties = this.getRequiredProperties(sedaTree, el))) {
                    puaMetadataDetails.setRequired(requiredProperties);
                }
                if (el.getName().equals("SignedObjectDigest")) {
                    this.setElementIfSignedObjectDigest(el);
                    List<String> required = puaMetadataDetails.getRequired();
                    required.add("MessageDigest");
                    puaMetadataDetails.setRequired(required);
                }
                this.setChildName(elementProperties, json, el, puaMetadataDetails);
                if (!el.getChildren().isEmpty()) {
                    if (null != el.getPuaData() && null != el.getPuaData().getAdditionalProperties()) {
                        json.getJSONObject(el.getName()).put(ADDITIONAL_PROPERTIES, (Object)el.getPuaData().getAdditionalProperties());
                    }
                    if (puaMetadataDetails.getType().equals("array")) {
                        items = new JSONObject();
                        items.put(TYPE, (Object)OBJECT);
                        items.put(ADDITIONAL_PROPERTIES, (Object)el.getPuaData().getAdditionalProperties());
                        json.getJSONObject(el.getName()).remove(REQUIRED);
                        json.getJSONObject(el.getName()).put(ITEMS, (Object)items);
                        json.getJSONObject(el.getName()).remove(ADDITIONAL_PROPERTIES);
                        json.getJSONObject(el.getName()).getJSONObject(ITEMS).put(PROPERTIES, (Object)new JSONObject((Object)new PuaData()));
                        if (null != puaMetadataDetails.getRequired() && !puaMetadataDetails.getRequired().isEmpty()) {
                            json.getJSONObject(el.getName()).getJSONObject(ITEMS).put(REQUIRED, puaMetadataDetails.getRequired());
                        }
                        this.getJSONObjectFromElement(sedaTree, el, json.getJSONObject(el.getName()).getJSONObject(ITEMS).getJSONObject(PROPERTIES));
                        continue;
                    }
                    json.getJSONObject(el.getName()).put(PROPERTIES, (Object)new JSONObject());
                    this.getJSONObjectFromElement(sedaTree, el, json.getJSONObject(el.getName()).getJSONObject(PROPERTIES));
                    continue;
                }
                if (!puaMetadataDetails.getType().equals("array")) continue;
                items = new JSONObject();
                items.put(TYPE, (Object)OBJECT);
                if (null != el.getPuaData() && null != el.getPuaData().getAdditionalProperties()) {
                    items.put(ADDITIONAL_PROPERTIES, (Object)el.getPuaData().getAdditionalProperties());
                }
                ArrayList keyToDelete = new ArrayList();
                json.getJSONObject(el.getName()).keySet().forEach(key -> {
                    if (!key.equals(TYPE)) {
                        keyToDelete.add(key);
                    }
                });
                keyToDelete.forEach(e -> json.getJSONObject(el.getName()).remove(e));
                puaMetadataDetails.setType(STRING);
                json.getJSONObject(el.getName()).remove(ADDITIONAL_PROPERTIES);
                if (null != puaMetadataDetails.getMinItems()) {
                    json.getJSONObject(el.getName()).put("minItems", (Object)puaMetadataDetails.getMinItems());
                    puaMetadataDetails.setMinItems(null);
                }
                if (null != puaMetadataDetails.getMaxItems()) {
                    json.getJSONObject(el.getName()).put("maxItems", (Object)puaMetadataDetails.getMaxItems());
                    puaMetadataDetails.setMaxItems(null);
                }
                json.getJSONObject(el.getName()).put(ITEMS, (Object)new JSONObject(puaMetadataDetails.serialiseString()));
            }
        }
    }

    private void setElementIfSignedObjectDigest(ElementProperties el) {
        List<ElementProperties> childrens = el.getChildren();
        ElementProperties messageDigest = new ElementProperties();
        messageDigest.setName("MessageDigest");
        messageDigest.setCardinality(CARDINALITY_1);
        childrens.add(messageDigest);
        el.setChildren(childrens);
    }

    private void setMetadataName(ElementProperties child) {
        switch (child.getName()) {
            case "EventIdentifier": {
                child.setName("evId");
                break;
            }
            case "EventTypeCode": {
                child.setName("evTypeProc");
                break;
            }
            case "EventType": {
                child.setName("evType");
                break;
            }
            case "EventDateTime": {
                child.setName("evDateTime");
                break;
            }
            case "EventDetail": {
                child.setName("evTypeDetail");
                break;
            }
            case "Outcome": {
                child.setName("outcome");
                break;
            }
            case "OutcomeDetail": {
                child.setName("outDetail");
                break;
            }
            case "OutcomeDetailMessage": {
                child.setName("outMessg");
                break;
            }
            case "EventDetailData": {
                child.setName("evDetData");
                break;
            }
            case "algorithm": {
                child.setName("Algorithm");
                break;
            }
        }
    }

    private void setChildName(ElementProperties elementProperties, JSONObject json, ElementProperties el, PuaMetadataDetails puaMetadataDetails) throws JsonProcessingException {
        json.put(el.getName(), (Object)new JSONObject(puaMetadataDetails.serialiseString()));
    }

    private List<String> getRequiredProperties(SedaNode sedaTree, ElementProperties elementProperties) {
        ArrayList<String> listRequired = new ArrayList<String>();
        elementProperties.getChildren().forEach(child -> {
            try {
                SedaNode sedaElement = this.getSedaMetadata(sedaTree, child.getName(), elementProperties.getName());
                if (child.getCardinality().equals(CARDINALITY_1_N) && (sedaElement.getCardinality().equals(CARDINALITY_0_N) || sedaElement.getCardinality().equals(CARDINALITY_1_N)) || child.getCardinality().equals(CARDINALITY_1) && !sedaElement.getCardinality().equals(CARDINALITY_1) || sedaElement.getCardinality().equals(CARDINALITY_1)) {
                    this.setMetadataName((ElementProperties)child);
                    listRequired.add(child.getName());
                    child.setName(sedaElement.getName());
                }
            }
            catch (IOException e) {
                LOGGER.debug(e.getMessage());
            }
        });
        return listRequired;
    }

    public List<ElementProperties> ignoreMetadata(ElementProperties elementProperties) {
        List<String> metadataToIgnore = Arrays.asList("DescriptiveMetadata", "ArchiveUnit");
        return elementProperties.flattened().filter(child -> !metadataToIgnore.contains(child.getName()) && child.getType().equals("element")).collect(Collectors.toList());
    }

    public List<String> getHeadRequired(SedaNode sedaTree, List<ElementProperties> elementsFromTree) {
        ArrayList<String> list = new ArrayList<String>();
        elementsFromTree.forEach(element -> {
            try {
                SedaNode sedaElement = this.getSedaMetadata(sedaTree, element.getName(), null);
                ElementProperties parent = this.getElementById(elementsFromTree, element.getParentId());
                if (parent != null && (parent.getName().equals(CONTENT) || element.getName().equals("ArchiveUnitProfile")) && (element.getCardinality().equals(CARDINALITY_1_N) && sedaElement.getCardinality().equals(CARDINALITY_0_N) || element.getCardinality().equals(CARDINALITY_1) && !sedaElement.getCardinality().equals(CARDINALITY_1) || sedaElement.getCardinality().equals(CARDINALITY_1)) || element.getName().equals(MANAGEMENT) && element.getCardinality().equals(CARDINALITY_1) || element.getName().equals("ArchiveUnitProfile") && element.getCardinality().equals(CARDINALITY_1)) {
                    if (element.getName().equals(MANAGEMENT) && !element.getChildren().isEmpty()) {
                        list.add(MANAGEMENTCONTROL);
                    } else {
                        list.add(element.getName());
                    }
                }
            }
            catch (IOException e) {
                LOGGER.debug(e.getMessage());
            }
        });
        return list;
    }

    private void getMetaDataFromSeda(ElementProperties el, PuaMetadataDetails puaMetadataDetails, SedaNode sedaElement) {
        puaMetadataDetails.setType(this.resolvePuaType(sedaElement, el));
        puaMetadataDetails.setDescription(el.getDocumentation());
        if (sedaElement.getElement().equals(COMPLEX) && el.getPuaData() != null && el.getPuaData().getAdditionalProperties() != null) {
            puaMetadataDetails.setAdditionalProperties(el.getPuaData().getAdditionalProperties());
        }
        if (el.getCardinality() != null && puaMetadataDetails.getType().equals("array")) {
            this.getMinAndMaxItems(el, puaMetadataDetails);
        }
        Optional.ofNullable(el.getPuaData()).map(PuaData::getPattern).ifPresent(puaMetadataDetails::setPattern);
        if (el.getPuaData() != null && el.getPuaData().getEnum() != null) {
            puaMetadataDetails.setEnums(el.getPuaData().getEnum());
        } else if (el.getValue() != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(el.getValue());
            puaMetadataDetails.setEnums(list);
        }
    }

    private void getMinAndMaxItems(ElementProperties el, PuaMetadataDetails puaMetadataDetails) {
        switch (el.getCardinality()) {
            case "1": {
                puaMetadataDetails.setMinItems(1);
                puaMetadataDetails.setMaxItems(1);
                break;
            }
            case "0-1": {
                puaMetadataDetails.setMinItems(0);
                puaMetadataDetails.setMaxItems(1);
                break;
            }
            case "1-N": {
                puaMetadataDetails.setMinItems(1);
                break;
            }
        }
    }

    private ElementProperties getElementById(List<ElementProperties> elementProperties, Long id) {
        for (ElementProperties el : elementProperties) {
            Long elementId = el.getId();
            if (elementId == null || !elementId.equals(id)) continue;
            return el;
        }
        return null;
    }

    private JSONArray sortedJSONArray() {
        JSONArray jsonArray = new JSONArray();
        try {
            Field changeMap = jsonArray.getClass().getDeclaredField("map");
            changeMap.setAccessible(true);
            changeMap.set(jsonArray, new LinkedHashMap());
            changeMap.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.debug(e.getMessage());
        }
        return jsonArray;
    }
}

