/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.dto;

import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.util.RNGConstants;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ElementRNG {
    private static ElementProperties elementStatic = new ElementProperties();
    private static ElementProperties elementStaticRoot = new ElementProperties();
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementRNG.class);
    private static long idCounter = 0L;
    String name;
    String type;
    String dataType;
    String value;
    ElementRNG parent;
    List<ElementRNG> children = new ArrayList<ElementRNG>();

    public static void setDataForParentElementOrAttribute(ElementProperties parentNode, ElementRNG node) {
        if (null != parentNode.getType() && (RNGConstants.MetadaDataType.ELEMENT.getLabel().equals(parentNode.getType()) || RNGConstants.MetadaDataType.ATTRIBUTE.getLabel().equals(parentNode.getType()))) {
            parentNode.setValueOrData(node.getType());
            if (RNGConstants.getTypesMap().containsKey(parentNode.getName())) {
                parentNode.setDataType(RNGConstants.getTypesMap().get(parentNode.getName()).getLabel());
            }
            parentNode.setValue(node.getValue());
        } else {
            ElementRNG.setDataForParentElementOrAttribute(parentNode.getParent(), node);
        }
    }

    public static void setDocumentationForParentElement(ElementProperties parentNode, ElementRNG node) {
        if (null != parentNode.getType() && RNGConstants.MetadaDataType.ELEMENT.getLabel().equals(parentNode.getType())) {
            if (parentNode.getName() != null && parentNode.getName().equals("ArchiveUnit") && node.getValue().contains("Commentaire : ")) {
                parentNode.setDocumentation(node.getValue().replace("Commentaire : ", ""));
                if (parentNode.getDocumentation() != null) {
                    parentNode.setEditName(parentNode.getDocumentation());
                }
            } else if (parentNode.getDocumentation() != null) {
                parentNode.setEditName(node.getValue());
            } else {
                parentNode.setDocumentation(node.getValue());
            }
        } else {
            ElementRNG.setDocumentationForParentElement(parentNode.getParent(), node);
        }
    }

    public static void buildElementPropertiesTree(ElementRNG node, int profondeur, ElementProperties parentNode) {
        ElementProperties local = new ElementProperties();
        LOGGER.trace("Generating JSON element {}", (Object)node.getName());
        if (null != node.getType() && RNGConstants.MetadaDataType.ELEMENT.getLabel().equals(node.getType()) || RNGConstants.MetadaDataType.ATTRIBUTE.getLabel().equals(node.getType())) {
            local.setCardinality(elementStatic.getCardinality());
            local.setGroupOrChoice(elementStatic.getGroupOrChoice());
            local.setName(node.getName());
            local.setType(node.getType());
            local.setLevel(profondeur);
            local.setValue(node.getValue());
            elementStatic = new ElementProperties();
            if (null != parentNode) {
                local.setParent(parentNode);
                local.setParentId(parentNode.getId());
                local.setId(idCounter++);
                parentNode.getChildren().add(local);
            } else {
                local.setId(idCounter++);
                local.setParentId(null);
                elementStaticRoot = local;
            }
        } else {
            if (RNGConstants.isValueOrData(node.getType())) {
                ElementRNG.setDataForParentElementOrAttribute(parentNode, node);
            } else if (RNGConstants.isCardinality(node.getType())) {
                elementStatic.setCardinality(node.getType());
            } else if (RNGConstants.hasGroupOrChoice(node.getType())) {
                elementStatic.setGroupOrChoice(node.getType());
            } else if ("documentation".equals(node.getType()) && null != node.getValue()) {
                ElementRNG.setDocumentationForParentElement(parentNode, node);
            }
            local = parentNode;
        }
        ElementRNG.buildTree(node, profondeur, local);
    }

    private static void buildTree(ElementRNG node, int profondeur, ElementProperties local) {
        for (ElementRNG next : node.getChildren()) {
            if (null != next.getType() && (RNGConstants.MetadaDataType.ELEMENT.getLabel().equals(next.getType()) || RNGConstants.MetadaDataType.ATTRIBUTE.getLabel().equals(next.getType()))) {
                ElementRNG.buildElementPropertiesTree(next, profondeur + 1, local);
                continue;
            }
            ElementRNG.buildElementPropertiesTree(next, profondeur, local);
        }
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @XmlElement
    public String getType() {
        return this.type;
    }

    @XmlAttribute(name="type")
    public String getDataType() {
        return this.dataType;
    }

    @XmlElement(name="rng:value")
    public String getValue() {
        return this.value;
    }

    @XmlTransient
    public ElementRNG getParent() {
        return this.parent;
    }

    @XmlAnyElement
    public List<ElementRNG> getChildren() {
        return this.children;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setParent(ElementRNG parent) {
        this.parent = parent;
    }

    @Generated
    public void setChildren(List<ElementRNG> children) {
        this.children = children;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementRNG)) {
            return false;
        }
        ElementRNG other = (ElementRNG)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        ElementRNG this$parent = this.getParent();
        ElementRNG other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        List<ElementRNG> this$children = this.getChildren();
        List<ElementRNG> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ElementRNG;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        ElementRNG $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        List<ElementRNG> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ElementRNG(name=" + this.getName() + ", type=" + this.getType() + ", dataType=" + this.getDataType() + ", value=" + this.getValue() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ")";
    }

    @Generated
    public ElementRNG() {
    }

    @Generated
    public static ElementProperties getElementStaticRoot() {
        return elementStaticRoot;
    }
}

