/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.common.utils;

import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.common.utils.IdentityProviderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class IdentityProviderHelperTest {
    private final IdentityProviderHelper helper = new IdentityProviderHelper();
    private static final String PATTERN = ".*@vitamui\\.com";
    private static final String GOOD_EMAIL = "user1@vitamui.com";
    private static final String GOOD_UPPERCASE_EMAIL = "useR1@Vitamui.Com";
    private static final String BAD_EMAIL = "user2@test.com";
    private static final String CUSTOMER_ID_1 = "customerId1";
    private static final String CUSTOMER_ID_2 = "customerId2";
    private static final String NAME_1 = "idp007";
    private static final String NAME_2 = "idp008";

    @Test
    public void testFindByUserIdentifierOk() {
        List<IdentityProviderDto> providers = this.buildProviders(true);
        Optional result = this.helper.findByUserIdentifierAndCustomerId(providers, GOOD_EMAIL, CUSTOMER_ID_1);
        Assertions.assertEquals((Object)providers.get(0), result.get());
    }

    @Test
    public void testFindByUserIdentifierOkWhenEmailWithDifferentCase() {
        List<IdentityProviderDto> providers = this.buildProviders(true);
        List result = this.helper.findAllProvidersByUserIdentifier(providers, GOOD_UPPERCASE_EMAIL);
        Assertions.assertEquals((Object)providers.get(0), result.get(0));
    }

    @Test
    public void testFindByUserIdentifierOkWhenEmailUpperCase() {
        List<IdentityProviderDto> providers = this.buildProviders(true);
        Optional result = this.helper.findByUserIdentifierAndCustomerId(providers, GOOD_UPPERCASE_EMAIL, CUSTOMER_ID_1);
        Assertions.assertEquals((Object)providers.get(0), result.get());
    }

    @Test
    public void testFindByUserIdentifierKo() {
        List<IdentityProviderDto> providers = this.buildProviders(true);
        Optional result = this.helper.findByUserIdentifierAndCustomerId(providers, BAD_EMAIL, CUSTOMER_ID_1);
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testFindByTechnicalNameOk() {
        List<IdentityProviderDto> providers = this.buildProviders(true);
        Optional result = this.helper.findByTechnicalName(providers, NAME_1);
        Assertions.assertEquals((Object)providers.get(0), result.get());
    }

    @Test
    public void testFindByTechnicalNameKo() {
        List<IdentityProviderDto> providers = this.buildProviders(true);
        Optional result = this.helper.findByTechnicalName(providers, NAME_1.toUpperCase());
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testIsInternalOk() {
        List<IdentityProviderDto> providers = this.buildProviders(true);
        Assertions.assertTrue((boolean)this.helper.identifierMatchProviderPattern(providers, GOOD_EMAIL, CUSTOMER_ID_1));
    }

    @Test
    public void testIsInternalKoNotInternal() {
        List<IdentityProviderDto> providers = this.buildProviders(false);
        Assertions.assertFalse((boolean)this.helper.identifierMatchProviderPattern(providers, GOOD_EMAIL, CUSTOMER_ID_1));
    }

    @Test
    public void testIsInternalKoNotFound() {
        List<IdentityProviderDto> providers = this.buildProviders(true);
        Assertions.assertFalse((boolean)this.helper.identifierMatchProviderPattern(providers, BAD_EMAIL, CUSTOMER_ID_1));
    }

    private List<IdentityProviderDto> buildProviders(boolean internal) {
        ArrayList<IdentityProviderDto> providers = new ArrayList<IdentityProviderDto>();
        IdentityProviderDto provider1 = new IdentityProviderDto();
        provider1.setTechnicalName(NAME_1);
        provider1.setPatterns(List.of(PATTERN));
        provider1.setInternal(Boolean.valueOf(internal));
        provider1.setCustomerId(CUSTOMER_ID_1);
        providers.add(provider1);
        IdentityProviderDto provider2 = new IdentityProviderDto();
        provider2.setTechnicalName(NAME_2);
        provider2.setPatterns(List.of(PATTERN));
        provider2.setInternal(Boolean.valueOf(internal));
        provider2.setCustomerId(CUSTOMER_ID_2);
        providers.add(provider2);
        return providers;
    }
}

