/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.common.utils;

import fr.gouv.vitamui.commons.api.domain.AddressDto;
import fr.gouv.vitamui.commons.api.domain.ApplicationDto;
import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.LanguageDto;
import fr.gouv.vitamui.commons.api.domain.OwnerDto;
import fr.gouv.vitamui.commons.api.domain.ParameterDto;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.domain.Role;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.enums.UserStatusEnum;
import fr.gouv.vitamui.commons.api.enums.UserTypeEnum;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.common.enums.OtpEnum;
import fr.gouv.vitamui.iam.common.enums.SubrogationStatusEnum;
import fr.gouv.vitamui.iam.common.utils.DtoFactory;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class IamDtoBuilder {
    public static UserDto buildUserDto(String id, String email, String groupId, String customerId, String level) {
        UserDto userDto = new UserDto();
        userDto.setId(id);
        userDto.setEmail(email);
        userDto.setFirstname("Jean");
        userDto.setLastname("DUPONT");
        userDto.setCustomerId(customerId);
        userDto.setGroupId(groupId);
        userDto.setOtp(true);
        userDto.setIdentifier("code");
        userDto.setStatus(UserStatusEnum.ENABLED);
        userDto.setType(UserTypeEnum.NOMINATIVE);
        userDto.setUserInfoId("userInfoId");
        userDto.setLevel(level);
        userDto.setMobile("+33671270699");
        userDto.setPhone("+33134237766");
        userDto.setAddress(IamDtoBuilder.buildAddressDto());
        return userDto;
    }

    public static AuthUserDto buildAuthUserDto(String id, String email, String customerId) {
        AuthUserDto userDto = new AuthUserDto();
        userDto.setId(id);
        userDto.setEmail(email);
        userDto.setSubrogeable(true);
        userDto.setStatus(UserStatusEnum.ENABLED);
        userDto.setFirstname("Jean");
        userDto.setLastname("DUPONT");
        userDto.setCustomerId(customerId);
        userDto.setGroupId("groupId");
        userDto.setOtp(true);
        userDto.setIdentifier("code");
        userDto.setType(UserTypeEnum.NOMINATIVE);
        userDto.setUserInfoId("userInfoId");
        userDto.setLevel("level");
        userDto.setMobile("+33671270699");
        userDto.setPhone("+33134237766");
        userDto.setPasswordExpirationDate(OffsetDateTime.now().plusDays(1L));
        userDto.setIdentifier("identifier");
        return userDto;
    }

    public static ProfileDto buildProfileDto(String id, String name, String customerId, Integer tenantId, String applicationName, String level, List<Role> roles) {
        ProfileDto profileDto = DtoFactory.buildProfileDto((String)name, (String)"description", (boolean)false, (String)level, (Integer)tenantId, (String)applicationName, new ArrayList(), (String)customerId);
        profileDto.setId(id);
        profileDto.setRoles(roles);
        return profileDto;
    }

    public static ExternalParametersDto buildExternalParametersDto() {
        String PARAM_ACCESS_CONTRACT_NAME = "PARAM_ACCESS_CONTRACT";
        ExternalParametersDto externalParametersDto = new ExternalParametersDto();
        externalParametersDto.setId("externaparamidentifier");
        externalParametersDto.setParameters(List.of(new ParameterDto(PARAM_ACCESS_CONTRACT_NAME, "AC-000001")));
        externalParametersDto.setName("external parameter TNR");
        externalParametersDto.setIdentifier("externaparamidentifier");
        return externalParametersDto;
    }

    public static ApplicationDto buildApplicationDto(String id, String identifier, String url) {
        ApplicationDto applicationDto = new ApplicationDto();
        applicationDto.setId(id);
        applicationDto.setIdentifier(identifier);
        applicationDto.setUrl(url);
        return applicationDto;
    }

    public static GroupDto buildGroupDto(String id, String name, String customerId, List<String> profileIds, String level) {
        GroupDto groupDto = new GroupDto();
        groupDto.setId(id);
        groupDto.setCustomerId(customerId);
        groupDto.setProfileIds(new ArrayList<String>(profileIds));
        groupDto.setName(name);
        groupDto.setDescription("description");
        groupDto.setLevel(level);
        groupDto.setEnabled(true);
        groupDto.setReadonly(false);
        return groupDto;
    }

    public static CustomerDto buildCustomerDto(String id, String name, String code, String emailDomain) {
        CustomerDto customer = new CustomerDto();
        customer.setId(id);
        customer.setName(name);
        customer.setCode(code);
        customer.setEnabled(true);
        customer.setCompanyName("companyName");
        customer.setLanguage(LanguageDto.FRENCH);
        customer.setPasswordRevocationDelay(Integer.valueOf(6));
        customer.setOtp(OtpEnum.OPTIONAL);
        customer.setOwners(Arrays.asList(IamDtoBuilder.buildOwnerDto(null, name, id)));
        customer.setEmailDomains(Arrays.asList(emailDomain.toLowerCase()));
        customer.setDefaultEmailDomain(emailDomain.toLowerCase());
        customer.setAddress(IamDtoBuilder.buildAddressDto());
        customer.setHasCustomGraphicIdentity(false);
        return customer;
    }

    public static TenantDto buildTenantDto(String id, String name, Integer tenantIdentifier, String ownerId, String customerId) {
        TenantDto tenantDto = new TenantDto();
        tenantDto.setId(id);
        tenantDto.setEnabled(Boolean.valueOf(true));
        tenantDto.setName(name);
        tenantDto.setOwnerId(ownerId);
        tenantDto.setIdentifier(tenantIdentifier);
        tenantDto.setProof(false);
        tenantDto.setCustomerId(customerId);
        return tenantDto;
    }

    public static OwnerDto buildOwnerDto(String id, String name, String customerId) {
        OwnerDto ownerDto = new OwnerDto();
        ownerDto.setId(id);
        ownerDto.setName(name);
        ownerDto.setCompanyName(name);
        ownerDto.setCode(Integer.toString(ThreadLocalRandom.current().nextInt(1000000, 10000000)));
        ownerDto.setReadonly(false);
        ownerDto.setAddress(IamDtoBuilder.buildAddressDto());
        ownerDto.setCustomerId(customerId);
        return ownerDto;
    }

    public static SubrogationDto buildSubrogationDto(String id, String surrogate, String surrogateCustomerId, String superUser, String superUserCustomerId) {
        SubrogationDto subrogation = new SubrogationDto();
        subrogation.setId(id);
        subrogation.setDate(Instant.now());
        subrogation.setStatus(SubrogationStatusEnum.CREATED);
        subrogation.setSurrogate(surrogate);
        subrogation.setSurrogateCustomerId(surrogateCustomerId);
        subrogation.setSuperUser(superUser);
        subrogation.setSuperUserCustomerId(superUserCustomerId);
        return subrogation;
    }

    public static IdentityProviderDto buildIdentityProviderDto(String idpId, String idpName, String customerId, List<String> patterns, boolean internal, boolean autoProvisioningEnabled) {
        IdentityProviderDto idpDto = new IdentityProviderDto();
        idpDto.setId(idpId);
        idpDto.setName(idpName);
        idpDto.setCustomerId(customerId);
        idpDto.setEnabled(Boolean.valueOf(true));
        idpDto.setInternal(Boolean.valueOf(internal));
        idpDto.setPatterns(patterns);
        idpDto.setAutoProvisioningEnabled(autoProvisioningEnabled);
        return idpDto;
    }

    public static AddressDto buildAddressDto() {
        AddressDto address = new AddressDto();
        address.setCity("paris");
        address.setCountry("france");
        address.setZipCode("75009");
        address.setStreet("rue faubourg poissoni\u00e9re");
        return address;
    }
}

