/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.security.openapiclient;

import fr.gouv.vitamui.security.common.dto.ContextDto;
import fr.gouv.vitamui.security.openapiclient.invoker.ApiClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

public class ContextsApi {
    private ApiClient apiClient;

    public ContextsApi() {
        this(new ApiClient());
    }

    public ContextsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ContextDto addTenant(String id, Integer tenantIdentifier) throws RestClientException {
        return (ContextDto)this.addTenantWithHttpInfo(id, tenantIdentifier).getBody();
    }

    public ResponseEntity<ContextDto> addTenantWithHttpInfo(String id, Integer tenantIdentifier) throws RestClientException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling addTenant");
        }
        if (tenantIdentifier == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'tenantIdentifier' when calling addTenant");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        uriVariables.put("tenantIdentifier", tenantIdentifier);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<ContextDto> localReturnType = new ParameterizedTypeReference<ContextDto>(){};
        return this.apiClient.invokeAPI("/security/v1/contexts/{id}/tenant/{tenantIdentifier}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void checkExist(String id) throws RestClientException {
        this.checkExistWithHttpInfo(id);
    }

    public ResponseEntity<Void> checkExistWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling checkExist");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/security/v1/contexts/{id}", HttpMethod.HEAD, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public ContextDto create(ContextDto contextDto) throws RestClientException {
        return (ContextDto)this.createWithHttpInfo(contextDto).getBody();
    }

    public ResponseEntity<ContextDto> createWithHttpInfo(ContextDto contextDto) throws RestClientException {
        ContextDto localVarPostBody = contextDto;
        if (contextDto == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'contextDto' when calling create");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<ContextDto> localReturnType = new ParameterizedTypeReference<ContextDto>(){};
        return this.apiClient.invokeAPI("/security/v1/contexts", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void delete(String id) throws RestClientException {
        this.deleteWithHttpInfo(id);
    }

    public ResponseEntity<Void> deleteWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling delete");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/security/v1/contexts/{id}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public ContextDto findByCertificate(String body) throws RestClientException {
        return (ContextDto)this.findByCertificateWithHttpInfo(body).getBody();
    }

    public ResponseEntity<ContextDto> findByCertificateWithHttpInfo(String body) throws RestClientException {
        String localVarPostBody = body;
        if (body == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling findByCertificate");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<ContextDto> localReturnType = new ParameterizedTypeReference<ContextDto>(){};
        return this.apiClient.invokeAPI("/security/v1/contexts/certificate", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<ContextDto> getAll(String criteria) throws RestClientException {
        return (List)this.getAllWithHttpInfo(criteria).getBody();
    }

    public ResponseEntity<List<ContextDto>> getAllWithHttpInfo(String criteria) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<List<ContextDto>> localReturnType = new ParameterizedTypeReference<List<ContextDto>>(){};
        return this.apiClient.invokeAPI("/security/v1/contexts", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public ContextDto getOne(String id, String criteria) throws RestClientException {
        return (ContextDto)this.getOneWithHttpInfo(id, criteria).getBody();
    }

    public ResponseEntity<ContextDto> getOneWithHttpInfo(String id, String criteria) throws RestClientException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getOne");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<ContextDto> localReturnType = new ParameterizedTypeReference<ContextDto>(){};
        return this.apiClient.invokeAPI("/security/v1/contexts/{id}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public ContextDto update(String id, ContextDto contextDto) throws RestClientException {
        return (ContextDto)this.updateWithHttpInfo(id, contextDto).getBody();
    }

    public ResponseEntity<ContextDto> updateWithHttpInfo(String id, ContextDto contextDto) throws RestClientException {
        ContextDto localVarPostBody = contextDto;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling update");
        }
        if (contextDto == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'contextDto' when calling update");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<ContextDto> localReturnType = new ParameterizedTypeReference<ContextDto>(){};
        return this.apiClient.invokeAPI("/security/v1/contexts/{id}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}

