/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.security.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.security.common.dto.ContextDto;
import fr.gouv.vitamui.security.server.context.service.ContextService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/security/v1/contexts"})
@Tag(name="Contexts", description="Contexts Management")
public class ContextController
implements CrudController<ContextDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextController.class);
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";
    @Autowired
    private ContextService contextService;

    @GetMapping
    @Operation(operationId="contexts_getAll", summary="Get all contexts")
    public List<ContextDto> getAll(Optional<String> criteria) {
        LOGGER.debug("Get ALL");
        SanityChecker.sanitizeCriteria(criteria);
        return this.contextService.getAll(criteria).stream().collect(Collectors.toList());
    }

    @RequestMapping(path={"/{id}"}, method={RequestMethod.HEAD})
    @Operation(operationId="contexts_checkExist", summary="Check the existence of a context, by its id")
    public ResponseEntity<Void> checkExist(@PathVariable(value="id") String id) {
        LOGGER.debug("Check exists {}", (Object)id);
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        List dto = this.contextService.getMany(new String[]{id});
        return RestUtils.buildBooleanResponse((dto != null && !dto.isEmpty() ? 1 : 0) != 0);
    }

    @GetMapping(value={"/{id}"})
    @Operation(operationId="contexts_getOne", summary="Get a context by its id")
    public ContextDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get {} criteria={}", (Object)id, criteria);
        return (ContextDto)this.contextService.getOne(id, criteria);
    }

    @PostMapping(value={"/certificate"})
    @Operation(operationId="contexts_findByCertificate", summary="Find a context by certificate")
    public ContextDto findByCertificate(@Valid @RequestBody String data) {
        LOGGER.debug("Request data {} ", (Object)data);
        ParameterChecker.checkParameter((String)"The request data is a mandatory parameter: ", (String[])new String[]{data});
        return this.contextService.findByCertificate(data);
    }

    @PostMapping
    @Operation(operationId="contexts_create", summary="Create a context")
    public ContextDto create(@Valid @RequestBody ContextDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The context is a mandatory parameter: ", (Object[])new Object[]{dto});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        return (ContextDto)this.contextService.create((IdDto)dto);
    }

    @PutMapping(value={"/{id}"})
    @Operation(operationId="contexts_update", summary="Update a context")
    public ContextDto update(@PathVariable(value="id") String id, @Valid @RequestBody ContextDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier and the context are mandatory parameters: ", (Object[])new Object[]{id, dto});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        return (ContextDto)this.contextService.update((IdDto)dto);
    }

    @PutMapping(value={"/{id}/tenant/{tenantIdentifier}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(operationId="contexts_addTenant", summary="Add a tenant to a context")
    public ContextDto addTenant(@PathVariable(value="id") String id, @PathVariable(value="tenantIdentifier") Integer tenantIdentifier) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier and the tenant ID are mandatory parameters: ", (Object[])new Object[]{id, tenantIdentifier});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Update {} with {}", (Object)id, (Object)tenantIdentifier);
        return this.contextService.addTenant(id, tenantIdentifier);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(operationId="contexts_delete", summary="Remove a context")
    public void delete(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete {}", (Object)id);
        this.contextService.delete(id);
    }

    @Generated
    public ContextService getContextService() {
        return this.contextService;
    }

    @Generated
    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }
}

