/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.security.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.security.common.dto.CertificateDto;
import fr.gouv.vitamui.security.server.certificate.service.CertificateCrudService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/security/v1/certificates"})
@Tag(name="Certificates", description="Certificates Management")
public class CertificateCrudController
implements CrudController<CertificateDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateCrudController.class);
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";
    @Autowired
    private CertificateCrudService certificateCrudService;

    @GetMapping
    @Operation(operationId="certificates_getAll", summary="Get all certificates")
    public List<CertificateDto> getAll(Optional<String> criteria) {
        LOGGER.debug("Get ALL criteria {}", criteria);
        return this.certificateCrudService.getAll(criteria);
    }

    @RequestMapping(path={"/{id}"}, method={RequestMethod.HEAD})
    @Operation(operationId="certificates_checkExist", summary="Check the existence of a certificate")
    public ResponseEntity<Void> checkExist(@PathVariable(value="id") String id) {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        LOGGER.debug("Check exists {}", (Object)id);
        List dto = this.certificateCrudService.getMany(new String[]{id});
        return RestUtils.buildBooleanResponse((dto != null && !dto.isEmpty() ? 1 : 0) != 0);
    }

    @GetMapping(value={"/{id}"})
    @Operation(operationId="certificates_getOne", summary="Get a certificate by its id")
    public CertificateDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria) {
        LOGGER.debug("Get {} criteria={}", (Object)id, criteria);
        SanityChecker.sanitizeCriteria(criteria);
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        return (CertificateDto)this.certificateCrudService.getOne(id, criteria);
    }

    @PostMapping
    @Operation(operationId="certificates_create", summary="Create a certificate")
    public CertificateDto create(@Valid @RequestBody CertificateDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        return (CertificateDto)this.certificateCrudService.create((IdDto)dto);
    }

    @PutMapping(value={"/{id}"})
    @Operation(operationId="certificates_update", summary="Update a certificate")
    public CertificateDto update(@PathVariable(value="id") String id, @Valid @RequestBody CertificateDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier and the certificate are mandatory parameters: ", (Object[])new Object[]{id, dto});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        return (CertificateDto)this.certificateCrudService.update((IdDto)dto);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(operationId="certificates_delete", summary="Remove a certificate")
    public void delete(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete {}", (Object)id);
        this.certificateCrudService.delete(id);
    }

    @Generated
    public CertificateCrudService getCertificateCrudService() {
        return this.certificateCrudService;
    }

    @Generated
    public void setCertificateCrudService(CertificateCrudService certificateCrudService) {
        this.certificateCrudService = certificateCrudService;
    }
}

