/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.security.server.config;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenAPIConfig {
    @Value(value="${spring.application.name}")
    private String applicationName;

    @Bean
    public OpenAPI getOpenAPI() {
        return new OpenAPI().info(new Info().title(this.applicationName).contact(new Contact().name("Programme Vitam").email("contact@programmevitam.fr"))).components(new Components().addSecuritySchemes("bearer", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").in(SecurityScheme.In.HEADER).description("Bearer token")).addSecuritySchemes("x-tenant-id", new SecurityScheme().type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER).name("X-Tenant-Id").description("Tenant ID"))).addSecurityItem(new SecurityRequirement().addList("bearer").addList("x-tenant-id"));
    }
}

