/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.security.server.certificate.service;

import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.security.common.dto.CertificateDto;
import fr.gouv.vitamui.security.server.certificate.dao.CertificateRepository;
import fr.gouv.vitamui.security.server.certificate.domain.Certificate;
import fr.gouv.vitamui.security.server.context.service.ContextService;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class CertificateCrudService
extends VitamUICrudService<CertificateDto, Certificate> {
    private final CertificateRepository certificateRepository;
    private final ContextService contextCrudService;

    @Autowired
    public CertificateCrudService(SequenceGeneratorService sequenceGeneratorService, CertificateRepository certificateRepository, ContextService contextCrudService) {
        super(sequenceGeneratorService);
        this.certificateRepository = certificateRepository;
        this.contextCrudService = contextCrudService;
    }

    protected void beforeCreate(CertificateDto dto) {
        String contextId = dto.getContextId();
        List contexts = this.contextCrudService.getMany(new String[]{contextId});
        Assert.isTrue((contexts != null && !contexts.isEmpty() ? 1 : 0) != 0, (String)("The context: " + contextId + " does not exist."));
    }

    protected void beforeUpdate(CertificateDto dto) {
        String contextId = dto.getContextId();
        List contexts = this.contextCrudService.getMany(new String[]{contextId});
        Assert.isTrue((contexts != null && !contexts.isEmpty() ? 1 : 0) != 0, (String)("The context: " + contextId + " does not exist."));
    }

    protected Certificate internalConvertFromDtoToEntity(CertificateDto dto) {
        Certificate certificate = new Certificate();
        certificate.setId(dto.getId());
        certificate.setSubjectDN(dto.getSubjectDN());
        certificate.setContextId(dto.getContextId());
        certificate.setSerialNumber(dto.getSerialNumber());
        certificate.setIssuerDN(dto.getIssuerDN());
        String data = dto.getData().replaceAll("\\n", "").replaceFirst("-----BEGIN CERTIFICATE-----", "").replaceFirst("-----END CERTIFICATE-----", "");
        certificate.setData(data);
        return certificate;
    }

    public CertificateDto internalConvertFromEntityToDto(Certificate certificate) {
        CertificateDto dto = new CertificateDto();
        dto.setId(certificate.getId());
        dto.setSubjectDN(certificate.getSubjectDN());
        dto.setContextId(certificate.getContextId());
        dto.setSerialNumber(certificate.getSerialNumber());
        dto.setIssuerDN(certificate.getIssuerDN());
        dto.setData(certificate.getData());
        return dto;
    }

    protected CertificateRepository getRepository() {
        return this.certificateRepository;
    }

    protected String getObjectName() {
        return "certificate";
    }

    protected Class<Certificate> getEntityClass() {
        return Certificate.class;
    }

    @Generated
    public CertificateRepository getCertificateRepository() {
        return this.certificateRepository;
    }

    @Generated
    public ContextService getContextCrudService() {
        return this.contextCrudService;
    }
}

