/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.common.utils;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.openid.connect.sdk.Nonce;
import fr.gouv.vitamui.commons.api.exception.InvalidFormatException;
import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.common.enums.AuthnRequestBindingEnum;
import fr.gouv.vitamui.iam.common.utils.CustomTokenValidator;
import jakarta.validation.constraints.NotNull;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.profile.creator.TokenValidator;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class Pac4jClientBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jClientBuilder.class);
    @Value(value="${login.url}")
    @NotNull
    private String casLoginUrl;

    public Optional<IndirectClient> buildClient(IdentityProviderDto provider) {
        String technicalName = provider.getTechnicalName();
        String keystoreBase64 = provider.getKeystoreBase64();
        String keystorePassword = provider.getKeystorePassword();
        String privateKeyPassword = provider.getPrivateKeyPassword();
        String idpMetadata = provider.getIdpMetadata();
        String clientId = provider.getClientId();
        String clientSecret = provider.getClientSecret();
        String discoveryUrl = provider.getDiscoveryUrl();
        try {
            if (StringUtils.isNotBlank((CharSequence)this.casLoginUrl)) {
                if (technicalName != null && keystoreBase64 != null && keystorePassword != null && privateKeyPassword != null && idpMetadata != null) {
                    byte[] keystore = Base64.getDecoder().decode(keystoreBase64);
                    String entityIdUrl = this.casLoginUrl + "/" + technicalName;
                    SAML2Configuration saml2Config = new SAML2Configuration((Resource)new ByteArrayResource(keystore), keystorePassword, privateKeyPassword, (Resource)new ByteArrayResource(idpMetadata.getBytes()));
                    saml2Config.setServiceProviderEntityId(entityIdUrl);
                    saml2Config.setForceServiceProviderMetadataGeneration(false);
                    Integer maximumAuthenticationLifetime = provider.getMaximumAuthenticationLifetime();
                    if (maximumAuthenticationLifetime != null) {
                        saml2Config.setMaximumAuthenticationLifetime((long)maximumAuthenticationLifetime.intValue());
                    }
                    if (provider.getAuthnRequestBinding() == AuthnRequestBindingEnum.GET) {
                        saml2Config.setAuthnRequestBindingType("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                    } else {
                        saml2Config.setAuthnRequestBindingType("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
                    }
                    Boolean authnRequestSigned = provider.getAuthnRequestSigned();
                    saml2Config.setAuthnRequestSigned(authnRequestSigned != null ? authnRequestSigned : true);
                    Boolean wantsAssertionsSigned = provider.getWantsAssertionsSigned();
                    saml2Config.setWantsAssertionsSigned(wantsAssertionsSigned != null ? wantsAssertionsSigned : true);
                    SAML2Client saml2Client = new SAML2Client(saml2Config);
                    this.setCallbackUrl((IndirectClient)saml2Client, technicalName);
                    saml2Client.init();
                    return Optional.of(saml2Client);
                }
                if (clientId != null && clientSecret != null && discoveryUrl != null) {
                    Boolean useState;
                    Map<String, String> customParams;
                    OidcConfiguration oidcConfiguration = new OidcConfiguration();
                    oidcConfiguration.setClientId(clientId);
                    oidcConfiguration.setSecret(clientSecret);
                    oidcConfiguration.setDiscoveryURI(discoveryUrl);
                    String scope = provider.getScope();
                    oidcConfiguration.setScope(scope != null ? scope : "openid");
                    String algo = provider.getPreferredJwsAlgorithm();
                    if (StringUtils.isNotBlank((CharSequence)algo)) {
                        oidcConfiguration.setPreferredJwsAlgorithm(JWSAlgorithm.parse((String)algo));
                    }
                    if ((customParams = provider.getCustomParams()) != null) {
                        oidcConfiguration.setCustomParams(customParams);
                    }
                    oidcConfiguration.setWithState((useState = provider.getUseState()) != null ? useState : true);
                    Boolean useNonce = provider.getUseNonce();
                    oidcConfiguration.setUseNonce(useNonce != null ? useNonce : true);
                    Boolean usePkce = provider.getUsePkce();
                    oidcConfiguration.setDisablePkce(usePkce != null ? !usePkce.booleanValue() : true);
                    oidcConfiguration.setStateGenerator((context, store) -> new Nonce().toString());
                    oidcConfiguration.setTokenValidator((TokenValidator)new CustomTokenValidator(oidcConfiguration));
                    OidcClient oidcClient = new OidcClient(oidcConfiguration);
                    this.setCallbackUrl((IndirectClient)oidcClient, technicalName);
                    oidcClient.init();
                    return Optional.of(oidcClient);
                }
            }
        }
        catch (TechnicalException e) {
            String message = e.getMessage() + " with provider identifier: " + provider.getIdentifier();
            if (message.contains("Error loading keystore")) {
                throw new InvalidFormatException(message, "INVALID_KEYSTORE_PASSWORD");
            }
            if (message.contains("Can't obtain SP private key")) {
                throw new InvalidFormatException(message, "INVALID_PRIVATE_KEYSTORE_PASSWORD");
            }
            if (message.equals("Error parsing idp Metadata")) {
                throw new InvalidFormatException(message, "INVALID_FORMAT_IDP_METADATA");
            }
            LOGGER.error("Cannot build pac4j client with provider identifier: " + provider.getIdentifier(), (Throwable)e);
        }
        return Optional.empty();
    }

    private void setCallbackUrl(IndirectClient client, String technicalName) {
        client.setName(technicalName);
        client.setCallbackUrl(this.casLoginUrl);
    }

    @Generated
    public String getCasLoginUrl() {
        return this.casLoginUrl;
    }

    @Generated
    public void setCasLoginUrl(String casLoginUrl) {
        this.casLoginUrl = casLoginUrl;
    }
}

