/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.user.service;

import fr.gouv.vitamui.commons.api.domain.LanguageDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.domain.UserInfoDto;
import fr.gouv.vitamui.commons.api.enums.UserStatusEnum;
import fr.gouv.vitamui.commons.api.enums.UserTypeEnum;
import fr.gouv.vitamui.commons.rest.client.RestClientFactory;
import fr.gouv.vitamui.iam.common.utils.IdentityProviderHelper;
import fr.gouv.vitamui.iam.server.idp.service.IdentityProviderService;
import fr.gouv.vitamui.iam.server.user.service.UserInfoService;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class UserEmailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserEmailService.class);
    @Value(value="${cas.reset.password.url}")
    @NotNull
    private String casResetPasswordUrl;
    @Autowired
    private IdentityProviderHelper identityProviderHelper;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private IdentityProviderService internalIdentityProviderService;
    private final RestClientFactory restClientFactory;

    public UserEmailService(RestClientFactory restClientFactory) {
        this.restClientFactory = restClientFactory;
    }

    public void sendCreationEmail(UserDto userDto) {
        List providers;
        if (userDto != null && userDto.getStatus() == UserStatusEnum.ENABLED && userDto.getType() == UserTypeEnum.NOMINATIVE && this.identityProviderHelper.identifierMatchProviderPattern(providers = this.internalIdentityProviderService.getAll(Optional.empty(), Optional.empty()), userDto.getEmail(), userDto.getCustomerId())) {
            LOGGER.debug("Sending mail after creating  user: {}", (Object)userDto.getEmail());
            UserInfoDto userInfoDto = (UserInfoDto)this.userInfoService.getOne(userDto.getUserInfoId());
            this.restClientFactory.getRestTemplate().getForEntity(this.restClientFactory.getBaseUrl() + this.casResetPasswordUrl, Boolean.class, new Object[]{userDto.getEmail(), userDto.getFirstname(), userDto.getLastname(), LanguageDto.valueOf((String)userInfoDto.getLanguage()).getLanguage(), userDto.getCustomerId()});
        }
    }

    @Generated
    public String getCasResetPasswordUrl() {
        return this.casResetPasswordUrl;
    }

    @Generated
    public IdentityProviderHelper getIdentityProviderHelper() {
        return this.identityProviderHelper;
    }

    @Generated
    public UserInfoService getUserInfoService() {
        return this.userInfoService;
    }

    @Generated
    public IdentityProviderService getInternalIdentityProviderService() {
        return this.internalIdentityProviderService;
    }

    @Generated
    public RestClientFactory getRestClientFactory() {
        return this.restClientFactory;
    }

    @Generated
    public void setIdentityProviderHelper(IdentityProviderHelper identityProviderHelper) {
        this.identityProviderHelper = identityProviderHelper;
    }

    @Generated
    public void setUserInfoService(UserInfoService userInfoService) {
        this.userInfoService = userInfoService;
    }

    @Generated
    public void setInternalIdentityProviderService(IdentityProviderService internalIdentityProviderService) {
        this.internalIdentityProviderService = internalIdentityProviderService;
    }

    @Generated
    public void setCasResetPasswordUrl(String casResetPasswordUrl) {
        this.casResetPasswordUrl = casResetPasswordUrl;
    }
}

